/*
 * Decompiled with CFR 0.152.
 */
package org.drools.simulation.fluent.simulation;

import java.io.IOException;
import org.junit.Assert;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.conf.ClockTypeOption;

public class SimulateTestBase {
    protected ReleaseId createKJar(String ... pairs) throws IOException {
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        KieFileSystem kfs = ks.newKieFileSystem();
        for (int i = 0; i < pairs.length; i += 2) {
            String id = pairs[i];
            String rule = pairs[i + 1];
            kfs.write("src/main/resources/" + id.replaceAll("\\.", "/") + "/rule" + i + ".drl", rule);
            KieBaseModel kBase1 = kproj.newKieBaseModel(id).setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM).addPackage(id);
            KieSessionModel kieSessionModel = kBase1.newKieSessionModel(id + ".KSession1").setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"pseudo"));
        }
        kfs.writeKModuleXML(kproj.toXML());
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertTrue((boolean)kieBuilder.getResults().getMessages().isEmpty());
        KieModule kieModule = kieBuilder.getKieModule();
        return kieModule.getReleaseId();
    }

    protected ReleaseId createKJarWithMultipleResources(String id, String[] resources, ResourceType[] types) throws IOException {
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        KieFileSystem kfs = ks.newKieFileSystem();
        for (int i = 0; i < resources.length; ++i) {
            String res = resources[i];
            String type = types[i].getDefaultExtension();
            kfs.write("src/main/resources/" + id.replaceAll("\\.", "/") + "/org/test/res" + i + "." + type, res);
        }
        KieBaseModel kBase1 = kproj.newKieBaseModel(id).setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksession1 = kBase1.newKieSessionModel(id + ".KSession1").setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"pseudo"));
        kfs.writeKModuleXML(kproj.toXML());
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertTrue((boolean)kieBuilder.getResults().getMessages().isEmpty());
        KieModule kieModule = kieBuilder.getKieModule();
        return kieModule.getReleaseId();
    }
}

