/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.namespace;

import java.util.List;
import java.util.Map;
import org.drools.core.event.DebugProcessEventListener;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.event.rule.DebugWorkingMemoryEventListener;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class EventListenersUtil {
    public static final String TYPE_AGENDA_EVENT_LISTENER = "agenda-event-listener";
    public static final String TYPE_PROCESS_EVENT_LISTENER = "process-event-listener";
    public static final String TYPE_WORKING_MEMORY_EVENT_LISTENER = "working-memory-event-listener";
    public static final String ELEMENT_AGENDA_EVENT_LISTENER = "agendaEventListener";
    public static final String ELEMENT_PROCESS_EVENT_LISTENER = "processEventListener";
    public static final String ELEMENT_WORKING_MEMORY_EVENT_LISTENER = "workingMemoryEventListener";

    public static void parseEventListeners(ParserContext parserContext, BeanDefinitionBuilder factory, Element element) {
        ManagedMap listeners;
        ManagedMap completeListenersMap = new ManagedMap();
        List eventListeners = DomUtils.getChildElementsByTagName((Element)element, (String)ELEMENT_AGENDA_EVENT_LISTENER);
        if (eventListeners != null) {
            listeners = EventListenersUtil.parseEventListenersByType(parserContext, eventListeners, TYPE_AGENDA_EVENT_LISTENER);
            completeListenersMap.putAll((Map)listeners);
        }
        if ((eventListeners = DomUtils.getChildElementsByTagName((Element)element, (String)ELEMENT_PROCESS_EVENT_LISTENER)) != null) {
            listeners = EventListenersUtil.parseEventListenersByType(parserContext, eventListeners, TYPE_PROCESS_EVENT_LISTENER);
            completeListenersMap.putAll((Map)listeners);
        }
        if ((eventListeners = DomUtils.getChildElementsByTagName((Element)element, (String)ELEMENT_WORKING_MEMORY_EVENT_LISTENER)) != null) {
            listeners = EventListenersUtil.parseEventListenersByType(parserContext, eventListeners, TYPE_WORKING_MEMORY_EVENT_LISTENER);
            completeListenersMap.putAll((Map)listeners);
        }
        factory.addPropertyValue("eventListeners", (Object)completeListenersMap);
    }

    private static ManagedMap parseEventListenersByType(ParserContext parserContext, List<Element> eventListeners, String listenerType) {
        ManagedMap listeners = new ManagedMap();
        for (Element listener : eventListeners) {
            ManagedList subList;
            Object obj;
            String ref = listener.getAttribute("ref");
            if (StringUtils.hasText((String)ref)) {
                if (TYPE_AGENDA_EVENT_LISTENER.equalsIgnoreCase(listenerType) || TYPE_PROCESS_EVENT_LISTENER.equalsIgnoreCase(listenerType) || TYPE_WORKING_MEMORY_EVENT_LISTENER.equalsIgnoreCase(listenerType)) {
                    ManagedList subList2 = (ManagedList)listeners.get((Object)listenerType);
                    if (subList2 == null) {
                        subList2 = new ManagedList();
                        listeners.put((Object)listenerType, (Object)subList2);
                    }
                    subList2.add((Object)new RuntimeBeanReference(ref));
                    continue;
                }
                throw new IllegalArgumentException("eventListener must be of type 'agenda-event-listener or 'process-event-listener' or 'working-memory-event-listener'.");
            }
            Element nestedBean = DomUtils.getChildElementByTagName((Element)listener, (String)"bean");
            if (nestedBean == null) {
                obj = null;
                if (TYPE_AGENDA_EVENT_LISTENER.equalsIgnoreCase(listenerType)) {
                    obj = new DebugAgendaEventListener();
                } else if (TYPE_PROCESS_EVENT_LISTENER.equalsIgnoreCase(listenerType)) {
                    obj = new DebugProcessEventListener();
                } else if (TYPE_WORKING_MEMORY_EVENT_LISTENER.equalsIgnoreCase(listenerType)) {
                    obj = new DebugWorkingMemoryEventListener();
                } else {
                    throw new IllegalArgumentException("eventListener must be of type 'agenda-event-listener or 'process-event-listener' or 'working-memory-event-listener'.");
                }
                subList = (ManagedList)listeners.get((Object)listenerType);
                if (subList == null) {
                    subList = new ManagedList();
                    listeners.put((Object)listenerType, (Object)subList);
                }
                subList.add(obj);
                continue;
            }
            obj = parserContext.getDelegate().parsePropertySubElement(nestedBean, null, null);
            subList = (ManagedList)listeners.get((Object)listenerType);
            if (subList == null) {
                subList = new ManagedList();
                listeners.put((Object)listenerType, (Object)subList);
            }
            subList.add(obj);
        }
        return listeners;
    }
}

