/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.components;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.verifier.Verifier;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.MessageType;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.drools.verifier.report.components.VerifierMessageBase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class CauseTest {
    @Test
    @Ignore(value="08-APR-2011 temporally ignoring -Rikkola-")
    public void testCauseTrace() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Assert.assertFalse((boolean)vBuilder.hasErrors());
        Assert.assertEquals((long)0L, (long)vBuilder.getErrors().size());
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Causes.drl", this.getClass()), ResourceType.DRL);
        Assert.assertFalse((boolean)verifier.hasErrors());
        Assert.assertEquals((long)0L, (long)verifier.getErrors().size());
        boolean works = verifier.fireAnalysis();
        Assert.assertTrue((boolean)works);
        VerifierReport result = verifier.getResult();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.ERROR).size());
        Collection warnings = result.getBySeverity(Severity.WARNING);
        ArrayList<VerifierMessageBase> redundancyWarnings = new ArrayList<VerifierMessageBase>();
        for (VerifierMessageBase verifierMessageBase : warnings) {
            if (!verifierMessageBase.getMessageType().equals(MessageType.REDUNDANCY)) continue;
            redundancyWarnings.add(verifierMessageBase);
        }
        Assert.assertEquals((long)1L, (long)redundancyWarnings.size());
        VerifierMessage message = (VerifierMessage)redundancyWarnings.toArray()[0];
        Assert.assertEquals((long)2L, (long)message.getImpactedRules().size());
        Assert.assertTrue((boolean)message.getImpactedRules().values().contains("Your First Rule"));
        Assert.assertTrue((boolean)message.getImpactedRules().values().contains("Your Second Rule"));
        Cause[] causes = message.getCauses().toArray(new Cause[message.getCauses().size()]);
        Assert.assertEquals((long)1L, (long)causes.length);
        causes = causes[0].getCauses().toArray(new Cause[causes[0].getCauses().size()]);
        Assert.assertEquals((long)2L, (long)causes.length);
        causes = causes[0].getCauses().toArray(new Cause[causes[0].getCauses().size()]);
        Assert.assertEquals((long)1L, (long)causes.length);
        causes = causes[0].getCauses().toArray(new Cause[causes[0].getCauses().size()]);
        Assert.assertEquals((long)1L, (long)causes.length);
        causes = causes[0].getCauses().toArray(new Cause[causes[0].getCauses().size()]);
        Assert.assertEquals((long)2L, (long)causes.length);
        Assert.assertEquals((long)0L, (long)result.getBySeverity(Severity.NOTE).size());
    }
}

