/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.missingEquality;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;

public class MissingEqualityTest
extends TestBaseOld {
    @Test
    public void testMissingEqualityInLiteralRestrictions() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("MissingEquality.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingEqualityTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Missing restriction in LiteralRestrictions"));
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Cause cause = ((VerifierMessage)o).getFaulty();
            String name = ((LiteralRestriction)cause).getRuleName();
            arrayList.add(name);
        }
        Assert.assertTrue((boolean)arrayList.remove("Missing equality 1"));
        Assert.assertTrue((boolean)arrayList.remove("Missing equality 2"));
        if (!arrayList.isEmpty()) {
            for (String string : arrayList) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testMissingEqualityInVariableRestrictions() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("MissingEquality.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingEqualityTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Missing restriction in VariableRestrictions, equal operator"));
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Cause cause = ((VerifierMessage)o).getFaulty();
            String name = ((VariableRestriction)cause).getRuleName();
            hashSet.add(name);
        }
        Assert.assertTrue((boolean)hashSet.remove("Missing equality 5"));
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testMissingEqualityInVariableRestrictions2() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("MissingEquality.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingEqualityTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Missing restriction in VariableRestrictions, unequal operator"));
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Cause cause = ((VerifierMessage)o).getFaulty();
            String name = ((VariableRestriction)cause).getRuleName();
            hashSet.add(name);
        }
        Assert.assertTrue((boolean)hashSet.remove("Missing equality 7"));
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testMissingEqualityInVariableRestrictions3() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("MissingEquality.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingEqualityTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Missing restriction in VariableRestrictions, custom operator"));
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Cause cause = ((VerifierMessage)o).getFaulty();
            String name = ((VariableRestriction)cause).getRuleName();
            hashSet.add(name);
        }
        Assert.assertTrue((boolean)hashSet.remove("Missing equality 3"));
        Assert.assertTrue((boolean)hashSet.remove("Missing equality 4"));
        Assert.assertTrue((boolean)hashSet.remove("Missing equality 6"));
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

