/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.Collection;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Gap;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;

public class RangeCheckIntegersTest
extends TestBaseOld {
    @Test
    void testSmallerOrEqual() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("rangeChecks/Integers.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForInts.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for integers, if smaller than or equal is missing"));
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        for (Object o : session.getObjects()) {
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Integer gap rule 4a")).isTrue();
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Integer gap rule 5a")).isTrue();
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testGreaterOrEqual() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("rangeChecks/Integers.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForInts.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for integers, if greater than or equal is missing"));
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        for (Object o : session.getObjects()) {
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Integer gap rule 4b")).isTrue();
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Integer gap rule 5b")).isTrue();
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testEqualAndGreaterThan() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("rangeChecks/Integers.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForInts.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for integers, equal and greater than"));
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        for (Object o : session.getObjects()) {
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Integer gap rule 1")).isTrue();
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Integer gap rule 7b")).isTrue();
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Integer gap rule 3")).isTrue();
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testEqualAndSmallerThan() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("rangeChecks/Integers.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForInts.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for integers, equal and smaller than"));
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        for (Object o : session.getObjects()) {
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Integer gap rule 1")).isTrue();
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Integer gap rule 6b")).isTrue();
        Assertions.assertThat((boolean)rulesThatHadErrors.remove("Integer gap rule 2")).isTrue();
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

