/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.io.IOException;
import java.util.Collection;
import java.util.jar.JarInputStream;
import org.assertj.core.api.Assertions;
import org.drools.io.ClassPathResource;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class VerifierTest {
    @Test
    void testVerifier() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Assertions.assertThat((boolean)vBuilder.hasErrors()).isFalse();
        Assertions.assertThat((int)vBuilder.getErrors().size()).isEqualTo(0);
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        Assertions.assertThat((int)verifier.getErrors().size()).isEqualTo(0);
        boolean works = verifier.fireAnalysis();
        Assertions.assertThat((boolean)works).isTrue();
        VerifierReport result = verifier.getResult();
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.getBySeverity(Severity.ERROR).size()).isEqualTo(0);
        Assertions.assertThat((int)result.getBySeverity(Severity.WARNING).size()).isEqualTo(6);
        Assertions.assertThat((int)result.getBySeverity(Severity.NOTE).size()).isEqualTo(1);
    }

    @Test
    void testFactTypesFromJar() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Assertions.assertThat((boolean)vBuilder.hasErrors()).isFalse();
        Assertions.assertThat((int)vBuilder.getErrors().size()).isEqualTo(0);
        Verifier verifier = vBuilder.newVerifier();
        try {
            JarInputStream jar = new JarInputStream(this.getClass().getResourceAsStream("model.jar"));
            verifier.addObjectModel(jar);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage());
        }
        verifier.addResourcesToVerify((Resource)new ClassPathResource("imports.drl", Verifier.class), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        Assertions.assertThat((int)verifier.getErrors().size()).isEqualTo(0);
        boolean works = verifier.fireAnalysis();
        Assertions.assertThat((boolean)works).isTrue();
        VerifierReport result = verifier.getResult();
        Collection objectTypes = result.getVerifierData().getAll(VerifierComponentType.OBJECT_TYPE);
        Assertions.assertThat((Iterable)objectTypes).isNotNull();
        Assertions.assertThat((int)objectTypes.size()).isEqualTo(3);
        Collection fields = result.getVerifierData().getAll(VerifierComponentType.FIELD);
        Assertions.assertThat((Iterable)fields).isNotNull();
        Assertions.assertThat((int)fields.size()).isEqualTo(10);
    }

    @Test
    void testFactTypesFromJarAndDeclarations() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Assertions.assertThat((boolean)vBuilder.hasErrors()).isFalse();
        Assertions.assertThat((int)vBuilder.getErrors().size()).isEqualTo(0);
        Verifier verifier = vBuilder.newVerifier();
        try {
            JarInputStream jar = new JarInputStream(this.getClass().getResourceAsStream("model.jar"));
            verifier.addObjectModel(jar);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage());
        }
        verifier.addResourcesToVerify((Resource)new ClassPathResource("importsAndDeclarations.drl", Verifier.class), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        Assertions.assertThat((int)verifier.getErrors().size()).isEqualTo(0);
        boolean works = verifier.fireAnalysis();
        Assertions.assertThat((boolean)works).isTrue();
        VerifierReport result = verifier.getResult();
        Collection objectTypes = result.getVerifierData().getAll(VerifierComponentType.OBJECT_TYPE);
        for (ObjectType objectType : objectTypes) {
            if (!objectType.getName().equals("VoiceCall")) continue;
            Assertions.assertThat((int)objectType.getMetadata().keySet().size()).isEqualTo(4);
        }
        Assertions.assertThat((Iterable)objectTypes).isNotNull();
        Assertions.assertThat((int)objectTypes.size()).isEqualTo(4);
        Collection fields = result.getVerifierData().getAll(VerifierComponentType.FIELD);
        Assertions.assertThat((Iterable)fields).isNotNull();
        Assertions.assertThat((int)fields.size()).isEqualTo(11);
    }

    @Test
    void testCustomRule() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfiguration vConfiguration = vBuilder.newVerifierConfiguration();
        Assertions.assertThat((boolean)vBuilder.hasErrors()).isFalse();
        Assertions.assertThat((int)vBuilder.getErrors().size()).isEqualTo(0);
        vConfiguration.getVerifyingResources().put(new ClassPathResource("FindPatterns.drl", Verifier.class), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier(vConfiguration);
        verifier.addResourcesToVerify((Resource)new ClassPathResource("Misc3.drl", Verifier.class), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        Assertions.assertThat((int)verifier.getErrors().size()).isEqualTo(0);
        boolean works = verifier.fireAnalysis();
        if (!works) {
            for (VerifierError error : verifier.getErrors()) {
                System.out.println(error.getMessage());
            }
            Assertions.fail((String)"Could not run verifier");
        }
        Assertions.assertThat((boolean)works).isTrue();
        VerifierReport result = verifier.getResult();
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.getBySeverity(Severity.ERROR).size()).isEqualTo(0);
        Assertions.assertThat((int)result.getBySeverity(Severity.WARNING).size()).isEqualTo(0);
        Assertions.assertThat((int)result.getBySeverity(Severity.NOTE).size()).isEqualTo(6);
        for (VerifierMessageBase m : result.getBySeverity(Severity.NOTE)) {
            Assertions.assertThat((String)m.getMessage()).isEqualTo("This pattern was found.");
        }
    }
}

