/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.incoherence;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.verifier.DefaultVerifierConfiguration;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.builder.ScopesAgendaFilter;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.jupiter.api.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.internal.io.ResourceFactory;

public class IncoherentRestrictionsTest
extends TestBaseOld {
    @Test
    void testApprovedTrueAndNotTrue() {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Assertions.assertThat((boolean)vBuilder.hasErrors()).isFalse();
        Assertions.assertThat((int)vBuilder.getErrors().size()).isEqualTo(0);
        String str = "";
        str = str + "package mortgages\n";
        str = str + "rule \"Bankruptcy history\"\n";
        str = str + "salience 10\n";
        str = str + "dialect \"mvel\"\n";
        str = str + "when\n";
        str = str + "Applicant( approved == \"true\" , approved != \"true\" )\n";
        str = str + "then\n";
        str = str + "end";
        DefaultVerifierConfiguration conf = new DefaultVerifierConfiguration();
        Verifier verifier = VerifierBuilderFactory.newVerifierBuilder().newVerifier((VerifierConfiguration)conf);
        verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(str)), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        Assertions.assertThat((int)verifier.getErrors().size()).isEqualTo(0);
        boolean works = verifier.fireAnalysis(new ScopesAgendaFilter(true, "knowledge-package"));
        Assertions.assertThat((boolean)works).isTrue();
        VerifierReport result = verifier.getResult();
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.getBySeverity(Severity.ERROR).size()).isEqualTo(3);
        Assertions.assertThat((int)result.getBySeverity(Severity.WARNING).size()).isEqualTo(1);
        Assertions.assertThat((int)result.getBySeverity(Severity.NOTE).size()).isEqualTo(0);
    }

    @Test
    void testIncoherentLiteralRestrictionsInSubPattern() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions in pattern possibility"));
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            hashSet.add(pattern.getRuleName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent restrictions 1")).isTrue();
        Assertions.assertThat((boolean)hashSet.remove("Incoherent restrictions 2")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testIncoherentLiteralRestrictionsInSubPatternImpossibleRanges() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions with ranges in pattern possibility, impossible ranges"));
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            hashSet.add(pattern.getRuleName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent restrictions 8")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testIncoherentLiteralRestrictionsInSubPatternImpossibleEqualityLess() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions with ranges in pattern possibility, impossible equality less or equal"));
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            hashSet.add(pattern.getRuleName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent restrictions 9")).isTrue();
        Assertions.assertThat((boolean)hashSet.remove("Incoherent restrictions 11")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testIncoherentLiteralRestrictionsInSubPatternImpossibleEqualityGreater() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions with ranges in pattern possibility, impossible equality greater"));
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            hashSet.add(pattern.getRuleName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent restrictions 10")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testIncoherentLiteralRestrictionsInSubPatternImpossibleRange() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent LiteralRestrictions with ranges in pattern possibility, impossible range"));
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            hashSet.add(pattern.getRuleName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent restrictions 7")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testIncoherentVariableRestrictionsInSubPattern() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent VariableRestrictions in pattern possibility"));
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            hashSet.add(pattern.getRuleName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent restrictions 3")).isTrue();
        Assertions.assertThat((boolean)hashSet.remove("Incoherent restrictions 4")).isTrue();
        Assertions.assertThat((boolean)hashSet.remove("Incoherent restrictions 5")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testIncoherentVariableRestrictionsInSubPatternImpossibleRange() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Restrictions.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("RestrictionsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent VariableRestrictions in pattern possibility, impossible range"));
        Iterator iter = result.getBySeverity(Severity.ERROR).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            Pattern pattern = (Pattern)((VerifierMessage)o).getFaulty();
            hashSet.add(pattern.getRuleName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent restrictions 6")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

