/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.misc;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.verifier.misc.DrlRuleParser;
import org.junit.jupiter.api.Test;

public class DrlRuleDataTest {
    @Test
    void testHandleDrl() {
        String drl = "rule \"Something\" \n ";
        drl = drl + "dialect \"Java\" \n ";
        drl = drl + "\twhen \n ";
        drl = drl + "\t\tPerson() \n ";
        drl = drl + "\t\tCheesery() \n ";
        drl = drl + "\tthen \n ";
        drl = drl + "\t\tinsert( new Person()) \n ";
        drl = drl + "\t\tinsert( new Car()) \n ";
        drl = drl + "\t\tinsert( new Cheese()) \n ";
        drl = drl + "end ";
        DrlRuleParser s = (DrlRuleParser)DrlRuleParser.findRulesDataFromDrl((String)drl).get(0);
        Assertions.assertThat((int)s.getHeader().size()).isEqualTo(1);
        Assertions.assertThat((int)s.getLhs().size()).isEqualTo(2);
        Assertions.assertThat((int)s.getRhs().size()).isEqualTo(3);
        Assertions.assertThat((String)s.getDescription()).isEqualTo("");
    }

    @Test
    void testHandleDrlNoLineBreaks() {
        String drl = "rule \"CreditScoreApproval\" \n";
        drl = drl + "\tdialect \"mvel\" \n";
        drl = drl + "\twhen    then";
        drl = drl + "\t\tapplicant.setApproved(true) \n";
        drl = drl + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = drl + "\t\tapplicant.setAge( 10 ) \n";
        drl = drl + "end";
        DrlRuleParser s = (DrlRuleParser)DrlRuleParser.findRulesDataFromDrl((String)drl).get(0);
        Assertions.assertThat((Object)s).isNotNull();
        Assertions.assertThat((int)s.getHeader().size()).isEqualTo(1);
        Assertions.assertThat((int)s.getLhs().size()).isEqualTo(0);
        Assertions.assertThat((int)s.getRhs().size()).isEqualTo(3);
        Assertions.assertThat((String)s.getDescription()).isEqualTo("");
    }

    @Test
    void testHandleDrlWithComment() {
        String drl = "# Really important information about this rule \n";
        drl = drl + "# Another line because one was not enough \n";
        drl = drl + "#  \n";
        drl = drl + "# @author: trikkola \n";
        drl = drl + "rule \"First\" \n";
        drl = drl + "\tdialect \"mvel\" \n";
        drl = drl + "\twhen \n ";
        drl = drl + "\t\tPerson() \n ";
        drl = drl + "\t\tCheesery() \n ";
        drl = drl + "\tthen \n ";
        drl = drl + "\t\tapplicant.setApproved(true) \n";
        drl = drl + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = drl + "\t\tapplicant.setAge( 10 ) \n";
        drl = drl + "end \n";
        drl = drl + "\n";
        drl = drl + "# Really important information about this rule \n";
        drl = drl + "# Another line because one was not enough \n";
        drl = drl + "#  \n";
        drl = drl + "# @author: trikkola \n";
        drl = drl + "# @created: 29.12.2001 \n";
        drl = drl + "# @edited: 5.5.2005 \n";
        drl = drl + "rule \"Second\" \n";
        drl = drl + "\tdialect \"mvel\" \n";
        drl = drl + "\twhen \n ";
        drl = drl + "\t\tPerson() \n ";
        drl = drl + "\t\tCheesery() \n ";
        drl = drl + "\tthen \n ";
        drl = drl + "\t\tapplicant.setApproved(true) \n";
        drl = drl + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = drl + "\t\tapplicant.setAge( 10 ) \n";
        drl = drl + "end";
        drl = drl + "\n";
        drl = drl + "rule \"Third\" \n";
        drl = drl + "\tdialect \"mvel\" \n";
        drl = drl + "\twhen \n ";
        drl = drl + "\t\tPerson() \n ";
        drl = drl + "\t\tCheesery() \n ";
        drl = drl + "\tthen \n ";
        drl = drl + "\t\tapplicant.setApproved(true) \n";
        drl = drl + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = drl + "\t\tapplicant.setAge( 10 ) \n";
        drl = drl + "end";
        List list = DrlRuleParser.findRulesDataFromDrl((String)drl);
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        DrlRuleParser rd = (DrlRuleParser)list.get(0);
        Assertions.assertThat((Object)rd).isNotNull();
        Assertions.assertThat((int)rd.getHeader().size()).isEqualTo(1);
        Assertions.assertThat((int)rd.getLhs().size()).isEqualTo(2);
        Assertions.assertThat((int)rd.getRhs().size()).isEqualTo(3);
        Assertions.assertThat((int)rd.getMetadata().size()).isEqualTo(1);
        Assertions.assertThat((String)rd.getDescription()).isNotNull();
        Assertions.assertThat((String)rd.getDescription()).isNotEqualTo((Object)"");
        DrlRuleParser rd2 = (DrlRuleParser)list.get(1);
        Assertions.assertThat((Object)rd2).isNotNull();
        Assertions.assertThat((int)rd2.getHeader().size()).isEqualTo(1);
        Assertions.assertThat((int)rd2.getLhs().size()).isEqualTo(2);
        Assertions.assertThat((int)rd2.getRhs().size()).isEqualTo(3);
        Assertions.assertThat((int)rd2.getMetadata().size()).isEqualTo(3);
        Assertions.assertThat((String)rd2.getDescription()).isNotNull();
        String description = "Really important information about this rule\n";
        description = description + "Another line because one was not enough\n\n";
        Assertions.assertThat((String)rd2.getDescription()).isEqualTo(description);
        Assertions.assertThat((String)rd2.getDescription()).isNotEqualTo((Object)"");
        DrlRuleParser rd3 = (DrlRuleParser)list.get(2);
        Assertions.assertThat((Object)rd3).isNotNull();
        Assertions.assertThat((int)rd3.getHeader().size()).isEqualTo(1);
        Assertions.assertThat((int)rd3.getLhs().size()).isEqualTo(2);
        Assertions.assertThat((int)rd3.getRhs().size()).isEqualTo(3);
        Assertions.assertThat((String)rd3.getDescription()).isNotNull();
        Assertions.assertThat((String)rd3.getDescription()).isEqualTo("");
    }
}

