/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.subsumption;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.verifier.Verifier;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.builder.VerifierImpl;
import org.drools.verifier.report.components.Subsumption;
import org.junit.jupiter.api.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.io.ResourceFactory;

public class SubsumptantRestrictionsTest {
    @Test
    void testVerifierLiteralRestrictionRedundancy1() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify(ResourceFactory.newClassPathResource((String)"SubsumptantRestriction1.drl", this.getClass()), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        boolean noProblems = verifier.fireAnalysis();
        Assertions.assertThat((boolean)noProblems).isTrue();
        Collection subsumptionList = ((VerifierImpl)verifier).getKnowledgeSession().getObjects((ObjectFilter)new ClassObjectFilter(Subsumption.class));
        Assertions.assertThat((int)subsumptionList.size()).isEqualTo(9);
        verifier.dispose();
    }

    @Test
    void testVerifierLiteralRestrictionRedundancy2() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify(ResourceFactory.newClassPathResource((String)"SubsumptantRestriction2.drl", this.getClass()), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        boolean noProblems = verifier.fireAnalysis();
        Assertions.assertThat((boolean)noProblems).isTrue();
        Collection subsumptionList = ((VerifierImpl)verifier).getKnowledgeSession().getObjects((ObjectFilter)new ClassObjectFilter(Subsumption.class));
        Assertions.assertThat((int)subsumptionList.size()).isEqualTo(9);
        verifier.dispose();
    }

    @Test
    void testVerifierLiteralRestrictionRedundancy3() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify(ResourceFactory.newClassPathResource((String)"SubsumptantRestriction3.drl", this.getClass()), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        boolean noProblems = verifier.fireAnalysis();
        Assertions.assertThat((boolean)noProblems).isTrue();
        Collection subsumptionList = ((VerifierImpl)verifier).getKnowledgeSession().getObjects((ObjectFilter)new ClassObjectFilter(Subsumption.class));
        Assertions.assertThat((int)subsumptionList.size()).isEqualTo(6);
        verifier.dispose();
    }

    @Test
    void testVerifierLiteralRestrictionRedundancy4() throws Exception {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        Verifier verifier = vBuilder.newVerifier();
        verifier.addResourcesToVerify(ResourceFactory.newClassPathResource((String)"SubsumptantRestriction4.drl", this.getClass()), ResourceType.DRL);
        Assertions.assertThat((boolean)verifier.hasErrors()).isFalse();
        boolean noProblems = verifier.fireAnalysis();
        Assertions.assertThat((boolean)noProblems).isTrue();
        Collection subsumptionList = ((VerifierImpl)verifier).getKnowledgeSession().getObjects((ObjectFilter)new ClassObjectFilter(Subsumption.class));
        Assertions.assertThat((int)subsumptionList.size()).isEqualTo(4);
        verifier.dispose();
    }
}

