/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.impl.Operator;
import org.drools.verifier.TestBase;
import org.drools.verifier.components.Eval;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.NumberRestriction;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.StringRestriction;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierComponent;
import org.junit.jupiter.api.Test;

public class ExprConstraintDescrVisitorTest
extends TestBase {
    @Test
    void testVisitPerson() throws Exception {
        PackageDescr packageDescr = this.getPackageDescr(this.getClass().getResourceAsStream("ExprConstraintDescr1.drl"));
        Assertions.assertThat((Object)packageDescr).isNotNull();
        this.packageDescrVisitor.visitPackageDescr(packageDescr);
        Collection allRestrictions = this.verifierData.getAll(VerifierComponentType.RESTRICTION);
        Collection allFields = this.verifierData.getAll(VerifierComponentType.FIELD);
        Assertions.assertThat((int)allRestrictions.size()).isEqualTo(3);
        Assertions.assertThat((int)allFields.size()).isEqualTo(3);
        for (Field field : allFields) {
            Assertions.assertThat((String)field.getFieldType()).isNotNull();
        }
        this.assertContainsField("name");
        this.assertContainsField("lastName");
        this.assertContainsField("age");
        this.assertContainsStringRestriction(Operator.BuiltInOperator.EQUAL.getOperator(), "toni");
        this.assertContainsStringRestriction(Operator.BuiltInOperator.NOT_EQUAL.getOperator(), "Lake");
        this.assertContainsNumberRestriction(Operator.BuiltInOperator.GREATER.getOperator(), 20);
        this.assertContainsEval("eval( true )");
    }

    @Test
    void testVisitAnd() throws Exception {
        PackageDescr packageDescr = this.getPackageDescr(this.getClass().getResourceAsStream("ExprConstraintDescr2.drl"));
        Assertions.assertThat((Object)packageDescr).isNotNull();
        this.packageDescrVisitor.visitPackageDescr(packageDescr);
        Collection allRestrictions = this.verifierData.getAll(VerifierComponentType.RESTRICTION);
        Assertions.assertThat((int)allRestrictions.size()).isEqualTo(2);
        this.assertContainsFields(1);
        this.assertContainsField("age");
        this.assertContainsNumberRestriction(Operator.BuiltInOperator.GREATER.getOperator(), 0);
        this.assertContainsNumberRestriction(Operator.BuiltInOperator.LESS.getOperator(), 100);
    }

    @Test
    void testVisitVariableRestriction() throws Exception {
        PackageDescr packageDescr = this.getPackageDescr(this.getClass().getResourceAsStream("ExprConstraintDescr3.drl"));
        Assertions.assertThat((Object)packageDescr).isNotNull();
        this.packageDescrVisitor.visitPackageDescr(packageDescr);
        Collection allRestrictions = this.verifierData.getAll(VerifierComponentType.RESTRICTION);
        Assertions.assertThat((int)allRestrictions.size()).isEqualTo(1);
        this.assertContainsFields(1);
        this.assertContainsField("age");
        this.assertContainsVariable("Test 1", "var");
        this.assertContainsVariableRestriction(Operator.BuiltInOperator.EQUAL.getOperator(), "var");
    }

    private void assertContainsEval(String eval) {
        Collection allEvals = this.verifierData.getAll(VerifierComponentType.PREDICATE);
        for (VerifierComponent component : allEvals) {
            Eval evalObject = (Eval)component;
            if (!eval.equals(evalObject.getContent())) continue;
            return;
        }
        Assertions.fail((String)String.format("Could not find Eval : %s ", eval));
    }

    private void assertContainsVariableRestriction(Operator operator, String variableName) {
        Collection allRestrictions = this.verifierData.getAll(VerifierComponentType.RESTRICTION);
        for (Restriction restriction : allRestrictions) {
            VariableRestriction variableRestriction;
            if (!(restriction instanceof VariableRestriction) || !variableName.equals((variableRestriction = (VariableRestriction)restriction).getVariable().getName()) || !operator.equals((Object)variableRestriction.getOperator())) continue;
            return;
        }
        Assertions.fail((String)String.format("Could not find VariableRestriction: Operator : %s Variable name: %s", operator, variableName));
    }

    private void assertContainsStringRestriction(Operator operator, String value) {
        Collection allRestrictions = this.verifierData.getAll(VerifierComponentType.RESTRICTION);
        for (Restriction restriction : allRestrictions) {
            StringRestriction stringLiteral;
            if (!(restriction instanceof StringRestriction) || !value.equals((stringLiteral = (StringRestriction)restriction).getValueAsString()) || !operator.equals((Object)stringLiteral.getOperator())) continue;
            return;
        }
        Assertions.fail((String)String.format("Could not find StringRestriction: Operator : %s Value: %s", operator, value));
    }

    private void assertContainsNumberRestriction(Operator operator, Number value) {
        Collection allRestrictions = this.verifierData.getAll(VerifierComponentType.RESTRICTION);
        for (Restriction restriction : allRestrictions) {
            NumberRestriction numberRestriction;
            if (!(restriction instanceof NumberRestriction) || !value.equals((numberRestriction = (NumberRestriction)restriction).getValue()) || !operator.equals((Object)numberRestriction.getOperator())) continue;
            return;
        }
        Assertions.fail((String)String.format("Could not find NumberRestriction: Operator : %s Value: %s", operator, value));
    }
}

