/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.components;

import org.assertj.core.api.Assertions;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.BooleanRestriction;
import org.drools.verifier.components.DateRestriction;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.NumberRestriction;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.StringRestriction;
import org.junit.jupiter.api.Test;

public class LiteralRestrictionTest {
    @Test
    void testSetValue() {
        Pattern pattern1 = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalBooleanRestriction = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"true");
        Assertions.assertThat((boolean)(literalBooleanRestriction instanceof BooleanRestriction)).isTrue();
        BooleanRestriction booleanRestriction = (BooleanRestriction)literalBooleanRestriction;
        Assertions.assertThat((String)booleanRestriction.getValueType()).isEqualTo("java.lang.Boolean");
        Assertions.assertThat((boolean)booleanRestriction.getValue()).isEqualTo(true);
        LiteralRestriction intLiteralRestriction = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"1");
        Assertions.assertThat((boolean)(intLiteralRestriction instanceof NumberRestriction)).isTrue();
        NumberRestriction intRestriction = (NumberRestriction)intLiteralRestriction;
        Assertions.assertThat((boolean)intRestriction.isInt()).isTrue();
        Assertions.assertThat((String)intRestriction.getValueType()).isEqualTo("java.lang.Integer");
        Assertions.assertThat((Object)intRestriction.getValue()).isEqualTo((Object)1);
        LiteralRestriction doubleLiteralRestriction = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"1.0");
        Assertions.assertThat((boolean)(doubleLiteralRestriction instanceof NumberRestriction)).isTrue();
        NumberRestriction doubleRestriction = (NumberRestriction)doubleLiteralRestriction;
        Assertions.assertThat((String)doubleRestriction.getValueType()).isEqualTo("java.lang.Double");
        Assertions.assertThat((Object)doubleRestriction.getValue()).isEqualTo((Object)1.0);
        LiteralRestriction dateLiteralRestriction = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"11-jan-2008");
        Assertions.assertThat((boolean)(dateLiteralRestriction instanceof DateRestriction)).isTrue();
        DateRestriction dateRestriction = (DateRestriction)dateLiteralRestriction;
        Assertions.assertThat((String)dateRestriction.getValueType()).isEqualTo("java.util.Date");
        LiteralRestriction stringRestriction = LiteralRestriction.createRestriction((Pattern)pattern1, (String)"test test");
        Assertions.assertThat((String)stringRestriction.getValueType()).isEqualTo("java.lang.String");
        Assertions.assertThat((String)stringRestriction.getValueAsString()).isEqualTo("test test");
        LiteralRestriction nullRestriction = LiteralRestriction.createRestriction((Pattern)pattern1, null);
        Assertions.assertThat((boolean)(nullRestriction instanceof StringRestriction)).isTrue();
        Assertions.assertThat((String)nullRestriction.getValueType()).isEqualTo("Unknown");
        Assertions.assertThat((String)nullRestriction.getValueAsString()).isEqualTo("");
    }
}

