/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.jarloader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarInputStream;
import org.assertj.core.api.Assertions;
import org.drools.verifier.Verifier;
import org.drools.verifier.jarloader.PackageHeaderLoader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PackageHeaderLoaderTest {
    private ArrayList<JarInputStream> jarInputStreams;

    @BeforeEach
    public void setUp() throws Exception {
        this.jarInputStreams = new ArrayList();
        this.jarInputStreams.add(new JarInputStream(Verifier.class.getResourceAsStream("model.jar")));
    }

    @AfterEach
    public void tearDown() throws Exception {
        for (JarInputStream jarInputStream : this.jarInputStreams) {
            jarInputStream.close();
        }
    }

    @Test
    void testListAddressAndPetImport() throws Exception {
        PackageHeaderLoader packageHeaderLoader = this.getPackageHeaderLoader("org.test.Rambo", "org.test.Pet");
        Collection classNames = packageHeaderLoader.getClassNames();
        Assertions.assertThat((int)classNames.size()).isEqualTo(2);
        Assertions.assertThat((boolean)classNames.contains("org.test.Rambo")).isTrue();
        Assertions.assertThat((boolean)classNames.contains("org.test.Pet")).isTrue();
    }

    @Test
    void testListFewClassesThatDoNotExist() throws Exception {
        PackageHeaderLoader packageHeaderLoader = this.getPackageHeaderLoader("org.test.Rambo", "i.do.not.Exist", "me.Neither");
        Collection classNames = packageHeaderLoader.getClassNames();
        Collection missingClasses = packageHeaderLoader.getMissingClasses();
        Assertions.assertThat((int)classNames.size()).isEqualTo(3);
        Assertions.assertThat((int)missingClasses.size()).isEqualTo(2);
    }

    @Test
    void testListFields() throws Exception {
        PackageHeaderLoader packageHeaderLoader = this.getPackageHeaderLoader("org.test.Person");
        Collection fieldNames = packageHeaderLoader.getFieldNames("org.test.Person");
        Assertions.assertThat((boolean)fieldNames.contains("birhtday")).isTrue();
        Assertions.assertThat((boolean)fieldNames.contains("firstName")).isTrue();
        Assertions.assertThat((boolean)fieldNames.contains("lastName")).isTrue();
        Assertions.assertThat((boolean)fieldNames.contains("pets")).isTrue();
        Assertions.assertThat((boolean)fieldNames.contains("this")).isTrue();
        Assertions.assertThat((String)packageHeaderLoader.getFieldType("org.test.Person", "firstName")).isEqualTo("java.lang.String");
        Assertions.assertThat((String)packageHeaderLoader.getFieldType("org.test.Person", "firstName")).isEqualTo("java.lang.String");
        Assertions.assertThat((String)packageHeaderLoader.getFieldType("org.test.Person", "pets")).isEqualTo("java.util.List");
        Assertions.assertThat((String)packageHeaderLoader.getFieldType("org.test.Person", "birhtday")).isEqualTo("java.util.Calendar");
        Assertions.assertThat((String)packageHeaderLoader.getFieldType("org.test.Person", "this")).isEqualTo("org.test.Person");
        Assertions.assertThat((String)packageHeaderLoader.getFieldType("org.test.Person", "toString")).isNull();
        Assertions.assertThat((String)packageHeaderLoader.getFieldType("org.test.Person", "class")).isNull();
        Assertions.assertThat((String)packageHeaderLoader.getFieldType("org.test.Person", "hashCode")).isNull();
    }

    private PackageHeaderLoader getPackageHeaderLoader(String ... imports) {
        try {
            return new PackageHeaderLoader(this.createImportsList(imports), this.jarInputStreams);
        }
        catch (IOException e) {
            Assertions.fail((String)"Failed to read the jar input streams.");
            return null;
        }
    }

    private Collection<String> createImportsList(String ... list) {
        ArrayList<String> imports = new ArrayList<String>();
        for (String s : list) {
            imports.add(s);
        }
        return imports;
    }
}

