/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.misc;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.verifier.misc.DrlRuleParser;
import org.junit.jupiter.api.Test;

public class DrlRuleDataTest {
    @Test
    void testHandleDrl() {
        Object drl = "rule \"Something\" \n ";
        drl = (String)drl + "dialect \"Java\" \n ";
        drl = (String)drl + "\twhen \n ";
        drl = (String)drl + "\t\tPerson() \n ";
        drl = (String)drl + "\t\tCheesery() \n ";
        drl = (String)drl + "\tthen \n ";
        drl = (String)drl + "\t\tinsert( new Person()) \n ";
        drl = (String)drl + "\t\tinsert( new Car()) \n ";
        drl = (String)drl + "\t\tinsert( new Cheese()) \n ";
        drl = (String)drl + "end ";
        DrlRuleParser s = (DrlRuleParser)DrlRuleParser.findRulesDataFromDrl((String)drl).get(0);
        Assertions.assertThat((int)s.getHeader().size()).isEqualTo(1);
        Assertions.assertThat((int)s.getLhs().size()).isEqualTo(2);
        Assertions.assertThat((int)s.getRhs().size()).isEqualTo(3);
        Assertions.assertThat((String)s.getDescription()).isEqualTo("");
    }

    @Test
    void testHandleDrlNoLineBreaks() {
        Object drl = "rule \"CreditScoreApproval\" \n";
        drl = (String)drl + "\tdialect \"mvel\" \n";
        drl = (String)drl + "\twhen    then";
        drl = (String)drl + "\t\tapplicant.setApproved(true) \n";
        drl = (String)drl + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = (String)drl + "\t\tapplicant.setAge( 10 ) \n";
        drl = (String)drl + "end";
        DrlRuleParser s = (DrlRuleParser)DrlRuleParser.findRulesDataFromDrl((String)drl).get(0);
        Assertions.assertThat((Object)s).isNotNull();
        Assertions.assertThat((int)s.getHeader().size()).isEqualTo(1);
        Assertions.assertThat((int)s.getLhs().size()).isEqualTo(0);
        Assertions.assertThat((int)s.getRhs().size()).isEqualTo(3);
        Assertions.assertThat((String)s.getDescription()).isEqualTo("");
    }

    @Test
    void testHandleDrlWithComment() {
        Object drl = "# Really important information about this rule \n";
        drl = (String)drl + "# Another line because one was not enough \n";
        drl = (String)drl + "#  \n";
        drl = (String)drl + "# @author: trikkola \n";
        drl = (String)drl + "rule \"First\" \n";
        drl = (String)drl + "\tdialect \"mvel\" \n";
        drl = (String)drl + "\twhen \n ";
        drl = (String)drl + "\t\tPerson() \n ";
        drl = (String)drl + "\t\tCheesery() \n ";
        drl = (String)drl + "\tthen \n ";
        drl = (String)drl + "\t\tapplicant.setApproved(true) \n";
        drl = (String)drl + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = (String)drl + "\t\tapplicant.setAge( 10 ) \n";
        drl = (String)drl + "end \n";
        drl = (String)drl + "\n";
        drl = (String)drl + "# Really important information about this rule \n";
        drl = (String)drl + "# Another line because one was not enough \n";
        drl = (String)drl + "#  \n";
        drl = (String)drl + "# @author: trikkola \n";
        drl = (String)drl + "# @created: 29.12.2001 \n";
        drl = (String)drl + "# @edited: 5.5.2005 \n";
        drl = (String)drl + "rule \"Second\" \n";
        drl = (String)drl + "\tdialect \"mvel\" \n";
        drl = (String)drl + "\twhen \n ";
        drl = (String)drl + "\t\tPerson() \n ";
        drl = (String)drl + "\t\tCheesery() \n ";
        drl = (String)drl + "\tthen \n ";
        drl = (String)drl + "\t\tapplicant.setApproved(true) \n";
        drl = (String)drl + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = (String)drl + "\t\tapplicant.setAge( 10 ) \n";
        drl = (String)drl + "end";
        drl = (String)drl + "\n";
        drl = (String)drl + "rule \"Third\" \n";
        drl = (String)drl + "\tdialect \"mvel\" \n";
        drl = (String)drl + "\twhen \n ";
        drl = (String)drl + "\t\tPerson() \n ";
        drl = (String)drl + "\t\tCheesery() \n ";
        drl = (String)drl + "\tthen \n ";
        drl = (String)drl + "\t\tapplicant.setApproved(true) \n";
        drl = (String)drl + "\t\tapplicant.setName( \"Toni\" ) \n";
        drl = (String)drl + "\t\tapplicant.setAge( 10 ) \n";
        drl = (String)drl + "end";
        List list = DrlRuleParser.findRulesDataFromDrl((String)drl);
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        DrlRuleParser rd = (DrlRuleParser)list.get(0);
        Assertions.assertThat((Object)rd).isNotNull();
        Assertions.assertThat((int)rd.getHeader().size()).isEqualTo(1);
        Assertions.assertThat((int)rd.getLhs().size()).isEqualTo(2);
        Assertions.assertThat((int)rd.getRhs().size()).isEqualTo(3);
        Assertions.assertThat((int)rd.getMetadata().size()).isEqualTo(1);
        Assertions.assertThat((String)rd.getDescription()).isNotNull();
        Assertions.assertThat((String)rd.getDescription()).isNotEqualTo((Object)"");
        DrlRuleParser rd2 = (DrlRuleParser)list.get(1);
        Assertions.assertThat((Object)rd2).isNotNull();
        Assertions.assertThat((int)rd2.getHeader().size()).isEqualTo(1);
        Assertions.assertThat((int)rd2.getLhs().size()).isEqualTo(2);
        Assertions.assertThat((int)rd2.getRhs().size()).isEqualTo(3);
        Assertions.assertThat((int)rd2.getMetadata().size()).isEqualTo(3);
        Assertions.assertThat((String)rd2.getDescription()).isNotNull();
        Object description = "Really important information about this rule\n";
        description = (String)description + "Another line because one was not enough\n\n";
        Assertions.assertThat((String)rd2.getDescription()).isEqualTo((String)description);
        Assertions.assertThat((String)rd2.getDescription()).isNotEqualTo((Object)"");
        DrlRuleParser rd3 = (DrlRuleParser)list.get(2);
        Assertions.assertThat((Object)rd3).isNotNull();
        Assertions.assertThat((int)rd3.getHeader().size()).isEqualTo(1);
        Assertions.assertThat((int)rd3.getLhs().size()).isEqualTo(2);
        Assertions.assertThat((int)rd3.getRhs().size()).isEqualTo(3);
        Assertions.assertThat((String)rd3.getDescription()).isNotNull();
        Assertions.assertThat((String)rd3.getDescription()).isEqualTo("");
    }
}

