/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.io.ByteArrayInputStream;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.junit.jupiter.api.Test;

public class PatternSolverDRLTest
extends TestBaseOld {
    @Test
    void testOrInsidePattern() throws Exception {
        StringBuffer rule = new StringBuffer();
        rule.append("rule \"Test rule\" ");
        rule.append("   when ");
        rule.append("       customer : Customer( status > 30 && < 50 ) ");
        rule.append("       order : OrderHeader( customer == customer , orderPriority == 3 || == 4 ) ");
        rule.append("   then ");
        rule.append("       order.setOrderDiscount( 6.0 ); ");
        rule.append("end");
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(new ByteArrayInputStream(rule.toString().getBytes()), result.getVerifierData());
        int patternCount = 0;
        for (Object object : testData) {
            SubPattern pp;
            if (!(object instanceof SubPattern) || (pp = (SubPattern)object).getItems().size() != 2) continue;
            ++patternCount;
        }
        Assertions.assertThat((int)patternCount).isEqualTo(3);
    }
}

