/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.drl.parser.DroolsParserException;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.Variable;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.visitor.PackageDescrVisitor;
import org.junit.jupiter.api.BeforeEach;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class TestBase {
    protected VerifierData verifierData;
    protected PackageDescrVisitor packageDescrVisitor;

    @BeforeEach
    public void setUp() throws Exception {
        this.verifierData = VerifierReportFactory.newVerifierData();
        this.packageDescrVisitor = new PackageDescrVisitor(this.verifierData, Collections.emptyList());
    }

    protected PackageDescr getPackageDescr(InputStream resourceAsStream) throws DroolsParserException {
        InputStreamReader drlReader = new InputStreamReader(resourceAsStream);
        return new DrlParser(LanguageLevelOption.DRL5).parse((Reader)drlReader);
    }

    protected void assertContainsVariable(String ruleName, String variableName) {
        Variable variable = this.verifierData.getVariableByRuleAndVariableName(ruleName, variableName);
        ((ObjectAssert)Assertions.assertThat((Object)variable).as(String.format("Could not find Variable : %s ", variableName), new Object[0])).isNotNull();
    }

    protected void assertContainsField(String name) {
        Collection allFields = this.verifierData.getAll(VerifierComponentType.FIELD);
        for (Field field : allFields) {
            if (!name.equals(field.getName())) continue;
            return;
        }
        Assertions.fail((String)"Could not find Field");
    }

    protected void assertContainsFields(int amount) {
        Collection allFields = this.verifierData.getAll(VerifierComponentType.FIELD);
        Assertions.assertThat((int)allFields.size()).isEqualTo(amount);
    }
}

