/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.incoherence;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;

public class IncoherentPatternsTest
extends TestBaseOld {
    @Test
    void testIncoherentPatternsInSubRule() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Patterns.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility"));
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            hashSet.add(rule.getName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 1")).isTrue();
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 2")).isTrue();
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 7")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testIncoherentPatternsInSubRuleVariables() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Patterns.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, variables"));
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            hashSet.add(rule.getName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 3")).isTrue();
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 4")).isTrue();
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 5")).isTrue();
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 6")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testIncoherentPatternsInSubRuleRangesLess() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Patterns.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with lesser value"));
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            hashSet.add(rule.getName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 8")).isTrue();
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 12")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testIncoherentPatternsInSubRuleRangesGreater() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Patterns.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with greater value"));
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            hashSet.add(rule.getName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 9")).isTrue();
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 14")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testIncoherentPatternsInSubRuleRangesEqualOrUnequal() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Patterns.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with equal or unequal value"));
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            hashSet.add(rule.getName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 10")).isTrue();
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 15")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testIncoherentPatternsInSubRuleRangesEqualOrUnequalVariables() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Patterns.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with equal or unequal variables"));
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            hashSet.add(rule.getName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 11")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testIncoherentPatternsInSubRuleRangesEqualValue() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Patterns.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with equal value"));
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            hashSet.add(rule.getName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 16")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    void testIncoherentPatternsInSubRuleRangesEqualVariable() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("Patterns.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("PatternsTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Incoherent Patterns in rule possibility, ranges when not conflicts with equal variable"));
        Iterator iter = result.getBySeverity(Severity.WARNING).iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            VerifierRule rule = (VerifierRule)((VerifierMessage)o).getFaulty();
            hashSet.add(rule.getName());
        }
        Assertions.assertThat((boolean)hashSet.remove("Incoherent patterns 13")).isTrue();
        if (!hashSet.isEmpty()) {
            for (String string : hashSet) {
                Assertions.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

