/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.solver;

import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.OperatorDescrType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.solver.PatternSolver;
import org.junit.jupiter.api.Test;

public class PatternSolverTest {
    @Test
    void testAddBasicAnd() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        List list = solver.getPossibilityLists();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((int)((Set)list.get(0)).size()).isEqualTo(2);
    }

    @Test
    void testAddBasicOr() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        List list = solver.getPossibilityLists();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((int)((Set)list.get(0)).size()).isEqualTo(1);
        Assertions.assertThat((int)((Set)list.get(1)).size()).isEqualTo(1);
    }

    @Test
    void testAddOrAnd() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction);
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction2);
        solver.add((VerifierComponent)literalRestriction3);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((int)((Set)list.get(0)).size()).isEqualTo(1);
        Assertions.assertThat((boolean)((Set)list.get(0)).contains(literalRestriction)).isTrue();
        Assertions.assertThat((int)((Set)list.get(1)).size()).isEqualTo(2);
        Assertions.assertThat((boolean)((Set)list.get(1)).contains(literalRestriction2)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(1)).contains(literalRestriction3)).isTrue();
    }

    @Test
    void testAddAndOr() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction2);
        solver.add((VerifierComponent)literalRestriction3);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((int)((Set)list.get(0)).size()).isEqualTo(2);
        Assertions.assertThat((boolean)((Set)list.get(0)).contains(literalRestriction)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(0)).contains(literalRestriction2)).isTrue();
        Assertions.assertThat((int)((Set)list.get(1)).size()).isEqualTo(2);
        Assertions.assertThat((boolean)((Set)list.get(1)).contains(literalRestriction)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(1)).contains(literalRestriction3)).isTrue();
    }

    @Test
    void testAddAndOrOr() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction4 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.AND);
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction3);
        solver.add((VerifierComponent)literalRestriction4);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        Assertions.assertThat((int)((Set)list.get(0)).size()).isEqualTo(2);
        Assertions.assertThat((boolean)((Set)list.get(0)).contains(literalRestriction)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(0)).contains(literalRestriction3)).isTrue();
        Assertions.assertThat((int)((Set)list.get(1)).size()).isEqualTo(2);
        Assertions.assertThat((boolean)((Set)list.get(1)).contains(literalRestriction)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(1)).contains(literalRestriction4)).isTrue();
        Assertions.assertThat((int)((Set)list.get(2)).size()).isEqualTo(2);
        Assertions.assertThat((boolean)((Set)list.get(2)).contains(literalRestriction2)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(2)).contains(literalRestriction3)).isTrue();
        Assertions.assertThat((int)((Set)list.get(3)).size()).isEqualTo(2);
        Assertions.assertThat((boolean)((Set)list.get(3)).contains(literalRestriction2)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(3)).contains(literalRestriction4)).isTrue();
    }

    @Test
    void testAddOrAndAnd() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction4 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.OR);
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction3);
        solver.add((VerifierComponent)literalRestriction4);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((int)((Set)list.get(0)).size()).isEqualTo(2);
        Assertions.assertThat((boolean)((Set)list.get(0)).contains(literalRestriction)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(0)).contains(literalRestriction2)).isTrue();
        Assertions.assertThat((int)((Set)list.get(1)).size()).isEqualTo(2);
        Assertions.assertThat((boolean)((Set)list.get(1)).contains(literalRestriction3)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(1)).contains(literalRestriction4)).isTrue();
    }

    @Test
    void testAddOrAndOr() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction4 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.OR);
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction3);
        solver.add((VerifierComponent)literalRestriction4);
        solver.end();
        solver.end();
        List list = solver.getPossibilityLists();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((int)((Set)list.get(0)).size()).isEqualTo(2);
        Assertions.assertThat((boolean)((Set)list.get(0)).contains(literalRestriction)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(0)).contains(literalRestriction2)).isTrue();
        Assertions.assertThat((int)((Set)list.get(1)).size()).isEqualTo(1);
        Assertions.assertThat((boolean)((Set)list.get(1)).contains(literalRestriction3)).isTrue();
        Assertions.assertThat((int)((Set)list.get(2)).size()).isEqualTo(1);
        Assertions.assertThat((boolean)((Set)list.get(2)).contains(literalRestriction4)).isTrue();
    }

    @Test
    void testAddOrAndOrDescr() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        LiteralRestriction literalRestriction = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction2 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction3 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction4 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        LiteralRestriction literalRestriction5 = LiteralRestriction.createRestriction((Pattern)pattern, (String)"");
        PatternSolver solver = new PatternSolver(pattern);
        solver.addOperator(OperatorDescrType.AND);
        solver.addOperator(OperatorDescrType.AND);
        solver.add((VerifierComponent)literalRestriction);
        solver.add((VerifierComponent)literalRestriction2);
        solver.end();
        solver.addOperator(OperatorDescrType.OR);
        solver.add((VerifierComponent)literalRestriction3);
        solver.add((VerifierComponent)literalRestriction4);
        solver.end();
        solver.add((VerifierComponent)literalRestriction5);
        solver.end();
        List list = solver.getPossibilityLists();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((int)((Set)list.get(0)).size()).isEqualTo(4);
        Assertions.assertThat((boolean)((Set)list.get(0)).contains(literalRestriction)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(0)).contains(literalRestriction2)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(0)).contains(literalRestriction3)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(0)).contains(literalRestriction5)).isTrue();
        Assertions.assertThat((int)((Set)list.get(1)).size()).isEqualTo(4);
        Assertions.assertThat((boolean)((Set)list.get(1)).contains(literalRestriction)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(1)).contains(literalRestriction2)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(1)).contains(literalRestriction4)).isTrue();
        Assertions.assertThat((boolean)((Set)list.get(1)).contains(literalRestriction4)).isTrue();
    }
}

