/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.visitor.PackageDescrVisitor;
import org.junit.jupiter.api.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class NestedPatternsTest {
    @Test
    void runVisitor() throws Exception {
        VerifierData data = VerifierReportFactory.newVerifierData();
        PackageDescrVisitor visitor = new PackageDescrVisitor(data, Collections.EMPTY_LIST);
        Assertions.assertThat((Object)data).isNotNull();
        InputStreamReader drlReader = new InputStreamReader(this.getClass().getResourceAsStream("NestedPatterns.drl"));
        PackageDescr packageDescr = new DrlParser(LanguageLevelOption.DRL5).parse((Reader)drlReader);
        Assertions.assertThat((Object)packageDescr).isNotNull();
        visitor.visitPackageDescr(packageDescr);
        Collection all = data.getAll();
        int patternCount = 0;
        for (VerifierComponent verifierComponent : all) {
            if (!verifierComponent.getVerifierComponentType().equals(VerifierComponentType.PATTERN)) continue;
            ++patternCount;
        }
        Assertions.assertThat((int)patternCount).isEqualTo(4);
        Collection patterns = data.getAll(VerifierComponentType.PATTERN);
        Assertions.assertThat((Collection)patterns).isNotNull();
        Assertions.assertThat((int)patterns.size()).isEqualTo(4);
        Collection restrictions = data.getAll(VerifierComponentType.RESTRICTION);
        Assertions.assertThat((Collection)restrictions).isNotNull();
        Assertions.assertThat((int)restrictions.size()).isEqualTo(3);
    }
}

