/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.verifier.Verifier;
import org.drools.verifier.components.TextConsequence;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.visitor.PackageDescrVisitor;
import org.junit.jupiter.api.Test;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class VerifierComponentTest {
    @Test
    void testVisit() throws Exception {
        InputStreamReader drlReader = new InputStreamReader(Verifier.class.getResourceAsStream("Misc3.drl"));
        PackageDescr descr = new DrlParser(LanguageLevelOption.DRL5).parse((Reader)drlReader);
        VerifierData verifierData = VerifierReportFactory.newVerifierData();
        PackageDescrVisitor visitor = new PackageDescrVisitor(verifierData, Collections.EMPTY_LIST);
        visitor.visitPackageDescr(descr);
        Collection datas = verifierData.getAll();
        VerifierComponent[] components = datas.toArray(new VerifierComponent[datas.size()]);
        this.assertVerifierComponent(components[0], 51);
        this.assertVerifierComponent(components[1], 42);
        this.assertVerifierComponent(components[2], 48);
        this.assertVerifierComponent(components[3], 39);
        this.assertVerifierComponent(components[4], 40);
        this.assertVerifierComponent(components[5], 41);
        this.assertVerifierComponent(components[6], 19);
        this.assertVerifierComponent(components[7], 48);
        this.assertVerifierComponent(components[8], 19);
        this.assertVerifierComponent(components[9], 39);
        this.assertVerifierComponent(components[10], 40);
        this.assertVerifierComponent(components[11], 41);
        this.assertVerifierComponent(components[12], 48);
        this.assertVerifierComponent(components[13], 48);
        this.assertVerifierComponent(components[14], 49);
        this.assertVerifierComponent(components[15], 50);
        this.assertVerifierComponent(components[16], 39);
        this.assertVerifierComponent(components[17], 39);
        this.assertVerifierComponent(components[18], 40);
        this.assertVerifierComponent(components[19], 41);
        this.assertVerifierComponent(components[20], 48);
        this.assertVerifierComponent(components[21], 49);
        this.assertVerifierComponent(components[22], 50);
        this.assertVerifierComponent(components[23], 39);
        this.assertVerifierComponent(components[24], 40);
        this.assertVerifierComponent(components[25], 41);
        this.assertVerifierComponent(components[26], 48);
        this.assertVerifierComponent(components[27], 49);
        this.assertVerifierComponent(components[28], 50);
        this.assertVerifierComponent(components[29], 39);
        this.assertVerifierComponent(components[30], 40);
        this.assertVerifierComponent(components[31], 41);
        this.assertVerifierComponent(components[32], 41);
        this.assertVerifierComponent(components[33], 46);
        this.assertVerifierComponent(components[34], 37);
        this.assertVerifierComponent(components[35], 17);
        this.assertVerifierComponent(components[36], 48);
        this.assertVerifierComponent(components[37], 49);
        this.assertVerifierComponent(components[38], 50);
        this.assertVerifierComponent(components[39], 39);
        this.assertVerifierComponent(components[40], 40);
        this.assertVerifierComponent(components[41], 41);
        this.assertVerifierComponent(components[42], 46);
        this.assertVerifierComponent(components[43], 37);
        this.assertVerifierComponent(components[44], -1);
    }

    void assertVerifierComponent(VerifierComponent component, int line) {
        Assertions.assertThat((Comparable)component).isNotNull();
        Assertions.assertThat((Object)component.getDescr()).isNotNull();
        if (component instanceof TextConsequence) {
            Assertions.assertThat((int)((RuleDescr)((TextConsequence)component).getDescr()).getConsequenceLine()).isEqualTo(line);
        } else {
            Assertions.assertThat((int)component.getDescr().getLine()).isEqualTo(line);
        }
    }
}

