/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.driver.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.models.datamodel.oracle.TypeSource;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationContext;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationEngine;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationListener;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.ObjectSource;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ModelFactoryImpl;
import org.kie.workbench.common.services.datamodeller.driver.AnnotationDriver;
import org.kie.workbench.common.services.datamodeller.driver.FileChangeDescriptor;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriver;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;
import org.kie.workbench.common.services.datamodeller.driver.impl.DefaultOracleAnnotationDriver;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.DescriptionAnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.KeyAnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.LabelAnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.PositionAnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.RoleAnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataModelOracleDriver
implements ModelDriver {
    private static final Logger logger = LoggerFactory.getLogger(DataModelOracleDriver.class);
    private List<AnnotationDefinition> configuredAnnotations = new ArrayList<AnnotationDefinition>();
    private Map<String, AnnotationDriver> annotationDrivers = new HashMap<String, AnnotationDriver>();

    public static DataModelOracleDriver getInstance() {
        return new DataModelOracleDriver();
    }

    protected DataModelOracleDriver() {
        AbstractAnnotationDefinition annotationDefinition = DescriptionAnnotationDefinition.getInstance();
        this.configuredAnnotations.add(annotationDefinition);
        this.annotationDrivers.put(annotationDefinition.getClassName(), new DefaultOracleAnnotationDriver());
        annotationDefinition = KeyAnnotationDefinition.getInstance();
        this.configuredAnnotations.add(annotationDefinition);
        this.annotationDrivers.put(annotationDefinition.getClassName(), new DefaultOracleAnnotationDriver());
        annotationDefinition = LabelAnnotationDefinition.getInstance();
        this.configuredAnnotations.add(annotationDefinition);
        this.annotationDrivers.put(annotationDefinition.getClassName(), new DefaultOracleAnnotationDriver());
        annotationDefinition = RoleAnnotationDefinition.getInstance();
        this.configuredAnnotations.add(annotationDefinition);
        this.annotationDrivers.put(annotationDefinition.getClassName(), new DefaultOracleAnnotationDriver());
        annotationDefinition = PositionAnnotationDefinition.getInstance();
        this.configuredAnnotations.add(annotationDefinition);
        this.annotationDrivers.put(annotationDefinition.getClassName(), new DefaultOracleAnnotationDriver());
    }

    @Override
    public List<AnnotationDefinition> getConfiguredAnnotations() {
        return this.configuredAnnotations;
    }

    @Override
    public AnnotationDefinition getConfiguredAnnotation(String annotationClassName) {
        for (AnnotationDefinition annotationDefinition : this.configuredAnnotations) {
            if (!annotationClassName.equals(annotationDefinition.getClassName())) continue;
            return annotationDefinition;
        }
        return null;
    }

    @Override
    public AnnotationDriver getAnnotationDriver(String annotationClassName) {
        return this.annotationDrivers.get(annotationClassName);
    }

    @Override
    public List<FileChangeDescriptor> generateModel(DataModel dataModel, IOService ioService, Path root, OpenOption option) throws Exception {
        GenerationContext generationContext = new GenerationContext(dataModel);
        OracleGenerationListener generationListener = new OracleGenerationListener(ioService, root, option);
        generationContext.setGenerationListener(generationListener);
        GenerationEngine generationEngine = GenerationEngine.getInstance();
        generationEngine.generate(generationContext);
        return generationListener.getFileChanges();
    }

    @Override
    public DataModel createModel() {
        return ModelFactoryImpl.getInstance().newModel();
    }

    public DataModel loadModel(ProjectDataModelOracle oracleDataModel) throws ModelDriverException {
        DataModel dataModel = this.createModel();
        logger.debug("Adding oracleDataModel: " + oracleDataModel + " to dataModel: " + dataModel);
        String[] factTypes = oracleDataModel.getFactTypes();
        ObjectSource source = null;
        if (factTypes != null && factTypes.length > 0) {
            for (int i = 0; i < factTypes.length; ++i) {
                source = this.factSource(oracleDataModel, factTypes[i]);
                if (source == null || !ObjectSource.INTERNAL.equals((Object)source) && !ObjectSource.DEPENDENCY.equals((Object)source)) continue;
                this.addFactType(dataModel, oracleDataModel, factTypes[i], source);
            }
        } else {
            logger.debug("oracleDataModel hasn't defined fact types");
        }
        return dataModel;
    }

    private void addFactType(DataModel dataModel, ProjectDataModelOracle oracleDataModel, String factType, ObjectSource source) throws ModelDriverException {
        Map fields;
        String packageName = NamingUtils.getInstance().extractPackageName(factType);
        String className = NamingUtils.getInstance().extractClassName(factType);
        String superClass = oracleDataModel.getSuperType(factType);
        logger.debug("Adding factType: " + factType + ", to dataModel: " + dataModel + ", from oracleDataModel: " + oracleDataModel);
        DataObject dataObject = dataModel.addDataObject(factType, source);
        dataObject.setSuperClassName(superClass);
        Set typeAnnotations = oracleDataModel.getTypeAnnotations(factType);
        if (typeAnnotations != null) {
            for (org.drools.workbench.models.datamodel.oracle.Annotation annotation : typeAnnotations) {
                this.addFactTypeAnnotation(dataObject, annotation);
            }
        }
        if ((fields = oracleDataModel.getModelFields()) != null) {
            ModelField[] factFields = (ModelField[])fields.get(factType);
            Map typeFieldsAnnotations = oracleDataModel.getTypeFieldsAnnotations(factType);
            Integer naturalOrder = 0;
            ArrayList<PropertyPosition> naturalOrderPositions = new ArrayList<PropertyPosition>();
            if (factFields != null && factFields.length > 0) {
                for (int j = 0; j < factFields.length; ++j) {
                    Set fieldAnnotations;
                    ObjectProperty property;
                    ModelField field = factFields[j];
                    if (!this.isLoadableField(field)) continue;
                    if (field.getType().equals("Collection")) {
                        String bag = oracleDataModel.getFieldClassName(factType, field.getName());
                        String itemsClass = oracleDataModel.getParametricFieldType(factType, field.getName());
                        property = dataObject.addProperty(field.getName(), itemsClass, true, bag);
                    } else {
                        property = dataObject.addProperty(field.getName(), this.getFieldType(oracleDataModel, packageName, field.getClassName()));
                    }
                    if (typeFieldsAnnotations != null && (fieldAnnotations = (Set)typeFieldsAnnotations.get(field.getName())) != null) {
                        for (org.drools.workbench.models.datamodel.oracle.Annotation fieldAnnotation : fieldAnnotations) {
                            this.addFieldAnnotation(dataObject, property, fieldAnnotation);
                        }
                    }
                    AnnotationImpl position = new AnnotationImpl(PositionAnnotationDefinition.getInstance());
                    position.setValue("value", naturalOrder.toString());
                    naturalOrderPositions.add(new PropertyPosition(property, position));
                    Integer n = naturalOrder;
                    Integer n2 = naturalOrder = Integer.valueOf(naturalOrder + 1);
                }
                this.verifyPositions(dataObject, naturalOrderPositions);
            }
        } else {
            logger.debug("No fields for factTye: " + factType);
        }
    }

    private void verifyPositions(DataObject dataObject, List<PropertyPosition> naturalOrderPositions) {
        HashMap<String, String> availablePositions = new HashMap<String, String>();
        for (int i = 0; i < dataObject.getProperties().size(); ++i) {
            availablePositions.put(String.valueOf(i), "");
        }
        boolean recalculate = false;
        for (ObjectProperty property : dataObject.getProperties().values()) {
            Annotation position = property.getAnnotation(PositionAnnotationDefinition.getInstance().getClassName());
            if (position == null) {
                recalculate = true;
                break;
            }
            String value = (String)position.getValue("value");
            if (value == null) continue;
            availablePositions.remove(value.trim());
        }
        ArrayList<PropertyPosition> desiredPositions = new ArrayList<PropertyPosition>();
        if (recalculate || availablePositions.size() > 0) {
            for (PropertyPosition propertyPosition : naturalOrderPositions) {
                Annotation desiredPosition = propertyPosition.property.removeAnnotation(PositionAnnotationDefinition.getInstance().getClassName());
                if (desiredPosition != null) {
                    desiredPositions.add(new PropertyPosition(propertyPosition.property, desiredPosition));
                }
                propertyPosition.property.addAnnotation(propertyPosition.position);
            }
            this.recalculatePositions(dataObject, desiredPositions);
        }
    }

    private void recalculatePositions(DataObject dataObject, List<PropertyPosition> desiredPositions) {
        Collection<ObjectProperty> properties = dataObject.getProperties().values();
        for (PropertyPosition desiredPosition : desiredPositions) {
            ObjectProperty property = dataObject.getProperties().get(desiredPosition.property.getName());
            Annotation currentPosition = property.getAnnotation(PositionAnnotationDefinition.getInstance().getClassName());
            this.recalculatePositions(properties, currentPosition, desiredPosition.position);
        }
    }

    private void recalculatePositions(Collection<ObjectProperty> properties, Annotation oldPositionAnnotaion, Annotation newPositionAnnotation) {
        Integer newPosition;
        Integer oldPosition;
        Integer maxPosition = properties.size() - 1;
        try {
            oldPosition = Integer.parseInt((String)oldPositionAnnotaion.getValue("value"));
        }
        catch (NumberFormatException e) {
            return;
        }
        try {
            newPosition = Integer.parseInt((String)newPositionAnnotation.getValue("value"));
        }
        catch (NumberFormatException e) {
            return;
        }
        if (newPosition < 0) {
            newPosition = 0;
        }
        if (newPosition > maxPosition) {
            newPosition = maxPosition;
        }
        if (newPosition == oldPosition) {
            return;
        }
        for (ObjectProperty property : properties) {
            Annotation propertyPositionAnnotation = property.getAnnotation(PositionAnnotationDefinition.getInstance().getClassName());
            int propertyPosition = Integer.parseInt((String)propertyPositionAnnotation.getValue("value"));
            if (newPosition < oldPosition) {
                if (propertyPosition >= newPosition && propertyPosition < oldPosition) {
                    propertyPositionAnnotation.setValue("value", Integer.valueOf(propertyPosition + 1).toString());
                }
            } else if (propertyPosition <= newPosition && propertyPosition > oldPosition) {
                propertyPositionAnnotation.setValue("value", Integer.valueOf(propertyPosition - 1).toString());
            }
            if (propertyPosition != oldPosition) continue;
            propertyPositionAnnotation.setValue("value", newPosition.toString());
        }
    }

    private void addFactTypeAnnotation(DataObject dataObject, org.drools.workbench.models.datamodel.oracle.Annotation annotationToken) throws ModelDriverException {
        Annotation annotation = this.createAnnotation(annotationToken);
        if (annotation != null) {
            dataObject.addAnnotation(annotation);
        }
    }

    private void addFieldAnnotation(DataObject dataObject, ObjectProperty property, org.drools.workbench.models.datamodel.oracle.Annotation annotationToken) throws ModelDriverException {
        Annotation annotation = this.createAnnotation(annotationToken);
        if (annotation != null) {
            property.addAnnotation(annotation);
        }
    }

    private Annotation createAnnotation(org.drools.workbench.models.datamodel.oracle.Annotation annotationToken) throws ModelDriverException {
        AnnotationDefinition annotationDefinition = this.getConfiguredAnnotation(annotationToken.getQualifiedTypeName());
        Annotation annotation = null;
        if (annotationDefinition != null) {
            AnnotationDriver annotationDriver = this.getAnnotationDriver(annotationDefinition.getClassName());
            if (annotationDriver != null) {
                annotation = annotationDriver.buildAnnotation(annotationDefinition, annotationToken);
            } else {
                logger.warn("AnnotationDriver for annotation: " + annotationToken.getQualifiedTypeName() + " is not configured for this driver");
            }
        } else {
            logger.warn("Annotation: " + annotationToken.getQualifiedTypeName() + " is not configured for this driver.");
        }
        return annotation;
    }

    private String getFieldType(ProjectDataModelOracle oracleDataModel, String packageName, String fieldType) {
        String primitiveClass = NamingUtils.getInstance().getClassForPrimitiveTypeId(fieldType);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        return fieldType;
    }

    private ObjectSource factSource(ProjectDataModelOracle oracleDataModel, String factType) {
        TypeSource oracleType = oracleDataModel.getTypeSource(factType);
        if (TypeSource.JAVA_PROJECT.equals((Object)oracleType)) {
            return ObjectSource.INTERNAL;
        }
        if (TypeSource.JAVA_DEPENDENCY.equals((Object)oracleType)) {
            return ObjectSource.DEPENDENCY;
        }
        return null;
    }

    private boolean isLoadableField(ModelField field) {
        return field.getOrigin().equals((Object)ModelField.FIELD_ORIGIN.DECLARED);
    }

    static class OracleGenerationListener
    implements GenerationListener {
        Path output;
        IOService ioService;
        OpenOption option;
        List<FileChangeDescriptor> fileChanges = new ArrayList<FileChangeDescriptor>();

        public OracleGenerationListener(IOService ioService, Path output, OpenOption option) {
            this.ioService = ioService;
            this.output = output;
            this.option = option;
        }

        @Override
        public void assetGenerated(String fileName, String content) {
            Path subDirPath = this.output;
            int index = fileName.lastIndexOf("/");
            if (index == 0) {
                fileName = fileName.substring(1, fileName.length());
            } else if (index > 0) {
                String dirNamesPath = fileName.substring(0, index);
                fileName = fileName.substring(index + 1, fileName.length());
                StringTokenizer dirNames = new StringTokenizer(dirNamesPath, "/");
                while (dirNames.hasMoreElements()) {
                    String subDir = dirNames.nextToken();
                    if (this.ioService.exists(subDirPath = subDirPath.resolve(subDir))) continue;
                    this.ioService.createDirectory(subDirPath, new FileAttribute[0]);
                }
            }
            Path destFilePath = subDirPath.resolve(fileName);
            boolean exists = this.ioService.exists(destFilePath);
            this.ioService.write(destFilePath, content, new OpenOption[]{this.option});
            if (!exists) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Genertion listener created a new file: " + destFilePath);
                }
                this.fileChanges.add(new FileChangeDescriptor(destFilePath, 0));
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Generation listener modified file: " + destFilePath);
                }
                this.fileChanges.add(new FileChangeDescriptor(destFilePath, 2));
            }
        }

        public List<FileChangeDescriptor> getFileChanges() {
            return this.fileChanges;
        }
    }

    static class PropertyPosition {
        ObjectProperty property;
        Annotation position;

        PropertyPosition(ObjectProperty property, Annotation position) {
            this.property = property;
            this.position = position;
        }
    }
}

