/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.migrater;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.guvnor.server.RepositoryCategoryService;
import org.drools.workbench.jcr2vfsmigration.migrater.util.MigrationPathManager;
import org.guvnor.common.services.shared.metadata.CategoriesService;
import org.guvnor.common.services.shared.metadata.model.Categories;
import org.guvnor.common.services.shared.metadata.model.CategoryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CategoryMigrater {
    protected static final Logger logger = LoggerFactory.getLogger(CategoryMigrater.class);
    @Inject
    protected RepositoryCategoryService jcrRepositoryCategoryService;
    @Inject
    CategoriesService categoriesService;
    @Inject
    protected MigrationPathManager migrationPathManager;

    public void migrateAll() {
        System.out.println("  Category migration started");
        Categories vfsCategories = new Categories();
        this.loadChildCategories("/", (CategoryItem)vfsCategories);
        this.categoriesService.save(this.migrationPathManager.generatePathForModule("categories.xml"), vfsCategories);
        System.out.println("  Category migration ended");
    }

    private void loadChildCategories(String category, CategoryItem vfsCategoryItem) {
        String[] categories;
        for (String c : categories = this.jcrRepositoryCategoryService.loadChildCategories(category)) {
            String categoryPath = this.getItemPath(c, vfsCategoryItem.getFullPath());
            CategoryItem categoryItem = vfsCategoryItem.addChildren(c, "");
            String[] childrenCategories = this.jcrRepositoryCategoryService.loadChildCategories(categoryItem.getFullPath());
            if (childrenCategories.length == 0) continue;
            this.loadChildCategories(c, categoryItem);
        }
    }

    private String getItemPath(String categoryName, String parentItemPath) {
        String path = this.isParentRoot(parentItemPath) ? parentItemPath + categoryName : parentItemPath + "/" + categoryName;
        return path;
    }

    private boolean isParentRoot(String parentItemPath) {
        return parentItemPath.equals("/");
    }
}

