/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.migrater.asset;

import java.util.Scanner;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.repository.AssetItem;
import org.drools.workbench.jcr2vfsmigration.migrater.PackageImportHelper;
import org.drools.workbench.jcr2vfsmigration.migrater.asset.BaseAssetMigrater;
import org.drools.workbench.jcr2vfsmigration.migrater.util.MigrationPathManager;
import org.drools.workbench.screens.drltext.service.DRLTextEditorService;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;

@ApplicationScoped
public class PlainTextAssetWithPackagePropertyMigrater
extends BaseAssetMigrater {
    protected static final Logger logger = LoggerFactory.getLogger(PlainTextAssetWithPackagePropertyMigrater.class);
    @Inject
    protected RepositoryAssetService jcrRepositoryAssetService;
    @Inject
    private Paths paths;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    protected MigrationPathManager migrationPathManager;
    @Inject
    DRLTextEditorService drlTextEditorServiceImpl;
    @Inject
    PackageImportHelper packageImportHelper;

    public void migrate(Module jcrModule, AssetItem jcrAssetItem) {
        org.uberfire.backend.vfs.Path path = this.migrationPathManager.generatePathForAsset(jcrModule, jcrAssetItem);
        Path nioPath = this.paths.convert(path);
        if (!Files.exists((Path)nioPath, (LinkOption[])new LinkOption[0])) {
            this.ioService.createFile(nioPath, new FileAttribute[0]);
        }
        StringBuilder sb = new StringBuilder();
        if ("drl".equals(jcrAssetItem.getFormat())) {
            sb.append("rule '" + jcrAssetItem.getName() + "'");
            sb.append("\n");
            sb.append("\n");
        }
        sb.append(jcrAssetItem.getContent());
        sb.append("\n");
        sb.append("\n");
        sb.append("end");
        String content = sb.toString();
        if ("dsl".equals(jcrAssetItem.getFormat()) || "dslr".equals(jcrAssetItem.getFormat()) || "template".equals(jcrAssetItem.getFormat()) || "drl".equals(jcrAssetItem.getFormat()) || "function".equals(jcrAssetItem.getFormat())) {
            StringBuffer sb1 = new StringBuffer();
            Scanner scanner = new Scanner(content);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.startsWith("#")) {
                    sb1.append(line.replaceFirst("#", "//"));
                    continue;
                }
                sb1.append(line);
            }
            scanner.close();
            content = sb1.toString();
        }
        String sourceWithImport = this.drlTextEditorServiceImpl.assertPackageName(content, path);
        sourceWithImport = this.packageImportHelper.assertPackageImportDRL(sourceWithImport, path);
        this.ioService.write(nioPath, sourceWithImport, this.migrateMetaData(jcrModule, jcrAssetItem), new OpenOption[]{new CommentedOption(jcrAssetItem.getLastContributor(), null, jcrAssetItem.getCheckinComment(), jcrAssetItem.getLastModified().getTime())});
    }
}

