/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.file.AtomicMoveNotSupportedException;
import org.kie.commons.java.nio.file.CopyOption;
import org.kie.commons.java.nio.file.DeleteOption;
import org.kie.commons.java.nio.file.DirectoryNotEmptyException;
import org.kie.commons.java.nio.file.FileAlreadyExistsException;
import org.kie.commons.java.nio.file.FileSystemAlreadyExistsException;
import org.kie.commons.java.nio.file.NoSuchFileException;
import org.kie.commons.java.nio.file.NotDirectoryException;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.ProviderNotFoundException;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.DirectoryStream;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.backend.vfs.impl.DirectoryStreamImpl;

@Service
@ApplicationScoped
public class VFSServicesServerImpl
implements VFSService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Paths paths;

    public org.uberfire.backend.vfs.Path get(String uri) {
        return this.paths.convert(this.ioService.get(URI.create(uri)));
    }

    public DirectoryStream<org.uberfire.backend.vfs.Path> newDirectoryStream(org.uberfire.backend.vfs.Path dir) throws IllegalArgumentException, NotDirectoryException, IOException {
        Iterator content = this.ioService.newDirectoryStream(this.paths.convert(dir)).iterator();
        return this.newDirectoryStream(content);
    }

    public DirectoryStream<org.uberfire.backend.vfs.Path> newDirectoryStream(org.uberfire.backend.vfs.Path dir, DirectoryStream.Filter<org.uberfire.backend.vfs.Path> filter) throws IllegalArgumentException, NotDirectoryException, IOException {
        Iterator content = this.ioService.newDirectoryStream(this.paths.convert(dir), null).iterator();
        return this.newDirectoryStream(content);
    }

    public org.uberfire.backend.vfs.Path createDirectory(org.uberfire.backend.vfs.Path dir) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return this.paths.convert(this.ioService.createDirectory(this.paths.convert(dir), new FileAttribute[0]));
    }

    public org.uberfire.backend.vfs.Path createDirectories(org.uberfire.backend.vfs.Path dir) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return this.paths.convert(this.ioService.createDirectories(this.paths.convert(dir), new FileAttribute[0]));
    }

    public org.uberfire.backend.vfs.Path createDirectory(org.uberfire.backend.vfs.Path dir, Map<String, ?> attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return this.paths.convert(this.ioService.createDirectory(this.paths.convert(dir), attrs));
    }

    public org.uberfire.backend.vfs.Path createDirectories(org.uberfire.backend.vfs.Path dir, Map<String, ?> attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return this.paths.convert(this.ioService.createDirectories(this.paths.convert(dir), attrs));
    }

    public Map<String, Object> readAttributes(org.uberfire.backend.vfs.Path path) throws UnsupportedOperationException, IllegalArgumentException, IOException {
        return this.ioService.readAttributes(this.paths.convert(path));
    }

    public void setAttributes(org.uberfire.backend.vfs.Path path, Map<String, Object> attrs) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException {
        this.ioService.setAttributes(this.paths.convert(path), attrs);
    }

    public void delete(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, NoSuchFileException, DirectoryNotEmptyException, IOException {
        this.ioService.delete(this.paths.convert(path), new DeleteOption[0]);
    }

    public boolean deleteIfExists(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, DirectoryNotEmptyException, IOException {
        return this.ioService.deleteIfExists(this.paths.convert(path), new DeleteOption[0]);
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path target) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException {
        return this.paths.convert(this.ioService.copy(this.paths.convert(source), this.paths.convert(target), new CopyOption[0]));
    }

    public org.uberfire.backend.vfs.Path move(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path target) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException {
        return this.paths.convert(this.ioService.move(this.paths.convert(source), this.paths.convert(target), new CopyOption[0]));
    }

    public String readAllString(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, NoSuchFileException, IOException {
        return this.ioService.readAllString(this.paths.convert(path));
    }

    public org.uberfire.backend.vfs.Path write(org.uberfire.backend.vfs.Path path, String content) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.paths.convert(this.ioService.write(this.paths.convert(path), content, new OpenOption[0]));
    }

    public org.uberfire.backend.vfs.Path write(org.uberfire.backend.vfs.Path path, String content, Map<String, ?> attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return this.paths.convert(this.ioService.write(this.paths.convert(path), content, attrs, new OpenOption[0]));
    }

    private DirectoryStream<org.uberfire.backend.vfs.Path> newDirectoryStream(Iterator<Path> iterator) {
        LinkedList<org.uberfire.backend.vfs.Path> content = new LinkedList<org.uberfire.backend.vfs.Path>();
        while (iterator.hasNext()) {
            content.add(this.paths.convert(iterator.next()));
        }
        return new DirectoryStreamImpl(content);
    }

    private DirectoryStream.Filter<Path> convert(final DirectoryStream.Filter<org.uberfire.backend.vfs.Path> filter) {
        return new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return filter.accept((Object)VFSServicesServerImpl.this.paths.convert(entry));
            }
        };
    }
}

