/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.version;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.shared.version.VersionService;
import org.guvnor.common.services.shared.version.model.PortableVersionRecord;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.base.version.VersionAttributeView;
import org.kie.commons.java.nio.base.version.VersionRecord;
import org.kie.commons.java.nio.file.CopyOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.StandardCopyOption;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;

@Service
@ApplicationScoped
public class VersionServiceImpl
implements VersionService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Paths paths;
    @Inject
    private Identity identity;
    @Inject
    private SessionInfo sessionInfo;

    public List<VersionRecord> getVersion(org.uberfire.backend.vfs.Path path) {
        try {
            List records = ((VersionAttributeView)this.ioService.getFileAttributeView(this.paths.convert(path), VersionAttributeView.class)).readAttributes().history().records();
            ArrayList<VersionRecord> result = new ArrayList<VersionRecord>(records.size());
            for (VersionRecord record : records) {
                result.add((VersionRecord)new PortableVersionRecord(record.id(), record.author(), record.email(), record.comment(), record.date(), record.uri()));
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path restore(org.uberfire.backend.vfs.Path _path, String comment) {
        try {
            Path path = this.paths.convert(_path);
            Path target = path.getFileSystem().getPath(path.toString(), new String[0]);
            return this.paths.convert(this.ioService.copy(path, target, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, new CommentedOption(this.sessionInfo.getId(), this.identity.getName(), null, comment)}));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

