/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.oracle.TypeSource;
import org.guvnor.common.services.backend.file.DotFileFilter;
import org.guvnor.common.services.backend.file.JavaFileFilter;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildValidationHelper;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.runtime.KieContainer;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.scanner.KieModuleMetaData;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.workbench.events.ChangeType;
import org.uberfire.workbench.events.ResourceChange;

public class Builder {
    private static final String RESOURCE_PATH = "src/main/resources";
    private static final String ERROR_CLASS_NOT_FOUND = "Class not found";
    private KieBuilder kieBuilder;
    private final KieServices kieServices;
    private final KieFileSystem kieFileSystem;
    private final Path moduleDirectory;
    private final Paths paths;
    private final GAV gav;
    private final IOService ioService;
    private final ProjectService projectService;
    private final String projectPrefix;
    private Map<String, org.uberfire.backend.vfs.Path> handles = new HashMap<String, org.uberfire.backend.vfs.Path>();
    private final List<BuildValidationHelper> buildValidationHelpers;
    private final Map<Path, BuildValidationHelper> nonKieResourceValidationHelpers = new HashMap<Path, BuildValidationHelper>();
    private final Map<Path, List<ValidationMessage>> nonKieResourceValidationHelperMessages = new HashMap<Path, List<ValidationMessage>>();
    private final DirectoryStream.Filter<Path> javaResourceFilter = new JavaFileFilter();
    private final DirectoryStream.Filter<Path> dotFileFilter = new DotFileFilter();
    private Set<String> javaResources = new HashSet<String>();
    private KieContainer kieContainer;

    public Builder(Path moduleDirectory, GAV gav, Paths paths, IOService ioService, ProjectService projectService, List<BuildValidationHelper> buildValidationHelpers) {
        this.moduleDirectory = moduleDirectory;
        this.gav = gav;
        this.paths = paths;
        this.ioService = ioService;
        this.projectService = projectService;
        this.buildValidationHelpers = buildValidationHelpers;
        this.projectPrefix = moduleDirectory.toUri().toString();
        this.kieServices = KieServices.Factory.get();
        this.kieFileSystem = this.kieServices.newKieFileSystem();
        DirectoryStream directoryStream = Files.newDirectoryStream((Path)moduleDirectory);
        this.visitPaths((DirectoryStream<Path>)directoryStream);
    }

    public BuildResults build() {
        this.kieBuilder = this.kieServices.newKieBuilder(this.kieFileSystem);
        Results kieResults = this.kieBuilder.buildAll().getResults();
        BuildResults results = this.convertMessages(kieResults);
        for (Map.Entry<Path, BuildValidationHelper> e : this.nonKieResourceValidationHelpers.entrySet()) {
            Path resource = e.getKey();
            BuildValidationHelper validator = e.getValue();
            List validationMessages = validator.validate(this.paths.convert(resource));
            if (validationMessages == null || validationMessages.isEmpty()) continue;
            for (ValidationMessage validationMessage : validationMessages) {
                results.addBuildMessage(this.convertValidationMessage(validationMessage));
            }
            this.nonKieResourceValidationHelperMessages.put(resource, validationMessages);
        }
        Path nioExternalImportsPath = this.moduleDirectory.resolve("project.imports");
        if (Files.exists((Path)nioExternalImportsPath, (LinkOption[])new LinkOption[0])) {
            org.uberfire.backend.vfs.Path externalImportsPath = this.paths.convert(nioExternalImportsPath);
            ProjectImports projectImports = (ProjectImports)this.projectService.load(externalImportsPath);
            Imports imports = projectImports.getImports();
            for (Import item : imports.getImports()) {
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(item.getType());
                }
                catch (ClassNotFoundException cnfe) {
                    results.addBuildMessage(this.makeMessage(ERROR_CLASS_NOT_FOUND, cnfe));
                }
            }
        }
        if (results.getMessages().isEmpty()) {
            this.kieContainer = this.kieServices.newKieContainer(this.kieBuilder.getKieModule().getReleaseId());
        }
        return results;
    }

    public IncrementalBuildResults addResource(Path resource) {
        PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
        if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) {
            return new IncrementalBuildResults(this.gav);
        }
        if (!this.isBuilt()) {
            throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
        }
        String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
        InputStream is = this.ioService.newInputStream(resource, new OpenOption[0]);
        BufferedInputStream bis = new BufferedInputStream(is);
        this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
        this.addJavaClass(resource);
        this.handles.put(destinationPath, this.paths.convert(resource));
        IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(new String[]{destinationPath}).build();
        IncrementalBuildResults results = this.convertMessages(incrementalResults);
        for (Message message : incrementalResults.getRemovedMessages()) {
            this.handles.remove("src/main/resources/" + message.getPath());
        }
        BuildValidationHelper validator = this.getBuildValidationHelper(resource);
        if (validator != null) {
            List<ValidationMessage> removedValidationMessages;
            this.nonKieResourceValidationHelpers.put(resource, validator);
            List addedValidationMessages = validator.validate(this.paths.convert(resource));
            if (addedValidationMessages != null && !addedValidationMessages.isEmpty()) {
                for (ValidationMessage validationMessage : addedValidationMessages) {
                    results.addAddedMessage(this.convertValidationMessage(validationMessage));
                }
            }
            if ((removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource)) != null && !removedValidationMessages.isEmpty()) {
                for (ValidationMessage validationMessage : removedValidationMessages) {
                    results.addRemovedMessage(this.convertValidationMessage(validationMessage));
                }
            }
            this.nonKieResourceValidationHelperMessages.put(resource, addedValidationMessages);
        }
        return results;
    }

    public IncrementalBuildResults deleteResource(Path resource) {
        PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
        if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) {
            return new IncrementalBuildResults(this.gav);
        }
        if (!this.isBuilt()) {
            throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
        }
        String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
        this.kieFileSystem.delete(new String[]{destinationPath});
        this.removeJavaClass(resource);
        IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(new String[]{destinationPath}).build();
        IncrementalBuildResults results = this.convertMessages(incrementalResults);
        for (Message message : incrementalResults.getRemovedMessages()) {
            this.handles.remove("src/main/resources/" + message.getPath());
        }
        BuildValidationHelper validator = this.getBuildValidationHelper(resource);
        if (validator != null) {
            this.nonKieResourceValidationHelpers.remove(resource);
            List<ValidationMessage> removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource);
            if (removedValidationMessages != null && !removedValidationMessages.isEmpty()) {
                for (ValidationMessage validationMessage : removedValidationMessages) {
                    results.addRemovedMessage(this.convertValidationMessage(validationMessage));
                }
            }
        }
        return results;
    }

    public IncrementalBuildResults updateResource(Path resource) {
        return this.addResource(resource);
    }

    public IncrementalBuildResults applyBatchResourceChanges(Set<ResourceChange> changes) {
        PortablePreconditions.checkNotNull((String)"changes", changes);
        if (!this.isBuilt()) {
            throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
        }
        ArrayList<String> changedFilesKieBuilderPaths = new ArrayList<String>();
        ArrayList<ValidationMessage> nonKieResourceValidatorAddedMessages = new ArrayList<ValidationMessage>();
        ArrayList<ValidationMessage> nonKieResourceValidatorRemovedMessages = new ArrayList<ValidationMessage>();
        for (ResourceChange change : changes) {
            ChangeType type = change.getType();
            Path resource = this.paths.convert(change.getPath());
            if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) continue;
            PortablePreconditions.checkNotNull((String)"type", (Object)type);
            PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
            BuildValidationHelper validator = this.getBuildValidationHelper(resource);
            String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
            changedFilesKieBuilderPaths.add(destinationPath);
            switch (type) {
                case ADD: 
                case UPDATE: {
                    List<ValidationMessage> removedValidationMessages;
                    InputStream is = this.ioService.newInputStream(resource, new OpenOption[0]);
                    BufferedInputStream bis = new BufferedInputStream(is);
                    this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
                    this.addJavaClass(resource);
                    this.handles.put(destinationPath, change.getPath());
                    if (validator == null) break;
                    this.nonKieResourceValidationHelpers.put(resource, validator);
                    List addedValidationMessages = validator.validate(this.paths.convert(resource));
                    if (addedValidationMessages != null && !addedValidationMessages.isEmpty()) {
                        for (ValidationMessage validationMessage : addedValidationMessages) {
                            nonKieResourceValidatorAddedMessages.add(validationMessage);
                        }
                    }
                    if ((removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource)) != null && !removedValidationMessages.isEmpty()) {
                        for (ValidationMessage validationMessage : removedValidationMessages) {
                            nonKieResourceValidatorRemovedMessages.add(validationMessage);
                        }
                    }
                    this.nonKieResourceValidationHelperMessages.put(resource, addedValidationMessages);
                    break;
                }
                case DELETE: {
                    this.kieFileSystem.delete(new String[]{destinationPath});
                    this.removeJavaClass(resource);
                    if (validator == null) break;
                    this.nonKieResourceValidationHelpers.remove(resource);
                    List<ValidationMessage> removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource);
                    if (removedValidationMessages == null || removedValidationMessages.isEmpty()) break;
                    for (ValidationMessage validationMessage : removedValidationMessages) {
                        nonKieResourceValidatorRemovedMessages.add(validationMessage);
                    }
                    break;
                }
            }
        }
        String[] kieBuilderPaths = new String[changedFilesKieBuilderPaths.size()];
        changedFilesKieBuilderPaths.toArray(kieBuilderPaths);
        IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(kieBuilderPaths).build();
        IncrementalBuildResults results = this.convertMessages(incrementalResults);
        for (ValidationMessage addedValidationMessage : nonKieResourceValidatorAddedMessages) {
            results.addAddedMessage(this.convertValidationMessage(addedValidationMessage));
        }
        for (ValidationMessage removedValidationMessage : nonKieResourceValidatorRemovedMessages) {
            results.addRemovedMessage(this.convertValidationMessage(removedValidationMessage));
        }
        for (Message message : incrementalResults.getRemovedMessages()) {
            this.handles.remove("src/main/resources/" + message.getPath());
        }
        return results;
    }

    public KieModule getKieModule() {
        if (!this.isBuilt()) {
            this.build();
        }
        return this.kieBuilder.getKieModule();
    }

    public KieModule getKieModuleIgnoringErrors() {
        if (!this.isBuilt()) {
            this.build();
        }
        return ((InternalKieBuilder)this.kieBuilder).getKieModuleIgnoringErrors();
    }

    public KieContainer getKieContainer() {
        if (!this.isBuilt()) {
            this.build();
        }
        return this.kieContainer;
    }

    public boolean isBuilt() {
        return this.kieBuilder != null;
    }

    private void visitPaths(DirectoryStream<Path> directoryStream) {
        for (Path path : directoryStream) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                this.visitPaths((DirectoryStream<Path>)Files.newDirectoryStream((Path)path));
                continue;
            }
            if (this.dotFileFilter.accept((Object)path)) continue;
            String destinationPath = path.toUri().toString().substring(this.projectPrefix.length() + 1);
            InputStream is = this.ioService.newInputStream(path, new OpenOption[0]);
            BufferedInputStream bis = new BufferedInputStream(is);
            this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
            this.addJavaClass(path);
            this.handles.put(destinationPath, this.paths.convert(path));
            BuildValidationHelper validator = this.getBuildValidationHelper(path);
            if (validator == null) continue;
            this.nonKieResourceValidationHelpers.put(path, validator);
        }
    }

    private BuildResults convertMessages(Results kieBuildResults) {
        BuildResults results = new BuildResults(this.gav);
        for (Message message : kieBuildResults.getMessages()) {
            results.addBuildMessage(this.convertMessage(message));
        }
        return results;
    }

    private IncrementalBuildResults convertMessages(IncrementalResults kieIncrementalResults) {
        IncrementalBuildResults results = new IncrementalBuildResults(this.gav);
        for (Message message : kieIncrementalResults.getAddedMessages()) {
            results.addAddedMessage(this.convertMessage(message));
        }
        for (Message message : kieIncrementalResults.getRemovedMessages()) {
            results.addRemovedMessage(this.convertMessage(message));
        }
        return results;
    }

    private BuildMessage convertMessage(Message message) {
        BuildMessage m = new BuildMessage();
        switch (message.getLevel()) {
            case ERROR: {
                m.setLevel(BuildMessage.Level.ERROR);
                break;
            }
            case WARNING: {
                m.setLevel(BuildMessage.Level.WARNING);
                break;
            }
            case INFO: {
                m.setLevel(BuildMessage.Level.INFO);
            }
        }
        m.setId(message.getId());
        m.setLine(message.getLine());
        if (message.getPath() != null && !message.getPath().isEmpty()) {
            m.setPath(this.handles.get("src/main/resources/" + message.getPath()));
        }
        m.setColumn(message.getColumn());
        m.setText(message.getText());
        return m;
    }

    private BuildMessage convertValidationMessage(ValidationMessage message) {
        BuildMessage m = new BuildMessage();
        switch (message.getLevel()) {
            case ERROR: {
                m.setLevel(BuildMessage.Level.ERROR);
                break;
            }
            case WARNING: {
                m.setLevel(BuildMessage.Level.WARNING);
                break;
            }
            case INFO: {
                m.setLevel(BuildMessage.Level.INFO);
            }
        }
        m.setId(message.getId());
        m.setLine(message.getLine());
        m.setColumn(message.getColumn());
        m.setText(message.getText());
        m.setPath(message.getPath());
        return m;
    }

    private BuildMessage makeMessage(String prefix, Exception e) {
        BuildMessage buildMessage = new BuildMessage();
        buildMessage.setLevel(BuildMessage.Level.ERROR);
        buildMessage.setText(prefix + ": " + e.getMessage());
        return buildMessage;
    }

    private void addJavaClass(Path path) {
        if (!this.javaResourceFilter.accept((Object)path)) {
            return;
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(path);
        if (fullyQualifiedClassName != null) {
            this.javaResources.add(fullyQualifiedClassName);
        }
    }

    private void removeJavaClass(Path path) {
        if (!this.javaResourceFilter.accept((Object)path)) {
            return;
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(path);
        if (fullyQualifiedClassName != null) {
            this.javaResources.remove(fullyQualifiedClassName);
        }
    }

    private String getFullyQualifiedClassName(Path path) {
        Package pkg = this.projectService.resolvePackage(this.paths.convert(path, false));
        String packageName = pkg.getPackageName();
        if (packageName == null) {
            return null;
        }
        String className = path.getFileName().toString().replace(".java", "");
        return packageName.equals("") ? className : packageName + "." + className;
    }

    public TypeSource getClassSource(KieModuleMetaData metaData, Class<?> clazz) {
        if (metaData.getTypeMetaInfo(clazz).isDeclaredType()) {
            return TypeSource.DECLARED;
        }
        String fullyQualifiedClassName = clazz.getName();
        int innerClassIdentifierIndex = fullyQualifiedClassName.indexOf("$");
        if (innerClassIdentifierIndex > 0) {
            fullyQualifiedClassName = fullyQualifiedClassName.substring(0, innerClassIdentifierIndex);
        }
        if (this.javaResources.contains(fullyQualifiedClassName)) {
            return TypeSource.JAVA_PROJECT;
        }
        return TypeSource.JAVA_DEPENDENCY;
    }

    private BuildValidationHelper getBuildValidationHelper(Path resource) {
        for (BuildValidationHelper validator : this.buildValidationHelpers) {
            if (!validator.accepts(this.paths.convert(resource))) continue;
            return validator;
        }
        return null;
    }
}

