/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.projecteditor.backend.server;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.KModuleModel;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.project.service.KModuleService;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.kie.workbench.common.services.datamodel.service.DataModelService;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class ProjectScreenServiceImpl
implements ProjectScreenService {
    @Inject
    private POMService pomService;
    @Inject
    private KModuleService kModuleService;
    @Inject
    private ProjectService projectService;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private MetadataService metadataService;

    public ProjectScreenModel load(Path pathToPom) {
        ProjectScreenModel model = new ProjectScreenModel();
        model.setProjectDataModelOracle(this.dataModelService.getProjectDataModel(pathToPom));
        model.setPOM((POM)this.pomService.load(pathToPom));
        model.setPOMMetaData(this.metadataService.getMetadata(pathToPom));
        Project project = this.projectService.resolveProject(pathToPom);
        Path pathToKModule = project.getKModuleXMLPath();
        model.setKModule((KModuleModel)this.kModuleService.load(pathToKModule));
        model.setKModuleMetaData(this.metadataService.getMetadata(pathToKModule));
        Path pathToProjectImports = project.getImportsPath();
        model.setProjectImports((ProjectImports)this.projectService.load(pathToProjectImports));
        model.setProjectImportsMetaData(this.metadataService.getMetadata(pathToProjectImports));
        return model;
    }

    public void save(Path pathToPomXML, ProjectScreenModel model, String comment) {
        Project project = this.projectService.resolveProject(pathToPomXML);
        this.pomService.save(pathToPomXML, (Object)model.getPOM(), model.getPOMMetaData(), comment);
        this.kModuleService.save(project.getKModuleXMLPath(), (Object)model.getKModule(), model.getKModuleMetaData(), comment);
        this.projectService.save(project.getImportsPath(), (Object)model.getProjectImports(), model.getProjectImportsMetaData(), comment);
    }
}

