/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.DeleteOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Option;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.workbench.common.screens.datamodeller.backend.server.DataModelerServiceHelper;
import org.kie.workbench.common.screens.datamodeller.model.AnnotationDefinitionTO;
import org.kie.workbench.common.screens.datamodeller.model.DataModelTO;
import org.kie.workbench.common.screens.datamodeller.model.DataObjectTO;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.model.PropertyTypeTO;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.screens.datamodeller.service.ServiceException;
import org.kie.workbench.common.services.datamodel.service.DataModelService;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.PropertyType;
import org.kie.workbench.common.services.datamodeller.core.impl.PropertyTypeFactoryImpl;
import org.kie.workbench.common.services.datamodeller.driver.FileChangeDescriptor;
import org.kie.workbench.common.services.datamodeller.driver.impl.DataModelOracleDriver;
import org.kie.workbench.common.services.datamodeller.util.FileUtils;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ChangeType;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;

@Service
@ApplicationScoped
public class DataModelerServiceImpl
implements DataModelerService {
    private static final Logger logger = LoggerFactory.getLogger(DataModelerServiceImpl.class);
    private static final String MAIN_JAVA_PATH = "src/main/java";
    private static final String MAIN_RESOURCES_PATH = "src/main/resources";
    private static final String TEST_JAVA_PATH = "src/test/java";
    private static final String TEST_RESOURCES_PATH = "src/test/resources";
    private static final String DEFAULT_GUVNOR_PKG = "defaultpkg";
    @Inject
    @Named(value="ioStrategy")
    IOService ioService;
    @Inject
    private Paths paths;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private Identity identity;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private Event<InvalidateDMOProjectCacheEvent> invalidateDMOProjectCache;
    @Inject
    private Event<ResourceBatchChangesEvent> resourceBatchChangesEvent;

    public org.uberfire.backend.vfs.Path createModel(org.uberfire.backend.vfs.Path context, String fileName) {
        return context;
    }

    public DataModelTO loadModel(Project project) {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading data model from path: " + project.getRootPath());
        }
        Long startTime = System.currentTimeMillis();
        DataModel dataModel = null;
        org.uberfire.backend.vfs.Path projectPath = null;
        try {
            projectPath = project.getRootPath();
            if (logger.isDebugEnabled()) {
                logger.debug("Current project path is: " + projectPath);
            }
            ProjectDataModelOracle projectDataModelOracle = this.dataModelService.getProjectDataModel(projectPath);
            DataModelOracleDriver driver = DataModelOracleDriver.getInstance();
            dataModel = driver.loadModel(projectDataModelOracle);
            DataModelTO dataModelTO = DataModelerServiceHelper.getInstance().domain2To(dataModel, DataObjectTO.PERSISTENT, true);
            Long endTime = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Time elapsed when loading " + projectPath.getFileName() + ": " + (endTime - startTime) + " ms");
            }
            return dataModelTO;
        }
        catch (Exception e) {
            logger.error("Data model couldn't be loaded, path: " + projectPath + ", projectPath: " + projectPath + ".", (Throwable)e);
            throw new ServiceException("Data model couldn't be loaded, path: " + projectPath + ", projectPath: " + projectPath + ".", (Throwable)e);
        }
    }

    public GenerationResult saveModel(DataModelTO dataModel, Project project) {
        return this.saveModel(dataModel, project, false);
    }

    public GenerationResult saveModel(DataModelTO dataModel, Project project, boolean overwrite) {
        org.uberfire.backend.vfs.Path projectPath = project.getRootPath();
        Long startTime = System.currentTimeMillis();
        boolean onBatch = false;
        try {
            Path javaPath = this.ensureProjectJavaPath(this.paths.convert(projectPath));
            if (overwrite) {
                this.mergeWithExistingModel(dataModel, project);
            }
            DataModel dataModelDomain = DataModelerServiceHelper.getInstance().to2Domain(dataModel);
            if (!overwrite) {
                this.removeUnmodifiedObjects(dataModelDomain, dataModel);
            }
            List<org.uberfire.backend.vfs.Path> deleteableFiles = this.calculateDeleteableFiles(dataModel, javaPath);
            CommentedOption option = this.makeCommentedOption("Data modeller");
            this.ioService.startBatch(new Option[0]);
            onBatch = true;
            this.cleanupFiles(deleteableFiles, option);
            javaPath = this.ensureProjectJavaPath(this.paths.convert(projectPath));
            DataModelOracleDriver driver = DataModelOracleDriver.getInstance();
            driver.generateModel(dataModelDomain, this.ioService, javaPath, (OpenOption)option);
            onBatch = false;
            this.ioService.endBatch(new Option[0]);
            Long endTime = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Time elapsed when saving " + projectPath.getFileName() + ": " + (endTime - startTime) + " ms");
            }
            GenerationResult result = new GenerationResult();
            result.setGenerationTime(endTime - startTime);
            result.setObjectFingerPrints(DataModelerServiceHelper.getInstance().claculateFingerPrints(dataModel));
            return result;
        }
        catch (Exception e) {
            logger.error("An error was produced during data model generation, dataModel: " + dataModel + ", path: " + projectPath, (Throwable)e);
            if (onBatch) {
                try {
                    logger.warn("IOService batch method is still on, trying to end batch processing.");
                    this.ioService.endBatch(new Option[0]);
                    logger.warn("IOService batch method is was successfully finished. The user will still get the exception, but the batch processing was finished.");
                }
                catch (Exception ex) {
                    logger.error("An error was produced when the IOService.endBatch processing was executed.", (Throwable)ex);
                }
            }
            throw new ServiceException("Data model: " + dataModel.getParentProjectName() + ", couldn't be generated due to the following error. " + e);
        }
    }

    private void mergeWithExistingModel(DataModelTO dataModel, Project project) {
        HashMap<String, DataObjectTO> deletedObjects = new HashMap<String, DataObjectTO>();
        HashMap<String, DataObjectTO> currentObjects = new HashMap<String, DataObjectTO>();
        DataModelTO reloadedModel = this.loadModel(project);
        for (DataObjectTO dataObject : dataModel.getDataObjects()) {
            currentObjects.put(dataObject.getClassName(), dataObject);
        }
        for (DataObjectTO dataObject : dataModel.getDeletedDataObjects()) {
            deletedObjects.put(dataObject.getClassName(), dataObject);
        }
        for (DataObjectTO reloadedDataObject : reloadedModel.getDataObjects()) {
            if (currentObjects.containsKey(reloadedDataObject.getClassName()) || deletedObjects.containsKey(reloadedDataObject.getClassName())) continue;
            dataModel.getDeletedDataObjects().add(reloadedDataObject);
        }
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption option = new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
        return option;
    }

    public List<PropertyTypeTO> getBasePropertyTypes() {
        ArrayList<PropertyTypeTO> types = new ArrayList<PropertyTypeTO>();
        for (PropertyType baseType : PropertyTypeFactoryImpl.getInstance().getBasePropertyTypes()) {
            types.add(new PropertyTypeTO(baseType.getName(), baseType.getClassName()));
        }
        return types;
    }

    public Map<String, AnnotationDefinitionTO> getAnnotationDefinitions() {
        HashMap<String, AnnotationDefinitionTO> annotations = new HashMap<String, AnnotationDefinitionTO>();
        List annotationDefinitions = DataModelOracleDriver.getInstance().getConfiguredAnnotations();
        DataModelerServiceHelper serviceHelper = DataModelerServiceHelper.getInstance();
        for (AnnotationDefinition annotationDefinition : annotationDefinitions) {
            AnnotationDefinitionTO annotationDefinitionTO = serviceHelper.domain2To(annotationDefinition);
            annotations.put(annotationDefinitionTO.getClassName(), annotationDefinitionTO);
        }
        return annotations;
    }

    private void notifyFileChanges(List<org.uberfire.backend.vfs.Path> deleteableFiles, List<FileChangeDescriptor> driverChanges) {
        HashSet<ResourceChange> batchChanges = new HashSet<ResourceChange>();
        for (org.uberfire.backend.vfs.Path deleteableFile : deleteableFiles) {
            batchChanges.add(new ResourceChange(ChangeType.DELETE, deleteableFile, this.sessionInfo));
        }
        for (FileChangeDescriptor driverChange : driverChanges) {
            switch (driverChange.getAction()) {
                case 0: {
                    logger.debug("Notifying file created: " + driverChange.getPath());
                    batchChanges.add(new ResourceChange(ChangeType.ADD, this.paths.convert(driverChange.getPath()), this.sessionInfo));
                    break;
                }
                case 1: {
                    logger.debug("Notifying file deleted: " + driverChange.getPath());
                    batchChanges.add(new ResourceChange(ChangeType.DELETE, this.paths.convert(driverChange.getPath()), this.sessionInfo));
                    break;
                }
                case 2: {
                    logger.debug("Notifying file updated: " + driverChange.getPath());
                    batchChanges.add(new ResourceChange(ChangeType.UPDATE, this.paths.convert(driverChange.getPath()), this.sessionInfo));
                }
            }
        }
        if (batchChanges.size() > 0) {
            this.resourceBatchChangesEvent.fire((Object)new ResourceBatchChangesEvent(batchChanges));
        }
    }

    private List<org.uberfire.backend.vfs.Path> calculateDeleteableFiles(DataModelTO dataModel, Path javaPath) {
        Path filePath;
        List currentObjects = dataModel.getDataObjects();
        List deletedObjects = dataModel.getDeletedDataObjects();
        ArrayList<org.uberfire.backend.vfs.Path> deleteableFiles = new ArrayList<org.uberfire.backend.vfs.Path>();
        for (DataObjectTO dataObject : deletedObjects) {
            if (!dataObject.isPersistent()) continue;
            filePath = this.calculateFilePath(dataObject.getOriginalClassName(), javaPath);
            if (dataModel.getDataObjectByClassName(dataObject.getOriginalClassName()) != null) continue;
            deleteableFiles.add(this.paths.convert(filePath));
        }
        for (DataObjectTO dataObject : currentObjects) {
            if (!dataObject.isPersistent() || !dataObject.classNameChanged()) continue;
            filePath = this.calculateFilePath(dataObject.getOriginalClassName(), javaPath);
            if (dataModel.getDataObjectByClassName(dataObject.getOriginalClassName()) != null) continue;
            deleteableFiles.add(this.paths.convert(filePath));
        }
        return deleteableFiles;
    }

    private void removeUnmodifiedObjects(DataModel dataModelDomain, DataModelTO dataModelTO) throws Exception {
        for (DataObjectTO dataObject : dataModelTO.getDataObjects()) {
            String newFingerPrint = DataModelerServiceHelper.getInstance().calculateFingerPrint(dataObject.getStringId());
            if (!newFingerPrint.equals(dataObject.getFingerPrint())) continue;
            logger.debug("XXXXXXXXXXXXXXXXXXX the class : " + dataObject.getClassName() + " wasn't modified");
            dataModelDomain.removeDataObject(dataObject.getClassName());
        }
    }

    private void cleanupFiles(List<org.uberfire.backend.vfs.Path> deleteableFiles, CommentedOption option) {
        for (org.uberfire.backend.vfs.Path filePath : deleteableFiles) {
            this.ioService.deleteIfExists(this.paths.convert(filePath), new DeleteOption[]{option});
        }
    }

    private List<ResourceChange> cleanupFiles(DataModelTO dataModel, Path javaPath) {
        Path filePath;
        List currentObjects = dataModel.getDataObjects();
        List deletedObjects = dataModel.getDeletedDataObjects();
        ArrayList<ResourceChange> fileChanges = new ArrayList<ResourceChange>();
        for (DataObjectTO dataObject : deletedObjects) {
            if (!dataObject.isPersistent()) continue;
            filePath = this.calculateFilePath(dataObject.getOriginalClassName(), javaPath);
            if (dataModel.getDataObjectByClassName(dataObject.getOriginalClassName()) != null) continue;
            fileChanges.add(new ResourceChange(ChangeType.DELETE, this.paths.convert(filePath), this.sessionInfo));
            this.ioService.delete(filePath, new DeleteOption[0]);
        }
        for (DataObjectTO dataObject : currentObjects) {
            if (!dataObject.isPersistent() || !dataObject.classNameChanged()) continue;
            filePath = this.calculateFilePath(dataObject.getOriginalClassName(), javaPath);
            if (dataModel.getDataObjectByClassName(dataObject.getOriginalClassName()) != null) continue;
            fileChanges.add(new ResourceChange(ChangeType.DELETE, this.paths.convert(filePath), this.sessionInfo));
            this.ioService.delete(filePath, new DeleteOption[0]);
        }
        return fileChanges;
    }

    private void cleanupEmptyDirs(Path pojectPath) {
        FileUtils fileUtils = FileUtils.getInstance();
        ArrayList<String> deleteableFiles = new ArrayList<String>();
        deleteableFiles.add(".gitignore");
        fileUtils.cleanEmptyDirectories(this.ioService, pojectPath, false, deleteableFiles);
    }

    private Path existsProjectJavaPath(Path projectPath) {
        Path javaPath = projectPath.resolve("src").resolve("main").resolve("java");
        if (this.ioService.exists(javaPath)) {
            return javaPath;
        }
        return null;
    }

    private Path ensureProjectJavaPath(Path projectPath) {
        Path javaPath = projectPath.resolve("src");
        if (!this.ioService.exists(javaPath)) {
            javaPath = this.ioService.createDirectory(javaPath, new FileAttribute[0]);
        }
        if (!this.ioService.exists(javaPath = javaPath.resolve("main"))) {
            javaPath = this.ioService.createDirectory(javaPath, new FileAttribute[0]);
        }
        if (!this.ioService.exists(javaPath = javaPath.resolve("java"))) {
            javaPath = this.ioService.createDirectory(javaPath, new FileAttribute[0]);
        }
        return javaPath;
    }

    private Path calculateFilePath(String className, Path javaPath) {
        String name = NamingUtils.getInstance().extractClassName(className);
        String packageName = NamingUtils.getInstance().extractPackageName(className);
        Path filePath = javaPath;
        if (packageName != null) {
            List packageNameTokens = NamingUtils.getInstance().tokenizePackageName(packageName);
            for (String token : packageNameTokens) {
                filePath = filePath.resolve(token);
            }
        }
        filePath = filePath.resolve(name + ".java");
        return filePath;
    }
}

