/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.drools.ide.common.client.modeldriven.dt.ActionCol;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionRetractFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionRetractFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DescriptionCol52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.MetadataCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.drools.ide.common.client.modeldriven.dt52.RowNumberCol52;
import org.drools.ide.common.server.util.upgrade.IUpgradeHelper;

public class GuidedDecisionTableUpgradeHelper1
implements IUpgradeHelper<GuidedDecisionTable52, GuidedDecisionTable> {
    /*
     * WARNING - void declaration
     */
    @Override
    public GuidedDecisionTable52 upgrade(GuidedDecisionTable legacyDTModel) {
        void var6_17;
        this.assertConditionColumnPatternGrouping(legacyDTModel);
        GuidedDecisionTable52 newDTModel = new GuidedDecisionTable52();
        newDTModel.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        newDTModel.setTableName(legacyDTModel.tableName);
        newDTModel.setParentName(legacyDTModel.parentName);
        newDTModel.setRowNumberCol(new RowNumberCol52());
        newDTModel.setDescriptionCol(new DescriptionCol52());
        for (MetadataCol metadataCol : legacyDTModel.getMetadataCols()) {
            newDTModel.getMetadataCols().add(this.makeNewColumn(metadataCol));
        }
        for (AttributeCol attributeCol : legacyDTModel.attributeCols) {
            newDTModel.getAttributeCols().add(this.makeNewColumn(attributeCol));
        }
        ArrayList<Pattern52> patterns = new ArrayList<Pattern52>();
        HashMap<String, Pattern52> hashMap = new HashMap<String, Pattern52>();
        for (int i = 0; i < legacyDTModel.conditionCols.size(); ++i) {
            ConditionCol conditionCol = legacyDTModel.conditionCols.get(i);
            String boundName = conditionCol.boundName;
            Pattern52 p = (Pattern52)hashMap.get(boundName);
            if (p == null) {
                p = new Pattern52();
                p.setBoundName(boundName);
                p.setFactType(conditionCol.factType);
                patterns.add(p);
                hashMap.put(boundName, p);
            }
            if (p.getFactType() != null && !p.getFactType().equals(conditionCol.factType)) {
                throw new IllegalArgumentException("Inconsistent FactTypes for ConditionCols bound to '" + boundName + "' detected.");
            }
            p.getChildColumns().add(this.makeNewColumn(conditionCol));
        }
        for (Pattern52 pattern52 : patterns) {
            newDTModel.getConditions().add(pattern52);
        }
        for (ActionCol actionCol : legacyDTModel.actionCols) {
            newDTModel.getActionCols().add(this.makeNewColumn(actionCol));
        }
        newDTModel.setData(this.makeDataLists(legacyDTModel.data));
        int DATA_COLUMN_OFFSET = legacyDTModel.conditionCols.size() + legacyDTModel.getMetadataCols().size() + legacyDTModel.attributeCols.size() + 2;
        boolean bl = false;
        while (var6_17 < legacyDTModel.actionCols.size()) {
            ActionCol lc = legacyDTModel.actionCols.get((int)var6_17);
            if (lc instanceof ActionRetractFactCol) {
                String boundName = ((ActionRetractFactCol)lc).boundName;
                for (List<DTCellValue52> row : newDTModel.getData()) {
                    row.get(DATA_COLUMN_OFFSET + var6_17).setStringValue(boundName);
                }
            }
            ++var6_17;
        }
        return newDTModel;
    }

    private void assertConditionColumnPatternGrouping(GuidedDecisionTable model) {
        class ConditionColData {
            ConditionCol col;
            String[] data;

            ConditionColData() {
            }
        }
        String[] row;
        int iRow;
        int colIndex;
        int iCol;
        int DATA_COLUMN_OFFSET = model.getMetadataCols().size() + model.attributeCols.size() + 2;
        TreeMap uniqueGroups = new TreeMap();
        ArrayList groups = new ArrayList();
        int DATA_ROWS = model.data.length;
        for (iCol = 0; iCol < model.conditionCols.size(); ++iCol) {
            ConditionCol col = model.conditionCols.get(iCol);
            String string = col.boundName + "";
            ArrayList<ConditionColData> groupCols = (ArrayList<ConditionColData>)uniqueGroups.get(string);
            if (groupCols == null) {
                groupCols = new ArrayList<ConditionColData>();
                groups.add(groupCols);
                uniqueGroups.put(string, groupCols);
            }
            ConditionColData ccd = new ConditionColData();
            colIndex = DATA_COLUMN_OFFSET + iCol;
            ccd.data = new String[DATA_ROWS];
            for (iRow = 0; iRow < DATA_ROWS; ++iRow) {
                row = model.data[iRow];
                ccd.data[iRow] = row[colIndex];
            }
            ccd.col = col;
            groupCols.add(ccd);
        }
        iCol = 0;
        model.conditionCols.clear();
        for (List list : groups) {
            for (ConditionColData ccd : list) {
                model.conditionCols.add(ccd.col);
                colIndex = DATA_COLUMN_OFFSET + iCol;
                for (iRow = 0; iRow < DATA_ROWS; ++iRow) {
                    row = model.data[iRow];
                    row[colIndex] = ccd.data[iRow];
                }
                ++iCol;
            }
        }
    }

    public List<List<DTCellValue52>> makeDataLists(Object[][] oldData) {
        ArrayList<List<DTCellValue52>> newData = new ArrayList<List<DTCellValue52>>();
        for (int iRow = 0; iRow < oldData.length; ++iRow) {
            Object[] oldRow = oldData[iRow];
            List<DTCellValue52> newRow = this.makeDataRowList(oldRow);
            newData.add(newRow);
        }
        return newData;
    }

    public List<DTCellValue52> makeDataRowList(Object[] oldRow) {
        DTCellValue52 rowDcv;
        ArrayList<DTCellValue52> row = new ArrayList<DTCellValue52>();
        if (oldRow[0] instanceof String) {
            rowDcv = new DTCellValue52(new Integer((String)oldRow[0]));
            row.add(rowDcv);
        } else if (oldRow[0] instanceof Number) {
            rowDcv = new DTCellValue52(((Number)oldRow[0]).intValue());
            row.add(rowDcv);
        } else {
            rowDcv = new DTCellValue52(oldRow[0]);
            row.add(rowDcv);
        }
        for (int iCol = 1; iCol < oldRow.length; ++iCol) {
            DTCellValue52 dcv = new DTCellValue52(oldRow[iCol]);
            row.add(dcv);
        }
        return row;
    }

    private AttributeCol52 makeNewColumn(AttributeCol c) {
        AttributeCol52 nc = new AttributeCol52();
        nc.setAttribute(c.attr);
        nc.setDefaultValue(new DTCellValue52(c.defaultValue));
        nc.setHideColumn(c.hideColumn);
        nc.setReverseOrder(c.reverseOrder);
        nc.setUseRowNumber(c.useRowNumber);
        nc.setWidth(c.width);
        return nc;
    }

    private MetadataCol52 makeNewColumn(MetadataCol c) {
        MetadataCol52 nc = new MetadataCol52();
        nc.setDefaultValue(new DTCellValue52(c.defaultValue));
        nc.setHideColumn(c.hideColumn);
        nc.setMetadata(c.attr);
        nc.setWidth(c.width);
        return nc;
    }

    private ConditionCol52 makeNewColumn(ConditionCol c) {
        ConditionCol52 nc = new ConditionCol52();
        nc.setConstraintValueType(c.constraintValueType);
        nc.setDefaultValue(new DTCellValue52(c.defaultValue));
        nc.setFactField(c.factField);
        nc.setFieldType("String");
        nc.setHeader(c.header);
        nc.setHideColumn(c.hideColumn);
        nc.setOperator(c.operator);
        nc.setValueList(c.valueList);
        nc.setWidth(c.width);
        return nc;
    }

    private ActionCol52 makeNewColumn(ActionCol c) {
        if (c instanceof ActionInsertFactCol) {
            return this.makeNewColumn((ActionInsertFactCol)c);
        }
        if (c instanceof ActionRetractFactCol) {
            return this.makeNewColumn((ActionRetractFactCol)c);
        }
        if (c instanceof ActionSetFieldCol) {
            return this.makeNewColumn((ActionSetFieldCol)c);
        }
        ActionCol52 nc = new ActionCol52();
        nc.setDefaultValue(new DTCellValue52(c.defaultValue));
        nc.setHeader(c.header);
        nc.setHideColumn(c.hideColumn);
        nc.setWidth(c.width);
        return nc;
    }

    private ActionInsertFactCol52 makeNewColumn(ActionInsertFactCol c) {
        ActionInsertFactCol52 nc = new ActionInsertFactCol52();
        nc.setBoundName(c.boundName);
        nc.setDefaultValue(new DTCellValue52(c.defaultValue));
        nc.setFactField(c.factField);
        nc.setFactType(c.factType);
        nc.setHeader(c.header);
        nc.setHideColumn(c.hideColumn);
        nc.setType(c.type);
        nc.setValueList(c.valueList);
        nc.setWidth(c.width);
        return nc;
    }

    private ActionRetractFactCol52 makeNewColumn(ActionRetractFactCol c) {
        ActionRetractFactCol52 nc = new ActionRetractFactCol52();
        nc.setDefaultValue(new DTCellValue52(c.defaultValue));
        nc.setHeader(c.header);
        nc.setHideColumn(c.hideColumn);
        nc.setWidth(c.width);
        return nc;
    }

    private ActionSetFieldCol52 makeNewColumn(ActionSetFieldCol c) {
        ActionSetFieldCol52 nc = new ActionSetFieldCol52();
        nc.setBoundName(c.boundName);
        nc.setDefaultValue(new DTCellValue52(c.defaultValue));
        nc.setFactField(c.factField);
        nc.setHeader(c.header);
        nc.setHideColumn(c.hideColumn);
        nc.setType(c.type);
        nc.setUpdate(c.update);
        nc.setValueList(c.valueList);
        nc.setWidth(c.width);
        return nc;
    }
}

