/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.io.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.core.io.internal.InternalResource;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;

public abstract class BaseResource
implements InternalResource,
Externalizable {
    private ResourceType resourceType;
    private ResourceConfiguration configuration;
    private String sourcePath;
    private String targetPath;
    private String description;
    private List<String> categories;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.resourceType = (ResourceType)in.readObject();
        this.configuration = (ResourceConfiguration)in.readObject();
        this.sourcePath = (String)in.readObject();
        this.targetPath = (String)in.readObject();
        this.description = (String)in.readObject();
        this.categories = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.resourceType);
        out.writeObject(this.configuration);
        out.writeObject(this.sourcePath);
        out.writeObject(this.targetPath);
        out.writeObject(this.description);
        out.writeObject(this.categories);
    }

    @Override
    public ResourceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public InternalResource setConfiguration(ResourceConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    @Override
    public InternalResource setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Override
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public InternalResource setSourcePath(String path) {
        this.sourcePath = path;
        return this;
    }

    public InternalResource setTargetPath(String path) {
        this.targetPath = path;
        return this;
    }

    @Override
    public List<String> getCategories() {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        return this.categories;
    }

    @Override
    public void setCategories(String categories) {
        List<String> list = this.getCategories();
        list.clear();
        if (categories != null) {
            StringTokenizer tok = new StringTokenizer(categories, ",");
            while (tok.hasMoreTokens()) {
                list.add(tok.nextToken());
            }
        }
    }

    @Override
    public void addCategory(String tag) {
        this.getCategories().add(tag);
    }

    public String toString() {
        return this.getSourcePath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource that = (Resource)o;
        return this.sourcePath != null ? this.sourcePath.equals(that.getSourcePath()) : that.getSourcePath() == null;
    }

    public int hashCode() {
        return this.sourcePath != null ? this.sourcePath.hashCode() : 0;
    }
}

