/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import org.drools.core.rule.Package;
import org.drools.core.rule.Rule;
import org.drools.core.rule.RuleConstructionException;

public class DuplicateRuleNameException
extends RuleConstructionException {
    private static final long serialVersionUID = 510L;
    private Package pkg;
    private Rule originalRule;
    private Rule conflictingRule;

    public DuplicateRuleNameException(Package pkg, Rule originalRule, Rule conflictingRule) {
        super(DuplicateRuleNameException.createMessage(pkg, conflictingRule));
        this.pkg = pkg;
        this.originalRule = originalRule;
        this.conflictingRule = conflictingRule;
    }

    public DuplicateRuleNameException(Package pkg, Rule originalRule, Rule conflictingRule, Throwable cause) {
        super(DuplicateRuleNameException.createMessage(pkg, conflictingRule), cause);
        this.pkg = pkg;
        this.originalRule = originalRule;
        this.conflictingRule = conflictingRule;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public Rule getOriginalRule() {
        return this.originalRule;
    }

    public Rule getConflictingRule() {
        return this.conflictingRule;
    }

    private static String createMessage(Package pkg, Rule rule) {
        return "Package " + (pkg.getName() != null ? pkg.getName() : "<no-name>") + " already contains rule with name " + rule.getName();
    }
}

