/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Serializable;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;

public class RBTree<K extends Comparable<? super K>, V>
implements Serializable {
    public static final boolean VERIFY_RBTREE = false;
    private static final int INDENT_STEP = 4;
    public Node<K, V> root = null;

    public RBTree() {
        this.verifyProperties();
    }

    public void verifyProperties() {
    }

    private static void verifyProperty1(Node<?, ?> n) {
        assert (RBTree.nodeColor(n) == Color.RED || RBTree.nodeColor(n) == Color.BLACK);
        if (n == null) {
            return;
        }
        RBTree.verifyProperty1(n.left);
        RBTree.verifyProperty1(n.right);
    }

    private static void verifyProperty2(Node<?, ?> root) {
        assert (RBTree.nodeColor(root) == Color.BLACK);
    }

    private static Color nodeColor(Node<?, ?> n) {
        return n == null ? Color.BLACK : n.color;
    }

    private static void verifyProperty4(Node<?, ?> n) {
        if (RBTree.nodeColor(n) == Color.RED) {
            assert (RBTree.nodeColor(n.left) == Color.BLACK);
            assert (RBTree.nodeColor(n.right) == Color.BLACK);
            assert (RBTree.nodeColor(n.parent) == Color.BLACK);
        }
        if (n == null) {
            return;
        }
        RBTree.verifyProperty4(n.left);
        RBTree.verifyProperty4(n.right);
    }

    private static void verifyProperty5(Node<?, ?> root) {
        RBTree.verifyProperty5Helper(root, 0, -1);
    }

    private static int verifyProperty5Helper(Node<?, ?> n, int blackCount, int pathBlackCount) {
        if (RBTree.nodeColor(n) == Color.BLACK) {
            ++blackCount;
        }
        if (n == null) {
            if (pathBlackCount == -1) {
                pathBlackCount = blackCount;
            } else assert (blackCount == pathBlackCount);
            return pathBlackCount;
        }
        pathBlackCount = RBTree.verifyProperty5Helper(n.left, blackCount, pathBlackCount);
        pathBlackCount = RBTree.verifyProperty5Helper(n.right, blackCount, pathBlackCount);
        return pathBlackCount;
    }

    private Node<K, V> lookupNode(K key) {
        Node<K, V> n = this.root;
        while (n != null) {
            int compResult = key.compareTo(n.key);
            if (compResult == 0) {
                return n;
            }
            if (compResult < 0) {
                n = n.left;
                continue;
            }
            n = n.right;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public Node<K, V> first() {
        if (this.root == null) {
            return null;
        }
        Node<K, V> n = this.root;
        while (n.left != null) {
            n = n.left;
        }
        return n;
    }

    public Node<K, V> last() {
        if (this.root == null) {
            return null;
        }
        Node<K, V> n = this.root;
        while (n.right != null) {
            n = n.right;
        }
        return n;
    }

    public FastIterator fastIterator() {
        return this.root == null ? FastIterator.EMPTY : new RBTreeFastIterator<K, V>(this.first(), null);
    }

    public FastIterator range(K lowerBound, boolean testLowerEqual, K upperBound, boolean testUpperEqual) {
        Node<K, V> lowerNearest = this.findNearestNode(lowerBound, testLowerEqual, Boundary.LOWER);
        Node<K, V> upperNearest = this.findNearestNode(upperBound, testUpperEqual, Boundary.UPPER);
        if (lowerNearest == null || upperNearest == null) {
            return FastIterator.EMPTY;
        }
        if (lowerNearest.key.compareTo(upperNearest.key) > 0) {
            upperNearest = lowerNearest;
        }
        return new RBTreeFastIterator<K, V>(lowerNearest, upperNearest);
    }

    public Node<K, V> findNearestNode(K key, boolean allowEqual, Boundary boundary) {
        Node<K, V> nearest = null;
        Node<K, V> n = this.root;
        while (n != null) {
            int compResult = key.compareTo(n.key);
            if (allowEqual && compResult == 0) {
                return n;
            }
            boolean accepted = this.acceptNode(compResult, boundary);
            if (this.acceptNode(compResult, boundary) && (nearest == null || this.acceptNode(n.key.compareTo(nearest.key), boundary))) {
                nearest = n;
            }
            if (compResult == 0) {
                n = boundary == Boundary.LOWER ? n.right : n.left;
                continue;
            }
            n = accepted ^ boundary == Boundary.LOWER ? n.right : n.left;
        }
        return nearest;
    }

    private boolean acceptNode(int compResult, Boundary boundary) {
        return compResult != 0 && compResult > 0 ^ boundary == Boundary.LOWER;
    }

    public V lookup(K key) {
        Node<K, V> n = this.lookupNode(key);
        return n == null ? null : (V)n.value;
    }

    private void rotateLeft(Node<K, V> n) {
        Node r = n.right;
        this.replaceNode(n, r);
        n.right = r.left;
        if (r.left != null) {
            r.left.parent = n;
        }
        r.left = n;
        n.parent = r;
    }

    private void rotateRight(Node<K, V> n) {
        Node l = n.left;
        this.replaceNode(n, l);
        n.left = l.right;
        if (l.right != null) {
            l.right.parent = n;
        }
        l.right = n;
        n.parent = l;
    }

    private void replaceNode(Node<K, V> oldn, Node<K, V> newn) {
        if (oldn.parent == null) {
            this.root = newn;
        } else if (oldn == oldn.parent.left) {
            oldn.parent.left = newn;
        } else {
            oldn.parent.right = newn;
        }
        if (newn != null) {
            newn.parent = oldn.parent;
        }
    }

    public void insert(K key, V value) {
        Node<K, V> insertedNode = new Node<K, V>(key, value, Color.RED, null, null);
        if (this.root == null) {
            this.root = insertedNode;
        } else {
            Node<K, V> n = this.root;
            while (true) {
                int compResult;
                if ((compResult = key.compareTo(n.key)) == 0) {
                    n.value = value;
                    return;
                }
                if (compResult < 0) {
                    if (n.left == null) {
                        n.left = insertedNode;
                        break;
                    }
                    n = n.left;
                    continue;
                }
                if (n.right == null) {
                    n.right = insertedNode;
                    break;
                }
                n = n.right;
            }
            insertedNode.parent = n;
        }
        this.insertCase1(insertedNode);
        this.verifyProperties();
    }

    private void insertCase1(Node<K, V> n) {
        if (n.parent == null) {
            n.color = Color.BLACK;
        } else {
            this.insertCase2(n);
        }
    }

    private void insertCase2(Node<K, V> n) {
        if (RBTree.nodeColor(n.parent) == Color.BLACK) {
            return;
        }
        this.insertCase3(n);
    }

    void insertCase3(Node<K, V> n) {
        if (RBTree.nodeColor(n.uncle()) == Color.RED) {
            n.parent.color = Color.BLACK;
            n.uncle().color = Color.BLACK;
            n.grandparent().color = Color.RED;
            this.insertCase1(n.grandparent());
        } else {
            this.insertCase4(n);
        }
    }

    void insertCase4(Node<K, V> n) {
        if (n == n.parent.right && n.parent == n.grandparent().left) {
            this.rotateLeft(n.parent);
            n = n.left;
        } else if (n == n.parent.left && n.parent == n.grandparent().right) {
            this.rotateRight(n.parent);
            n = n.right;
        }
        this.insertCase5(n);
    }

    void insertCase5(Node<K, V> n) {
        n.parent.color = Color.BLACK;
        n.grandparent().color = Color.RED;
        if (n == n.parent.left && n.parent == n.grandparent().left) {
            this.rotateRight(n.grandparent());
        } else {
            this.rotateLeft(n.grandparent());
        }
    }

    public void delete(K key) {
        Node child;
        Node<K, V> n = this.lookupNode(key);
        if (n == null) {
            return;
        }
        if (n.left != null && n.right != null) {
            Node pred = RBTree.maximumNode(n.left);
            n.key = pred.key;
            n.value = pred.value;
            n = pred;
        }
        Node node = child = n.right == null ? n.left : n.right;
        if (RBTree.nodeColor(n) == Color.BLACK) {
            n.color = RBTree.nodeColor(child);
            this.deleteCase1(n);
        }
        this.replaceNode(n, child);
        if (RBTree.nodeColor(this.root) == Color.RED) {
            this.root.color = Color.BLACK;
        }
        this.verifyProperties();
    }

    private static <K extends Comparable<? super K>, V> Node<K, V> maximumNode(Node<K, V> n) {
        while (n.right != null) {
            n = n.right;
        }
        return n;
    }

    private void deleteCase1(Node<K, V> n) {
        if (n.parent == null) {
            return;
        }
        this.deleteCase2(n);
    }

    private void deleteCase2(Node<K, V> n) {
        if (RBTree.nodeColor(n.sibling()) == Color.RED) {
            n.parent.color = Color.RED;
            n.sibling().color = Color.BLACK;
            if (n == n.parent.left) {
                this.rotateLeft(n.parent);
            } else {
                this.rotateRight(n.parent);
            }
        }
        this.deleteCase3(n);
    }

    private void deleteCase3(Node<K, V> n) {
        if (RBTree.nodeColor(n.parent) == Color.BLACK && RBTree.nodeColor(n.sibling()) == Color.BLACK && RBTree.nodeColor(n.sibling().left) == Color.BLACK && RBTree.nodeColor(n.sibling().right) == Color.BLACK) {
            n.sibling().color = Color.RED;
            this.deleteCase1(n.parent);
        } else {
            this.deleteCase4(n);
        }
    }

    private void deleteCase4(Node<K, V> n) {
        if (RBTree.nodeColor(n.parent) == Color.RED && RBTree.nodeColor(n.sibling()) == Color.BLACK && RBTree.nodeColor(n.sibling().left) == Color.BLACK && RBTree.nodeColor(n.sibling().right) == Color.BLACK) {
            n.sibling().color = Color.RED;
            n.parent.color = Color.BLACK;
        } else {
            this.deleteCase5(n);
        }
    }

    private void deleteCase5(Node<K, V> n) {
        if (n == n.parent.left && RBTree.nodeColor(n.sibling()) == Color.BLACK && RBTree.nodeColor(n.sibling().left) == Color.RED && RBTree.nodeColor(n.sibling().right) == Color.BLACK) {
            n.sibling().color = Color.RED;
            n.sibling().left.color = Color.BLACK;
            this.rotateRight(n.sibling());
        } else if (n == n.parent.right && RBTree.nodeColor(n.sibling()) == Color.BLACK && RBTree.nodeColor(n.sibling().right) == Color.RED && RBTree.nodeColor(n.sibling().left) == Color.BLACK) {
            n.sibling().color = Color.RED;
            n.sibling().right.color = Color.BLACK;
            this.rotateLeft(n.sibling());
        }
        this.deleteCase6(n);
    }

    private void deleteCase6(Node<K, V> n) {
        n.sibling().color = RBTree.nodeColor(n.parent);
        n.parent.color = Color.BLACK;
        if (n == n.parent.left) {
            n.sibling().right.color = Color.BLACK;
            this.rotateLeft(n.parent);
        } else {
            n.sibling().left.color = Color.BLACK;
            this.rotateRight(n.parent);
        }
    }

    public void print() {
        RBTree.printHelper(this.root, 0);
    }

    private static void printHelper(Node<?, ?> n, int indent) {
        if (n == null) {
            System.out.print("<empty tree>");
            return;
        }
        if (n.right != null) {
            RBTree.printHelper(n.right, indent + 4);
        }
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
        if (n.color == Color.BLACK) {
            System.out.println(n.key);
        } else {
            System.out.println("<" + n.key + ">");
        }
        if (n.left != null) {
            RBTree.printHelper(n.left, indent + 4);
        }
    }

    public static class Node<K extends Comparable<? super K>, V>
    implements Entry,
    Comparable<Node<K, V>> {
        public K key;
        public V value;
        public Node<K, V> left;
        public Node<K, V> right;
        public Node<K, V> parent;
        public Color color;

        public Node(K key, V value, Color nodeColor, Node<K, V> left, Node<K, V> right) {
            this.key = key;
            this.value = value;
            this.color = nodeColor;
            this.left = left;
            this.right = right;
            if (left != null) {
                left.parent = this;
            }
            if (right != null) {
                right.parent = this;
            }
            this.parent = null;
        }

        public Node<K, V> grandparent() {
            return this.parent.parent;
        }

        public Node<K, V> sibling() {
            if (this == this.parent.left) {
                return this.parent.right;
            }
            return this.parent.left;
        }

        public Node<K, V> uncle() {
            return this.parent.sibling();
        }

        public String toString() {
            return "Node key=" + this.key + " value=" + this.value;
        }

        public void setNext(Entry next) {
        }

        public Entry getNext() {
            return null;
        }

        @Override
        public int compareTo(Node<K, V> other) {
            return this.key.compareTo(other.key);
        }
    }

    public static enum Color {
        RED,
        BLACK;

    }

    public static class RBTreeFastIterator<K extends Comparable<? super K>, V>
    implements FastIterator {
        private Node<K, V> upperBound;
        private Node<K, V> next;

        public RBTreeFastIterator(Node<K, V> lowerBound, Node<K, V> upperBound) {
            this.next = lowerBound;
            this.upperBound = upperBound;
        }

        @Override
        public Entry next(Entry object) {
            Node<K, V> temp = this.next;
            this.next = this.checkUpperBound(this.recurse(this.next));
            return temp;
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }

        private Node<K, V> recurse(Node<K, V> current) {
            if (current == null) {
                return null;
            }
            if (current.right != null) {
                Node p = current.right;
                while (p.left != null) {
                    p = p.left;
                }
                return p;
            }
            Node p = current.parent;
            Node<K, V> ch = current;
            while (p != null && ch == p.right) {
                ch = p;
                p = p.parent;
            }
            return p;
        }

        public Node<K, V> checkUpperBound(Node<K, V> current) {
            if (this.upperBound == null) {
                return current;
            }
            return current == null || current.compareTo(this.upperBound) > 0 ? null : current;
        }
    }

    public static enum Boundary {
        LOWER,
        UPPER;

    }
}

