/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.debug;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.drools.core.WorkingMemory;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.common.NetworkNode;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.ReteooWorkingMemoryInterface;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Rule;
import org.drools.core.util.debug.AccumulateNodeVisitor;
import org.drools.core.util.debug.AlphaNodeVisitor;
import org.drools.core.util.debug.BetaNodeVisitor;
import org.drools.core.util.debug.DefaultNetworkNodeVisitor;
import org.drools.core.util.debug.EvalConditionNodeVisitor;
import org.drools.core.util.debug.FromNodeVisitor;
import org.drools.core.util.debug.LeftInputAdapterNodeVisitor;
import org.drools.core.util.debug.NetworkNodeVisitor;
import org.drools.core.util.debug.ObjectTypeNodeVisitor;
import org.drools.core.util.debug.PropagationQueueingNodeVisitor;
import org.drools.core.util.debug.QueryTerminalNodeVisitor;
import org.drools.core.util.debug.RightInputAdapterNodeVisitor;
import org.drools.core.util.debug.RuleTerminalNodeVisitor;
import org.drools.core.util.debug.StatefulKnowledgeSessionInfo;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class SessionInspector {
    private ReteooWorkingMemoryInterface session;
    private Map<Short, NetworkNodeVisitor> visitors = new HashMap<Short, NetworkNodeVisitor>();

    public SessionInspector(StatefulKnowledgeSession session) {
        this.visitors.put((short)101, RuleTerminalNodeVisitor.INSTANCE);
        this.visitors.put((short)91, QueryTerminalNodeVisitor.INSTANCE);
        this.visitors.put((short)20, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put((short)10, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put((short)30, ObjectTypeNodeVisitor.INSTANCE);
        this.visitors.put((short)40, AlphaNodeVisitor.INSTANCE);
        this.visitors.put((short)71, RightInputAdapterNodeVisitor.INSTANCE);
        this.visitors.put((short)65, PropagationQueueingNodeVisitor.INSTANCE);
        this.visitors.put((short)181, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)171, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)201, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)191, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)211, AccumulateNodeVisitor.INSTANCE);
        this.visitors.put((short)131, EvalConditionNodeVisitor.INSTANCE);
        this.visitors.put((short)151, FromNodeVisitor.INSTANCE);
        this.visitors.put((short)120, LeftInputAdapterNodeVisitor.INSTANCE);
        this.session = ((StatefulKnowledgeSessionImpl)session).session;
    }

    public SessionInspector(WorkingMemory session) {
        this.visitors.put((short)101, RuleTerminalNodeVisitor.INSTANCE);
        this.visitors.put((short)91, QueryTerminalNodeVisitor.INSTANCE);
        this.visitors.put((short)20, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put((short)10, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put((short)30, ObjectTypeNodeVisitor.INSTANCE);
        this.visitors.put((short)40, AlphaNodeVisitor.INSTANCE);
        this.visitors.put((short)71, RightInputAdapterNodeVisitor.INSTANCE);
        this.visitors.put((short)65, PropagationQueueingNodeVisitor.INSTANCE);
        this.visitors.put((short)181, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)171, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)201, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)191, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)211, AccumulateNodeVisitor.INSTANCE);
        this.visitors.put((short)131, EvalConditionNodeVisitor.INSTANCE);
        this.visitors.put((short)151, FromNodeVisitor.INSTANCE);
        this.visitors.put((short)120, LeftInputAdapterNodeVisitor.INSTANCE);
        this.session = (AbstractWorkingMemory)session;
    }

    public StatefulKnowledgeSessionInfo getSessionInfo() {
        StatefulKnowledgeSessionInfo info = new StatefulKnowledgeSessionInfo();
        ReteooRuleBase rulebase = (ReteooRuleBase)this.session.getRuleBase();
        info.setSession(this.session);
        Stack<NetworkNode> nodeStack = new Stack<NetworkNode>();
        this.gatherNodeInfo(rulebase.getRete(), nodeStack, info);
        return info;
    }

    private void gatherNodeInfo(NetworkNode parent, Stack<NetworkNode> nodeStack, StatefulKnowledgeSessionInfo info) {
        if (!info.visited(parent)) {
            nodeStack.push(parent);
            NetworkNodeVisitor visitor = this.visitors.get(parent.getType());
            if (visitor == null) {
                throw new RuntimeException("No visitor found for node class: " + parent.getClass() + " node: " + parent);
            }
            visitor.visit(parent, nodeStack, info);
            this.visitChildren(parent, nodeStack, info);
            nodeStack.pop();
        } else {
            Set<Rule> rules = info.getNodeInfo(parent).getRules();
            for (NetworkNode snode : nodeStack) {
                for (Rule rule : rules) {
                    info.assign(snode, rule);
                }
            }
        }
    }

    protected void visitChildren(NetworkNode parent, Stack<NetworkNode> nodeStack, StatefulKnowledgeSessionInfo info) {
        if (parent instanceof Rete) {
            Rete rete = (Rete)parent;
            for (EntryPointNode sink : rete.getEntryPointNodes().values()) {
                this.gatherNodeInfo(sink, nodeStack, info);
            }
        } else if (parent instanceof EntryPointNode) {
            EntryPointNode epn = (EntryPointNode)parent;
            for (ObjectTypeNode sink : epn.getObjectTypeNodes().values()) {
                this.gatherNodeInfo(sink, nodeStack, info);
            }
        } else if (parent instanceof ObjectSource) {
            ObjectSource source = (ObjectSource)parent;
            for (ObjectSink sink : source.getSinkPropagator().getSinks()) {
                this.gatherNodeInfo(sink, nodeStack, info);
            }
        } else if (parent instanceof LeftTupleSource) {
            LeftTupleSource source = (LeftTupleSource)parent;
            for (LeftTupleSink sink : source.getSinkPropagator().getSinks()) {
                this.gatherNodeInfo(sink, nodeStack, info);
            }
        } else if (!(parent instanceof RuleTerminalNode) && !(parent instanceof QueryTerminalNode)) {
            throw new RuntimeException("ERROR: No idea how to visit childrens of this node: " + parent);
        }
    }
}

