/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.RBTree;
import org.drools.core.util.index.IndexUtil;
import org.drools.core.util.index.LeftTupleList;

public class LeftTupleIndexRangeRBTree
implements LeftTupleMemory,
Externalizable {
    private RBTree<Comparable<Comparable>, RBTree<Comparable<Comparable>, LeftTupleList>> tree;
    private AbstractHashTable.FieldIndex ascendingIndex;
    private IndexUtil.ConstraintType ascendingConstraintType;
    private AbstractHashTable.FieldIndex descendingIndex;
    private IndexUtil.ConstraintType descendingConstraintType;
    private transient LeftTupleFastIterator leftTupleFastIterator;
    private int size;

    public LeftTupleIndexRangeRBTree() {
    }

    public LeftTupleIndexRangeRBTree(IndexUtil.ConstraintType ascendingConstraintType, AbstractHashTable.FieldIndex ascendingIndex, IndexUtil.ConstraintType descendingConstraintType, AbstractHashTable.FieldIndex descendingIndex) {
        this.ascendingIndex = ascendingIndex;
        this.ascendingConstraintType = ascendingConstraintType;
        this.descendingIndex = descendingIndex;
        this.descendingConstraintType = descendingConstraintType;
        this.tree = new RBTree();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tree);
        out.writeObject(this.ascendingIndex);
        out.writeObject((Object)this.ascendingConstraintType);
        out.writeObject(this.descendingIndex);
        out.writeObject((Object)this.descendingConstraintType);
        out.writeInt(this.size);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tree = (RBTree)in.readObject();
        this.ascendingIndex = (AbstractHashTable.FieldIndex)in.readObject();
        this.ascendingConstraintType = (IndexUtil.ConstraintType)((Object)in.readObject());
        this.descendingIndex = (AbstractHashTable.FieldIndex)in.readObject();
        this.descendingConstraintType = (IndexUtil.ConstraintType)((Object)in.readObject());
        this.size = in.readInt();
    }

    @Override
    public void add(LeftTuple leftTuple) {
        LeftTupleList list;
        Comparable lowerBound = this.getLeftAscendingIndexedValue(leftTuple);
        Comparable upperBound = this.getLeftDescendingIndexedValue(leftTuple);
        RBTree<Comparable<Comparable<Object>>, LeftTupleList> nestedTree = this.tree.lookup(lowerBound);
        if (nestedTree == null) {
            nestedTree = new RBTree();
            this.tree.insert(lowerBound, nestedTree);
        }
        if ((list = nestedTree.lookup(upperBound)) == null) {
            list = new LeftTupleList();
            nestedTree.insert(upperBound, list);
        }
        list.add(leftTuple);
        ++this.size;
    }

    @Override
    public void remove(LeftTuple tuple) {
        tuple.getMemory().remove(tuple);
        --this.size;
    }

    @Override
    public void removeAdd(LeftTuple tuple) {
        this.remove(tuple);
        this.add(tuple);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Entry[] toArray() {
        FastIterator it = this.tree.fastIterator();
        if (it == null) {
            return new Entry[0];
        }
        ArrayList toBeRemoved = new ArrayList();
        ArrayList nestedToBeRemoved = new ArrayList();
        ArrayList<LeftTuple> result = new ArrayList<LeftTuple>();
        RBTree.Node node = null;
        RBTree.Node nestedNode = null;
        while ((node = (RBTree.Node)it.next(node)) != null) {
            nestedToBeRemoved.clear();
            RBTree nestedTree = (RBTree)node.value;
            FastIterator nestedIt = nestedTree.fastIterator();
            while ((nestedNode = (RBTree.Node)nestedIt.next(nestedNode)) != null) {
                LeftTupleList list = (LeftTupleList)nestedNode.value;
                int listSize = list.size();
                if (listSize == 0) {
                    nestedToBeRemoved.add(nestedNode.key);
                    continue;
                }
                for (LeftTuple entry = list.getFirst(); entry != null; entry = (LeftTuple)entry.getNext()) {
                    result.add(entry);
                }
            }
            for (Comparable key : nestedToBeRemoved) {
                nestedTree.delete(key);
            }
            if (!nestedTree.isEmpty()) continue;
            toBeRemoved.add(node.key);
        }
        for (Comparable key : toBeRemoved) {
            this.tree.delete(key);
        }
        return result.toArray(new LeftTuple[result.size()]);
    }

    @Override
    public LeftTuple getFirst(RightTuple rightTuple) {
        Comparable key = this.getRightIndexedValue(rightTuple);
        return this.getFirst(key);
    }

    @Override
    public Iterator iterator() {
        LeftTupleList list = (LeftTupleList)((RBTree)this.tree.first().value).first().value;
        LeftTuple firstTuple = list != null ? list.first : null;
        return new FastIterator.IteratorAdapter(this.fastIterator(), firstTuple);
    }

    @Override
    public boolean contains(LeftTuple leftTuple) {
        Comparable lowerBound = this.getLeftAscendingIndexedValue(leftTuple);
        RBTree<Comparable<Comparable>, LeftTupleList> nestedTree = this.tree.lookup(lowerBound);
        return nestedTree == null ? false : nestedTree.lookup(this.getLeftDescendingIndexedValue(leftTuple)) != null;
    }

    @Override
    public FastIterator fastIterator() {
        if (this.leftTupleFastIterator == null) {
            this.leftTupleFastIterator = new LeftTupleFastIterator();
        }
        return this.leftTupleFastIterator;
    }

    @Override
    public FastIterator fullFastIterator() {
        if (this.leftTupleFastIterator == null) {
            this.leftTupleFastIterator = new LeftTupleFastIterator();
        }
        return this.leftTupleFastIterator;
    }

    @Override
    public FastIterator fullFastIterator(LeftTuple leftTuple) {
        FastIterator fastIterator = this.fullFastIterator();
        fastIterator.next(this.getNext(leftTuple));
        return fastIterator;
    }

    private Comparable getLeftAscendingIndexedValue(LeftTuple leftTuple) {
        return (Comparable)this.ascendingIndex.getDeclaration().getExtractor().getValue(leftTuple.get(this.ascendingIndex.getDeclaration()).getObject());
    }

    private Comparable getLeftDescendingIndexedValue(LeftTuple leftTuple) {
        return (Comparable)this.descendingIndex.getDeclaration().getExtractor().getValue(leftTuple.get(this.descendingIndex.getDeclaration()).getObject());
    }

    private Comparable getRightIndexedValue(RightTuple rightTuple) {
        return (Comparable)this.ascendingIndex.getExtractor().getValue(rightTuple.getFactHandle().getObject());
    }

    private LeftTuple getFirst(Comparable key) {
        RBTree.Node firstNode;
        RBTree.Node<Comparable<Comparable>, RBTree<Comparable<Comparable>, LeftTupleList>> nestedNode = null;
        boolean findNextNestedNode = true;
        while (true) {
            if (findNextNestedNode) {
                switch (this.ascendingConstraintType) {
                    case GREATER_THAN: {
                        nestedNode = this.tree.findNearestNode(key, false, RBTree.Boundary.UPPER);
                        break;
                    }
                    case GREATER_OR_EQUAL: {
                        nestedNode = this.tree.findNearestNode(key, true, RBTree.Boundary.UPPER);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Cannot call remove constraint of type: " + (Object)((Object)this.ascendingConstraintType));
                    }
                }
            }
            findNextNestedNode = true;
            if (nestedNode == null) {
                return null;
            }
            if (((RBTree)nestedNode.value).isEmpty()) {
                this.tree.delete((Comparable<Comparable>)nestedNode.key);
                continue;
            }
            RBTree nestedTree = (RBTree)nestedNode.value;
            switch (this.descendingConstraintType) {
                case LESS_THAN: {
                    firstNode = nestedTree.findNearestNode(key, false, RBTree.Boundary.LOWER);
                    break;
                }
                case LESS_OR_EQUAL: {
                    firstNode = nestedTree.findNearestNode(key, true, RBTree.Boundary.LOWER);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot call remove constraint of type: " + (Object)((Object)this.descendingConstraintType));
                }
            }
            if (firstNode != null && ((LeftTupleList)firstNode.value).size() == 0) {
                nestedTree.delete(firstNode.key);
                firstNode = null;
            }
            if (firstNode != null) break;
            nestedNode = this.tree.findNearestNode((Comparable<Comparable>)nestedNode.key, false, RBTree.Boundary.UPPER);
            if (nestedNode == null) {
                return null;
            }
            findNextNestedNode = false;
        }
        return ((LeftTupleList)firstNode.value).getFirst();
    }

    private Entry getNext(LeftTuple leftTuple) {
        LeftTuple next = (LeftTuple)leftTuple.getNext();
        if (next != null) {
            return next;
        }
        Comparable ascendingKey = this.getLeftAscendingIndexedValue(leftTuple);
        Comparable descendingKey = this.getLeftDescendingIndexedValue(leftTuple);
        RBTree<Comparable<Comparable>, LeftTupleList> nestedTree = this.tree.lookup(ascendingKey);
        while (nestedTree != null) {
            RBTree.Node<Comparable<Comparable>, Object> nextNode;
            while ((nextNode = nestedTree.findNearestNode(descendingKey, false, RBTree.Boundary.LOWER)) != null) {
                if (((LeftTupleList)nextNode.value).size() == 0) {
                    nestedTree.delete((Comparable<Comparable>)nextNode.key);
                    continue;
                }
                return ((LeftTupleList)nextNode.value).getFirst();
            }
            nextNode = this.tree.findNearestNode(ascendingKey, false, RBTree.Boundary.UPPER);
            nestedTree = nextNode == null ? null : (RBTree)nextNode.value;
        }
        return null;
    }

    public class LeftTupleFastIterator
    implements FastIterator {
        @Override
        public Entry next(Entry object) {
            return object == null ? null : LeftTupleIndexRangeRBTree.this.getNext((LeftTuple)object);
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }
    }
}

