/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.notes.FanoutBucket;
import org.eclipse.jgit.notes.InMemoryNoteBucket;
import org.eclipse.jgit.notes.NonNoteEntry;
import org.eclipse.jgit.notes.Note;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LeafBucket
extends InMemoryNoteBucket {
    static final int MAX_SIZE = 256;
    private Note[] notes = new Note[4];
    private int cnt;

    LeafBucket(int prefixLen) {
        super(prefixLen);
    }

    private int search(AnyObjectId objId) {
        int low = 0;
        int high = this.cnt;
        while (low < high) {
            int mid = low + high >>> 1;
            int cmp = objId.compareTo(this.notes[mid]);
            if (cmp < 0) {
                high = mid;
                continue;
            }
            if (cmp == 0) {
                return mid;
            }
            low = mid + 1;
        }
        return -(low + 1);
    }

    @Override
    Note getNote(AnyObjectId objId, ObjectReader or) {
        int idx = this.search(objId);
        return 0 <= idx ? this.notes[idx] : null;
    }

    Note get(int index) {
        return this.notes[index];
    }

    int size() {
        return this.cnt;
    }

    @Override
    Iterator<Note> iterator(AnyObjectId objId, ObjectReader reader) {
        return new Iterator<Note>(){
            private int idx;

            @Override
            public boolean hasNext() {
                return this.idx < LeafBucket.this.cnt;
            }

            @Override
            public Note next() {
                if (this.hasNext()) {
                    return LeafBucket.this.notes[this.idx++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    int estimateSize(AnyObjectId noteOn, ObjectReader or) throws IOException {
        return this.cnt;
    }

    @Override
    InMemoryNoteBucket set(AnyObjectId noteOn, AnyObjectId noteData, ObjectReader or) throws IOException {
        int p = this.search(noteOn);
        if (0 <= p) {
            if (noteData != null) {
                this.notes[p].setData(noteData.copy());
                return this;
            }
            System.arraycopy(this.notes, p + 1, this.notes, p, this.cnt - p - 1);
            --this.cnt;
            return 0 < this.cnt ? this : null;
        }
        if (noteData != null) {
            if (this.shouldSplit()) {
                return this.split().set(noteOn, noteData, or);
            }
            this.growIfFull();
            p = -(p + 1);
            if (p < this.cnt) {
                System.arraycopy(this.notes, p, this.notes, p + 1, this.cnt - p);
            }
            this.notes[p] = new Note(noteOn, noteData.copy());
            ++this.cnt;
            return this;
        }
        return this;
    }

    @Override
    ObjectId writeTree(ObjectInserter inserter) throws IOException {
        return inserter.insert(this.build());
    }

    @Override
    ObjectId getTreeId() {
        return new ObjectInserter.Formatter().idFor(this.build());
    }

    private TreeFormatter build() {
        byte[] nameBuf = new byte[40];
        int nameLen = 40 - this.prefixLen;
        TreeFormatter fmt = new TreeFormatter(this.treeSize(nameLen));
        NonNoteEntry e = this.nonNotes;
        for (int i = 0; i < this.cnt; ++i) {
            Note n = this.notes[i];
            n.copyTo(nameBuf, 0);
            while (e != null && e.pathCompare(nameBuf, this.prefixLen, nameLen, FileMode.REGULAR_FILE) < 0) {
                e.format(fmt);
                e = e.next;
            }
            fmt.append(nameBuf, this.prefixLen, nameLen, FileMode.REGULAR_FILE, n.getData());
        }
        while (e != null) {
            e.format(fmt);
            e = e.next;
        }
        return fmt;
    }

    private int treeSize(int nameLen) {
        int sz = this.cnt * TreeFormatter.entrySize(FileMode.REGULAR_FILE, nameLen);
        NonNoteEntry e = this.nonNotes;
        while (e != null) {
            sz += e.treeEntrySize();
            e = e.next;
        }
        return sz;
    }

    void parseOneEntry(AnyObjectId noteOn, AnyObjectId noteData) {
        this.growIfFull();
        this.notes[this.cnt++] = new Note(noteOn, noteData.copy());
    }

    @Override
    InMemoryNoteBucket append(Note note) {
        if (this.shouldSplit()) {
            return this.split().append(note);
        }
        this.growIfFull();
        this.notes[this.cnt++] = note;
        return this;
    }

    private void growIfFull() {
        if (this.notes.length == this.cnt) {
            Note[] n = new Note[this.notes.length * 2];
            System.arraycopy(this.notes, 0, n, 0, this.cnt);
            this.notes = n;
        }
    }

    private boolean shouldSplit() {
        return 256 <= this.cnt && this.prefixLen + 2 < 40;
    }

    FanoutBucket split() {
        FanoutBucket n = new FanoutBucket(this.prefixLen);
        for (int i = 0; i < this.cnt; ++i) {
            n.append(this.notes[i]);
        }
        n.nonNotes = this.nonNotes;
        return n;
    }
}

