/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Map;
import org.drools.core.command.CommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.event.ProcessEventSupport;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.WorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.command.Command;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.Context;
import org.kie.internal.runtime.KnowledgeRuntime;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicUtils {
    private static final Logger logger = LoggerFactory.getLogger(DynamicUtils.class);

    public static void addDynamicWorkItem(DynamicNodeInstance dynamicContext, KieRuntime ksession, String workItemName, Map<String, Object> parameters) {
        WorkflowProcessInstance processInstance = dynamicContext.getProcessInstance();
        DynamicUtils.internalAddDynamicWorkItem(processInstance, dynamicContext, ksession, workItemName, parameters);
    }

    public static void addDynamicWorkItem(ProcessInstance dynamicProcessInstance, KieRuntime ksession, String workItemName, Map<String, Object> parameters) {
        DynamicUtils.internalAddDynamicWorkItem((WorkflowProcessInstance)dynamicProcessInstance, null, ksession, workItemName, parameters);
    }

    private static void internalAddDynamicWorkItem(final WorkflowProcessInstance processInstance, final DynamicNodeInstance dynamicContext, KieRuntime ksession, String workItemName, Map<String, Object> parameters) {
        final WorkItemImpl workItem = new WorkItemImpl();
        workItem.setState(1);
        workItem.setProcessInstanceId(processInstance.getId());
        workItem.setName(workItemName);
        workItem.setParameters(parameters);
        final WorkItemNodeInstance workItemNodeInstance = new WorkItemNodeInstance();
        workItemNodeInstance.setNodeInstanceContainer((NodeInstanceContainer)(dynamicContext == null ? processInstance : dynamicContext));
        workItemNodeInstance.setProcessInstance(processInstance);
        workItemNodeInstance.internalSetWorkItem((WorkItem)workItem);
        workItemNodeInstance.addEventListeners();
        if (ksession instanceof StatefulKnowledgeSessionImpl) {
            DynamicUtils.executeWorkItem((StatefulKnowledgeSessionImpl)ksession, workItem, workItemNodeInstance);
        } else if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            CommandService commandService = ((CommandBasedStatefulKnowledgeSession)ksession).getCommandService();
            commandService.execute((Command)new GenericCommand<Void>(){
                private static final long serialVersionUID = 5L;

                public Void execute(Context context) {
                    StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((KnowledgeCommandContext)context).getKieSession();
                    WorkflowProcessInstance realProcessInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstance.getId());
                    workItemNodeInstance.setProcessInstance(realProcessInstance);
                    if (dynamicContext == null) {
                        workItemNodeInstance.setNodeInstanceContainer((NodeInstanceContainer)realProcessInstance);
                    } else {
                        DynamicNodeInstance realDynamicContext = DynamicUtils.findDynamicContext(realProcessInstance, dynamicContext.getUniqueId());
                        workItemNodeInstance.setNodeInstanceContainer(realDynamicContext);
                    }
                    DynamicUtils.executeWorkItem((StatefulKnowledgeSessionImpl)ksession, workItem, workItemNodeInstance);
                    return null;
                }
            });
        } else {
            throw new IllegalArgumentException("Unsupported ksession: " + ksession == null ? "null" : ksession.getClass().getName());
        }
    }

    private static void executeWorkItem(StatefulKnowledgeSessionImpl ksession, WorkItemImpl workItem, WorkItemNodeInstance workItemNodeInstance) {
        ProcessEventSupport eventSupport = ((InternalProcessRuntime)ksession.getProcessRuntime()).getProcessEventSupport();
        eventSupport.fireBeforeNodeTriggered((org.kie.api.runtime.process.NodeInstance)workItemNodeInstance, (KnowledgeRuntime)ksession);
        ((WorkItemManager)ksession.getWorkItemManager()).internalExecuteWorkItem((WorkItem)workItem);
        workItemNodeInstance.internalSetWorkItemId(workItem.getId());
        eventSupport.fireAfterNodeTriggered((org.kie.api.runtime.process.NodeInstance)workItemNodeInstance, (KnowledgeRuntime)ksession);
    }

    private static DynamicNodeInstance findDynamicContext(WorkflowProcessInstance processInstance, String uniqueId) {
        for (NodeInstance nodeInstance : ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances(true)) {
            if (!uniqueId.equals(((NodeInstanceImpl)nodeInstance).getUniqueId())) continue;
            return (DynamicNodeInstance)nodeInstance;
        }
        throw new IllegalArgumentException("Could not find node instance " + uniqueId);
    }

    public static void addDynamicSubProcess(DynamicNodeInstance dynamicContext, KieRuntime ksession, String processId, Map<String, Object> parameters) {
        WorkflowProcessInstance processInstance = dynamicContext.getProcessInstance();
        DynamicUtils.internalAddDynamicSubProcess(processInstance, dynamicContext, ksession, processId, parameters);
    }

    public static void addDynamicSubProcess(ProcessInstance processInstance, KieRuntime ksession, String processId, Map<String, Object> parameters) {
        DynamicUtils.internalAddDynamicSubProcess((WorkflowProcessInstance)processInstance, null, ksession, processId, parameters);
    }

    public static void internalAddDynamicSubProcess(final WorkflowProcessInstance processInstance, final DynamicNodeInstance dynamicContext, KieRuntime ksession, final String processId, final Map<String, Object> parameters) {
        final SubProcessNodeInstance subProcessNodeInstance = new SubProcessNodeInstance();
        subProcessNodeInstance.setNodeInstanceContainer((NodeInstanceContainer)(dynamicContext == null ? processInstance : dynamicContext));
        subProcessNodeInstance.setProcessInstance(processInstance);
        if (ksession instanceof StatefulKnowledgeSessionImpl) {
            DynamicUtils.executeSubProcess((StatefulKnowledgeSessionImpl)ksession, processId, parameters, processInstance, subProcessNodeInstance);
        } else if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            CommandService commandService = ((CommandBasedStatefulKnowledgeSession)ksession).getCommandService();
            commandService.execute((Command)new GenericCommand<Void>(){
                private static final long serialVersionUID = 5L;

                public Void execute(Context context) {
                    StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((KnowledgeCommandContext)context).getKieSession();
                    WorkflowProcessInstance realProcessInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstance.getId());
                    subProcessNodeInstance.setProcessInstance(realProcessInstance);
                    if (dynamicContext == null) {
                        subProcessNodeInstance.setNodeInstanceContainer((NodeInstanceContainer)realProcessInstance);
                    } else {
                        DynamicNodeInstance realDynamicContext = DynamicUtils.findDynamicContext(realProcessInstance, dynamicContext.getUniqueId());
                        subProcessNodeInstance.setNodeInstanceContainer(realDynamicContext);
                    }
                    DynamicUtils.executeSubProcess((StatefulKnowledgeSessionImpl)ksession, processId, parameters, processInstance, subProcessNodeInstance);
                    return null;
                }
            });
        } else {
            throw new IllegalArgumentException("Unsupported ksession: " + ksession == null ? "null" : ksession.getClass().getName());
        }
    }

    private static void executeSubProcess(StatefulKnowledgeSessionImpl ksession, String processId, Map<String, Object> parameters, org.jbpm.process.instance.ProcessInstance processInstance, SubProcessNodeInstance subProcessNodeInstance) {
        Process process = ksession.getKieBase().getProcess(processId);
        if (process == null) {
            logger.error("Could not find process {}", (Object)processId);
            logger.error("Aborting process");
            processInstance.setState(3);
        } else {
            ProcessEventSupport eventSupport = ((InternalProcessRuntime)ksession.getProcessRuntime()).getProcessEventSupport();
            eventSupport.fireBeforeNodeTriggered((org.kie.api.runtime.process.NodeInstance)subProcessNodeInstance, (KnowledgeRuntime)ksession);
            org.jbpm.process.instance.ProcessInstance subProcessInstance = (org.jbpm.process.instance.ProcessInstance)ksession.startProcess(processId, parameters);
            eventSupport.fireAfterNodeTriggered((org.kie.api.runtime.process.NodeInstance)subProcessNodeInstance, (KnowledgeRuntime)ksession);
            if (subProcessInstance.getState() == 2) {
                subProcessNodeInstance.triggerCompleted();
            } else {
                subProcessNodeInstance.internalSetProcessInstanceId(subProcessInstance.getId());
                subProcessNodeInstance.addEventListeners();
            }
        }
    }
}

