/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.filters.StringInputStream;
import org.drools.compiler.kproject.xml.PomModel;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.ExtendedM2RepoService;
import org.guvnor.m2repo.backend.server.FormData;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;

public class FileServlet
extends HttpServlet {
    private static final long serialVersionUID = 510L;
    @Inject
    private ExtendedM2RepoService m2RepoService;
    @Inject
    private GuvnorM2Repository repository;
    private static final String NO_VALID_POM = "NO VALID POM";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        FormData uploadItem = FileServlet.getFormData(request);
        if (uploadItem.getFile() != null) {
            response.getWriter().write(this.processUpload(uploadItem));
            return;
        }
        response.getWriter().write("NO-SCRIPT-DATA");
    }

    private String processUpload(FormData uploadItem) throws IOException {
        if ("".equals(uploadItem.getFile().getName())) {
            throw new IOException("No file selected.");
        }
        String processResult = this.uploadFile(uploadItem);
        uploadItem.getFile().getInputStream().close();
        return processResult;
    }

    public static FormData getFormData(HttpServletRequest request) throws IOException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("UTF-8");
        FormData data = new FormData();
        GAV emptyGAV = new GAV();
        try {
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                if (!item.isFormField()) {
                    data.setFile(item);
                }
                if (item.isFormField() && item.getFieldName().equals("groupId")) {
                    emptyGAV.setGroupId(item.getString());
                    continue;
                }
                if (item.isFormField() && item.getFieldName().equals("artifactId")) {
                    emptyGAV.setArtifactId(item.getString());
                    continue;
                }
                if (!item.isFormField() || !item.getFieldName().equals("versionId")) continue;
                emptyGAV.setVersion(item.getString());
            }
            if (emptyGAV.getArtifactId() == null || "".equals(emptyGAV.getArtifactId()) || emptyGAV.getArtifactId() == null || "".equals(emptyGAV.getArtifactId()) || emptyGAV.getVersion() == null || "".equals(emptyGAV.getVersion())) {
                data.setGav(null);
            } else {
                data.setGav(emptyGAV);
            }
            return data;
        }
        catch (FileUploadException e) {
            return null;
        }
    }

    public String uploadFile(FormData uploadItem) throws IOException {
        InputStream fileData = uploadItem.getFile().getInputStream();
        GAV gav = uploadItem.getGav();
        try {
            if (gav == null) {
                if (!fileData.markSupported()) {
                    fileData = new BufferedInputStream(fileData);
                }
                fileData.mark(fileData.available());
                String pomContent = GuvnorM2Repository.loadPOMFromJar(fileData);
                PomModel pomModel = null;
                if (pomContent != null) {
                    pomModel = PomModel.Parser.parse((String)"pom.xml", (InputStream)new StringInputStream(pomContent));
                }
                if (pomModel != null) {
                    String groupId = pomModel.getReleaseId().getGroupId();
                    String artifactId = pomModel.getReleaseId().getArtifactId();
                    String version = pomModel.getReleaseId().getVersion();
                    if (this.isNullOrEmpty(groupId) || this.isNullOrEmpty(artifactId) || this.isNullOrEmpty(version)) {
                        return NO_VALID_POM;
                    }
                    gav = new GAV(groupId, artifactId, version);
                } else {
                    return NO_VALID_POM;
                }
            }
            fileData.reset();
            this.m2RepoService.deployJar(fileData, gav);
            uploadItem.getFile().getInputStream().close();
            return "OK";
        }
        catch (IOException ioe) {
            throw ExceptionUtilities.handleException((Exception)ioe);
        }
    }

    private boolean isNullOrEmpty(String groupId) {
        return groupId == null || groupId.isEmpty();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getParameter("attachmentPath");
        if (path != null) {
            this.processAttachmentDownload(path, res);
        } else {
            res.sendError(400);
        }
    }

    protected void processAttachmentDownload(String path, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)this.m2RepoService.loadJar(path), (OutputStream)output);
        String fileName = this.m2RepoService.getJarName(path);
        response.setContentType("application/x-download");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ";");
        response.setContentLength(output.size());
        response.getOutputStream().write(output.toByteArray());
        response.getOutputStream().flush();
    }
}

