/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ChangeType;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@ApplicationScoped
public class DataModelResourceChangeObserver {
    private static final Logger logger = LoggerFactory.getLogger(DataModelResourceChangeObserver.class);
    @Inject
    private ProjectService projectService;
    @Inject
    private Event<InvalidateDMOProjectCacheEvent> invalidateDMOProjectCacheEvent;

    public void processResourceAdd(@Observes ResourceAddedEvent resourceAddedEvent) {
        this.processResourceChange(resourceAddedEvent.getSessionInfo(), resourceAddedEvent.getPath(), ChangeType.ADD);
    }

    public void processResourceDelete(@Observes ResourceDeletedEvent resourceDeletedEvent) {
        this.processResourceChange(resourceDeletedEvent.getSessionInfo(), resourceDeletedEvent.getPath(), ChangeType.DELETE);
    }

    public void processResourceUpdate(@Observes ResourceUpdatedEvent resourceUpdatedEvent) {
        this.processResourceChange(resourceUpdatedEvent.getSessionInfo(), resourceUpdatedEvent.getPath(), ChangeType.UPDATE);
    }

    public void processBatchChanges(@Observes ResourceBatchChangesEvent resourceBatchChangesEvent) {
        Set batchChanges = resourceBatchChangesEvent.getBatch();
        HashMap<String, Boolean> notifiedProjects = new HashMap<String, Boolean>();
        if (batchChanges == null) {
            logger.warn("No batchChanges was present for the given resourceBatchChangesEvent: " + resourceBatchChangesEvent);
        }
        for (ResourceChange change : batchChanges) {
            this.processResourceChange(change.getSessionInfo(), change.getPath(), change.getType(), notifiedProjects);
        }
    }

    private void processResourceChange(SessionInfo sessionInfo, Path path, ChangeType changeType) {
        this.processResourceChange(sessionInfo, path, changeType, new HashMap<String, Boolean>());
    }

    private void processResourceChange(SessionInfo sessionInfo, Path path, ChangeType changeType, Map<String, Boolean> notifiedProjects) {
        Project project = this.projectService.resolveProject(path);
        if (logger.isDebugEnabled()) {
            logger.debug("Processing resource change for sessionInfo: " + sessionInfo + ", project: " + project + ", path: " + path + ", changeType: " + changeType);
        }
        if (project != null && !notifiedProjects.containsKey(project.getRootPath().toURI()) && this.isObservableResource(path)) {
            this.invalidateDMOProjectCacheEvent.fire((Object)new InvalidateDMOProjectCacheEvent(sessionInfo, project, path));
            notifiedProjects.put(project.getRootPath().toURI(), Boolean.TRUE);
        }
    }

    private boolean isObservableResource(Path path) {
        return path != null && (path.getFileName().endsWith(".java") || path.getFileName().endsWith(".class") || path.getFileName().equals("pom.xml"));
    }
}

