/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.rpc;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.guvnor.client.util.Preconditions;

public class MavenArtifact
implements Serializable,
IsSerializable {
    private static final String MAVEN_TEST_SCOPE = "test";
    private static final String MAVEN_PROVIDED_SCOPE = "provided";
    private String group;
    private String artifact;
    private String classifier;
    private String version;
    private String type;
    private String scope;
    private Collection<MavenArtifact> child;
    private boolean necessaryOnRuntime;

    public MavenArtifact() {
        this.child = new ArrayList<MavenArtifact>();
    }

    public MavenArtifact(String value) throws IllegalArgumentException {
        Preconditions.checkNotEmpty("value", value);
        String[] values = value.split(":");
        if (values.length < 5 || values.length > 6) {
            throw new IllegalArgumentException("Invalid string format");
        }
        if (values.length == 5) {
            this.group = values[0];
            this.artifact = values[1];
            this.type = values[2];
            this.classifier = null;
            this.version = values[3];
            this.scope = values[4];
        } else {
            this.group = values[0];
            this.artifact = values[1];
            this.type = values[2];
            this.classifier = values[3];
            this.version = values[4];
            this.scope = values[5];
        }
        this.necessaryOnRuntime = this.checkNecessaryOnRuntime();
        this.child = new ArrayList<MavenArtifact>();
    }

    public MavenArtifact(MavenArtifact source) {
        Preconditions.checkNotNull("source", source);
        this.group = source.group;
        this.artifact = source.artifact;
        this.classifier = source.classifier;
        this.version = source.version;
        this.type = source.type;
        this.scope = source.scope;
        this.necessaryOnRuntime = source.necessaryOnRuntime;
        this.child = source.child == null || source.child.size() == 0 ? new ArrayList<MavenArtifact>() : new ArrayList<MavenArtifact>(source.child);
    }

    private boolean checkNecessaryOnRuntime() {
        return !this.scope.equalsIgnoreCase(MAVEN_TEST_SCOPE) && !this.scope.equalsIgnoreCase(MAVEN_PROVIDED_SCOPE);
    }

    public String toValue() {
        if (this.classifier == null) {
            return this.group + ":" + this.artifact + ":" + this.type + ":" + this.version + ":" + this.scope;
        }
        return this.group + ":" + this.artifact + ":" + this.type + ":" + this.classifier + ":" + this.version + ":" + this.scope;
    }

    public String toLabel() {
        return this.group + ":" + this.toFileName();
    }

    public String toURL(String repository) {
        Preconditions.checkNotNull("repository", repository);
        StringBuilder sb = new StringBuilder(repository);
        if (!repository.endsWith("/")) {
            sb.append("/");
        }
        return sb.append(this.group.replace(".", "/")).append('/').append(this.artifact).append('/').append(this.version).append('/').append(this.toFileName()).toString();
    }

    public String toFileName() {
        if (this.classifier != null) {
            return this.artifact + "-" + this.version + "-" + this.classifier + "." + this.getFileExtension();
        }
        return this.artifact + "-" + this.version + "." + this.getFileExtension();
    }

    public boolean isNecessaryOnRuntime() {
        return this.necessaryOnRuntime;
    }

    public synchronized void addChild(MavenArtifact newArtifact) {
        Preconditions.checkNotNull("newArtifact", newArtifact);
        this.child.add(newArtifact);
    }

    public Collection<MavenArtifact> getChild() {
        return this.child;
    }

    public boolean hasChild() {
        return this.child.size() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifact artifact1 = (MavenArtifact)o;
        if (!this.artifact.equals(artifact1.artifact)) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(artifact1.classifier) : artifact1.classifier != null) {
            return false;
        }
        if (!this.group.equals(artifact1.group)) {
            return false;
        }
        if (!this.scope.equals(artifact1.scope)) {
            return false;
        }
        if (!this.type.equals(artifact1.type)) {
            return false;
        }
        return this.version.equals(artifact1.version);
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = 31 * result + this.artifact.hashCode();
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.scope.hashCode();
        return result;
    }

    private String getFileExtension() {
        if (this.type.equalsIgnoreCase("ear")) {
            return "ear";
        }
        if (this.type.equalsIgnoreCase("pom")) {
            return "pom";
        }
        if (this.type.equalsIgnoreCase("war")) {
            return "war";
        }
        return "jar";
    }
}

