/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.widgets.categorynav.CategoryExplorerWidget;
import org.drools.guvnor.client.widgets.categorynav.CategorySelectHandler;

public class AssetCategoryEditor
extends DirtyableComposite {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private MetaData data;
    private DirtyableFlexTable layout = new DirtyableFlexTable();
    private FlexTable list;
    private boolean readOnly;

    public AssetCategoryEditor(MetaData d, boolean readOnly) {
        this.data = d;
        this.list = new FlexTable();
        this.readOnly = readOnly;
        this.loadData(this.list);
        this.list.setStyleName("rule-List");
        this.layout.setWidget(0, 0, (Widget)this.list);
        if (!readOnly) {
            this.doActions();
        }
        this.initWidget((Widget)this.layout);
    }

    private void doActions() {
        VerticalPanel actions = new VerticalPanel();
        Image add = GuvnorImages.INSTANCE.NewItem();
        add.setAltText(ConstantsCore.INSTANCE.AssetCategoryEditorAddNewCategory());
        add.setTitle(this.constants.AddANewCategory());
        add.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AssetCategoryEditor.this.doOKClick();
            }
        });
        actions.add((Widget)add);
        this.layout.setWidget(0, 1, (Widget)actions);
    }

    protected void removeCategory(int idx) {
        this.data.removeCategory(idx);
        this.makeDirty();
        this.resetBox();
    }

    private void resetBox() {
        this.list = new FlexTable();
        this.list.setStyleName("rule-List");
        this.layout.setWidget(0, 0, (Widget)this.list);
        this.loadData(this.list);
        this.makeDirty();
    }

    private void loadData(FlexTable list) {
        for (int i = 0; i < this.data.getCategories().length; ++i) {
            final int idx = i;
            list.setWidget(i, 0, (Widget)new SmallLabel(this.data.getCategories()[i]));
            if (this.readOnly) continue;
            Image del = GuvnorImages.INSTANCE.Trash();
            del.setTitle(this.constants.RemoveThisCategory());
            del.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    AssetCategoryEditor.this.removeCategory(idx);
                }
            });
            list.setWidget(i, 1, (Widget)del);
        }
    }

    private void doOKClick() {
        CategorySelector sel = new CategorySelector();
        sel.show();
    }

    public void addToCategory(String selectedPath) {
        this.data.addCategory(selectedPath);
        this.resetBox();
    }

    class CategorySelector
    extends FormStylePopup {
        public Button ok;
        private CategoryExplorerWidget selector;
        public String selectedPath;

        public CategorySelector() {
            this.ok = new Button(AssetCategoryEditor.this.constants.OK());
            this.setTitle(AssetCategoryEditor.this.constants.SelectCategoryToAdd());
            VerticalPanel vert = new VerticalPanel();
            this.selector = new CategoryExplorerWidget(new CategorySelectHandler(){

                @Override
                public void selected(String sel) {
                    CategorySelector.this.selectedPath = sel;
                }
            });
            vert.add((Widget)this.selector);
            vert.add((Widget)this.ok);
            this.addRow((Widget)vert);
            this.ok.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (CategorySelector.this.selectedPath != null && !"".equals(CategorySelector.this.selectedPath)) {
                        AssetCategoryEditor.this.addToCategory(CategorySelector.this.selectedPath);
                    }
                    CategorySelector.this.hide();
                }
            });
        }
    }
}

