/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ModuleAssemblerConfiguration;
import org.drools.guvnor.server.builder.PackageAssemblerBase;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.selector.AssetSelector;
import org.drools.guvnor.server.selector.BuiltInSelector;
import org.drools.guvnor.server.selector.SelectorManager;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepositoryException;
import org.drools.rule.Package;

public class PackageAssembler
extends PackageAssemblerBase {
    private static final LoggingHelper log = LoggingHelper.getLogger(PackageAssembler.class);
    private ModuleAssemblerConfiguration configuration;
    private AssetSelector selector;

    @Override
    public void init(ModuleItem moduleItem, ModuleAssemblerConfiguration moduleAssemblerConfiguration) {
        this.moduleItem = moduleItem;
        this.configuration = moduleAssemblerConfiguration == null ? new ModuleAssemblerConfiguration() : moduleAssemblerConfiguration;
        this.createBuilder();
        this.src = new StringBuilder();
    }

    @Override
    public void compile() {
        if (this.setUpPackage()) {
            this.buildPackage();
        }
        if (!this.hasErrors()) {
            byte[] compiledPackageByte = this.getCompiledBinary();
            this.moduleItem.updateCompiledBinary((InputStream)new ByteArrayInputStream(compiledPackageByte));
            this.moduleItem.updateBinaryUpToDate(true);
            this.moduleItem.getRulesRepository().save();
        }
    }

    private void buildPackage() {
        if (this.setUpSelector()) {
            this.loadAssets();
        }
    }

    private void loadAssets() {
        StringBuilder includedAssets = new StringBuilder("Following assets have been included in package build: ");
        this.loadDRLAssets(includedAssets);
        this.loadAllButDRLAssets(includedAssets);
        log.info(includedAssets.toString());
    }

    private void loadAllButDRLAssets(StringBuilder includedAssets) {
        Iterator<AssetItem> iterator = this.getAllAssets();
        while (iterator.hasNext()) {
            AssetItem asset = iterator.next();
            if (asset.getFormat().equals("drl") || !this.assetCanBeAdded(asset)) continue;
            this.addAsset(includedAssets, asset);
        }
    }

    private void loadDRLAssets(StringBuilder includedAssets) {
        Iterator<AssetItem> drlAssetItemIterator = this.getAssetItemIterator("drl");
        while (drlAssetItemIterator.hasNext()) {
            AssetItem asset = drlAssetItemIterator.next();
            if (!this.assetCanBeAdded(asset)) continue;
            this.addAsset(includedAssets, asset);
        }
    }

    private void addAsset(StringBuilder includedAssets, AssetItem asset) {
        this.buildAsset(asset);
        includedAssets.append(asset.getName()).append(", ");
    }

    private boolean assetCanBeAdded(AssetItem asset) {
        return !asset.isArchived() && this.selector.isAssetAllowed(asset);
    }

    private boolean setUpSelector() {
        this.selector = "customSelector".equals(this.configuration.getBuildMode()) ? SelectorManager.getInstance().getSelector(this.configuration.getCustomSelectorConfigName()) : ("BuiltInSelector".equals(this.configuration.getBuildMode()) ? this.setUpBuiltInSelector() : SelectorManager.getInstance().getSelector(null));
        if (this.selector == null) {
            this.errorLogger.addError(this.moduleItem, "The selector named " + this.configuration.getCustomSelectorConfigName() + " is not available.");
            return false;
        }
        return true;
    }

    private AssetSelector setUpBuiltInSelector() {
        BuiltInSelector builtInSelector = (BuiltInSelector)SelectorManager.getInstance().getSelector("BuiltInSelector");
        builtInSelector.setStatusOperator(this.configuration.getStatusOperator());
        builtInSelector.setStatus(this.configuration.getStatusDescriptionValue());
        builtInSelector.setEnableStatusSelector(this.configuration.isEnableStatusSelector());
        builtInSelector.setCategory(this.configuration.getCategoryValue());
        builtInSelector.setCategoryOperator(this.configuration.getCategoryOperator());
        builtInSelector.setEnableCategorySelector(this.configuration.isEnableCategorySelector());
        return builtInSelector;
    }

    @Override
    public boolean isModuleConfigurationInError() {
        return this.errorLogger.hasErrors() && this.errorLogger.getErrors().get(0).isModuleItem();
    }

    @Override
    public byte[] getCompiledBinary() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)bout);
            out.writeObject(this.getBinaryPackage());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("An error occurred building the module [" + this.moduleItem.getName() + "]: " + e.getMessage());
            throw new RulesRepositoryException("An error occurred building the module.", (Throwable)e);
        }
        return bout.toByteArray();
    }

    private Package[] getBinaryPackage() {
        if (this.hasErrors()) {
            throw new IllegalStateException("There is no package available, as there were errors.");
        }
        return this.builder.getPackages();
    }

    public BRMSPackageBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public String getCompiledSource() {
        this.src = new StringBuilder();
        this.loadHeaderToSource();
        this.loadDSLFiles();
        this.loadFunctionsToSource();
        this.loadRuleAssets();
        return this.src.toString();
    }

    private void loadRuleAssets() {
        Iterator<AssetItem> assetItemIterator = this.getAllAssets();
        while (assetItemIterator.hasNext()) {
            this.addRuleAsset(assetItemIterator.next());
        }
    }

    private void addRuleAsset(AssetItem asset) {
        if (!asset.isArchived() && !asset.getDisabled()) {
            ContentHandler handler = ContentManager.getHandler(asset.getFormat());
            if (handler.isRuleAsset()) {
                IRuleAsset ruleAsset = (IRuleAsset)((Object)handler);
                ruleAsset.assembleDRL(this.builder, asset, this.src);
            }
            this.src.append("\n\n");
        }
    }

    @Override
    public List<AssetItem> getAllNotToIncludeAssets() {
        this.setUpSelector();
        ArrayList<AssetItem> notIncluded = new ArrayList<AssetItem>();
        Iterator<AssetItem> iterator = this.getAllAssets();
        while (iterator.hasNext()) {
            AssetItem asset = iterator.next();
            if (this.assetCanBeAdded(asset)) continue;
            notIncluded.add(asset);
        }
        return notIncluded;
    }
}

