/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.drools.guvnor.server.util.AssetEditorConfigElement;
import org.drools.guvnor.server.util.AssetEditorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetEditorConfigurationParser {
    private static final Logger log = LoggerFactory.getLogger(AssetEditorConfigurationParser.class);
    private static final String ASSETEDITOR_CONFIG = "/asseteditors.xml";
    private List<AssetEditorConfiguration> assetEditors;

    public List<AssetEditorConfiguration> getAssetEditors() {
        if (this.assetEditors == null) {
            this.assetEditors = this.readConfig();
        }
        return this.assetEditors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AssetEditorConfiguration> readConfig() {
        ArrayList<AssetEditorConfiguration> assetEditors = new ArrayList<AssetEditorConfiguration>();
        InputStream in = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            in = this.getClass().getResourceAsStream(ASSETEDITOR_CONFIG);
            XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
            AssetEditorConfiguration configuration = null;
            while (eventReader.hasNext()) {
                AssetEditorConfigElement element;
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    element = AssetEditorConfigElement.forName(event.asStartElement().getName().getLocalPart());
                    switch (element) {
                        case ASSET_EDITOR: {
                            configuration = new AssetEditorConfiguration();
                            break;
                        }
                        case FORMAT: {
                            event = eventReader.nextEvent();
                            if (event.isCharacters()) {
                                configuration.setFormat(event.asCharacters().getData());
                                break;
                            }
                            if (!event.isEndElement()) break;
                            configuration.setFormat("");
                            break;
                        }
                        case TITLE: {
                            event = eventReader.nextEvent();
                            if (event.isCharacters()) {
                                configuration.setTitle(event.asCharacters().getData());
                                break;
                            }
                            if (!event.isEndElement()) break;
                            configuration.setTitle("");
                            break;
                        }
                        case ICON: {
                            event = eventReader.nextEvent();
                            if (event.isCharacters()) {
                                configuration.setIcon(event.asCharacters().getData());
                                break;
                            }
                            if (!event.isEndElement()) break;
                            configuration.setIcon("");
                            break;
                        }
                        case CLASS: {
                            event = eventReader.nextEvent();
                            if (event.isCharacters()) {
                                configuration.setEditorClass(event.asCharacters().getData());
                                break;
                            }
                            if (!event.isEndElement()) break;
                            configuration.setEditorClass("");
                        }
                    }
                }
                if (!event.isEndElement() || (element = AssetEditorConfigElement.forName(event.asEndElement().getName().getLocalPart())) != AssetEditorConfigElement.ASSET_EDITOR) continue;
                assetEditors.add(configuration);
            }
        }
        catch (XMLStreamException e) {
            log.error("Failed to parse Asset editor configuration file", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return assetEditors;
    }

    public static void main(String[] agrs) {
        AssetEditorConfigurationParser a = new AssetEditorConfigurationParser();
        a.readConfig();
    }
}

