/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.io.Externalizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.core.util.StringUtils;
import org.drools.io.Resource;
import org.drools.io.impl.BaseResource;
import org.drools.io.impl.FileSystemResource;
import org.drools.io.internal.InternalResource;
import org.drools.util.ClassLoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathResource
extends BaseResource
implements InternalResource,
Externalizable {
    private String path;
    private String encoding;
    private ClassLoader classLoader;
    private Class<?> clazz;
    private long lastRead;

    public ClassPathResource() {
    }

    public ClassPathResource(String path) {
        this(path, null, null, null);
    }

    public ClassPathResource(String path, Class<?> clazz) {
        this(path, null, clazz, null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        this(path, null, null, classLoader);
    }

    public ClassPathResource(String path, String encoding) {
        this(path, encoding, null, null);
    }

    public ClassPathResource(String path, String encoding, Class<?> clazz) {
        this(path, encoding, clazz, null);
    }

    public ClassPathResource(String path, String encoding, ClassLoader classLoader) {
        this(path, encoding, null, classLoader);
    }

    public ClassPathResource(String path, String encoding, Class<?> clazz, ClassLoader classLoader) {
        ClassLoader[] classLoaderArray;
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        this.path = path;
        this.encoding = encoding;
        this.clazz = clazz;
        if (classLoader == null) {
            classLoaderArray = null;
        } else {
            ClassLoader[] classLoaderArray2 = new ClassLoader[1];
            classLoaderArray = classLoaderArray2;
            classLoaderArray2[0] = classLoader;
        }
        this.classLoader = ClassLoaderUtil.getClassLoader(classLoaderArray, clazz, false);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.path);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.path = (String)in.readObject();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.lastRead = this.getLastModified();
        return this.getURL().openStream();
    }

    @Override
    public URL getURL() throws IOException {
        URL url = null;
        if (this.clazz != null) {
            url = this.clazz.getResource(this.path);
        }
        if (url == null) {
            url = this.classLoader.getResource(this.path);
        }
        if (url == null) {
            throw new FileNotFoundException("'" + this.path + "' cannot be opened because it does not exist");
        }
        return url;
    }

    @Override
    public boolean hasURL() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getLastModified() {
        block25: {
            block24: {
                block23: {
                    conn = null;
                    try {
                        try {
                            block26: {
                                conn = this.getURL().openConnection();
                                if (!(conn instanceof JarURLConnection)) break block26;
                                jarURL = ((JarURLConnection)conn).getJarFileURL();
                                if (jarURL.getProtocol().equals("file")) {
                                    var3_5 = new File(jarURL.getFile()).lastModified();
                                    var11_7 = null;
                                    if (conn == null) return var3_5;
                                    break block23;
                                }
                                jarConn = null;
                                try {
                                    jarConn = jarURL.openConnection();
                                    var4_17 = jarConn.getLastModified();
                                    var8_19 = null;
                                    ** GOTO lbl-1000
                                }
                                catch (IOException e) {
                                    block27: {
                                        try {
                                            var5_25 = -1L;
                                            var8_20 = null;
                                        }
                                        catch (Throwable var7_26) {
                                            var8_21 = null;
                                            try {
                                                if (jarConn == null) throw var7_26;
                                                jarConn.getInputStream().close();
                                                throw var7_26;
                                            }
                                            catch (IOException e) {
                                                // empty catch block
                                            }
                                            throw var7_26;
                                        }
lbl-1000:
                                        // 1 sources

                                        try {}
                                        catch (IOException e) {
                                            break block24;
                                        }
                                        if (jarConn != null) {
                                            jarConn.getInputStream().close();
                                        }
                                        break block24;
                                        ** try [egrp 4[TRYBLOCK] [4 : 105->119)] { 
lbl44:
                                        // 1 sources

                                        if (jarConn != null) {
                                            jarConn.getInputStream().close();
                                        }
                                        break block27;
lbl47:
                                        // 1 sources

                                        catch (IOException e) {
                                        }
                                    }
                                    var11_9 = null;
                                    if (conn == null) return var5_25;
                                    try {
                                        conn.getInputStream().close();
                                        return var5_25;
                                    }
                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                    return var5_25;
                                }
                            }
                            jarURL = conn.getLastModified();
                            break block25;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Unable to get LastModified for ClasspathResource", e);
                        }
                    }
                    catch (Throwable var10_27) {
                        var11_11 = null;
                        if (conn == null) throw var10_27;
                        try {}
                        catch (IOException e) {
                            throw var10_27;
                        }
                        conn.getInputStream().close();
                        throw var10_27;
                    }
                }
                ** try [egrp 5[TRYBLOCK] [14 : 159->169)] { 
lbl75:
                // 1 sources

                conn.getInputStream().close();
                return var3_5;
lbl77:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var3_5;
            }
            var11_8 = null;
            if (conn == null) return var4_17;
            try {}
            catch (IOException e) {
                // empty catch block
                return var4_17;
            }
            conn.getInputStream().close();
            return var4_17;
        }
        var11_10 = null;
        if (conn == null) return jarURL;
        try {}
        catch (IOException e) {
            // empty catch block
            return jarURL;
        }
        conn.getInputStream().close();
        return jarURL;
    }

    @Override
    public long getLastRead() {
        return this.lastRead;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.getInputStream());
    }

    @Override
    public boolean isDirectory() {
        try {
            URL url = this.getURL();
            if (!"file".equals(url.getProtocol())) {
                return false;
            }
            File file = new File(StringUtils.toURI(url.toString()).getSchemeSpecificPart());
            return file.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Collection<Resource> listResources() {
        try {
            URL url = this.getURL();
            if ("file".equals(url.getProtocol())) {
                File dir = new File(StringUtils.toURI(url.toString()).getSchemeSpecificPart());
                ArrayList<Resource> resources = new ArrayList<Resource>();
                for (File file : dir.listFiles()) {
                    resources.add(new FileSystemResource(file));
                }
                return resources;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException("This Resource cannot be listed, or is not a directory");
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getPath() {
        return this.path;
    }

    protected void setLastRead(long lastRead) {
        this.lastRead = lastRead;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClassPathResource)) {
            return false;
        }
        ClassPathResource other = (ClassPathResource)object;
        return this.path.equals(other.path) && this.clazz == other.clazz && this.classLoader == other.classLoader;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "[ClassPathResource path='" + this.path + "']";
    }
}

