/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.DescrBuildError;
import org.drools.core.util.StringUtils;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Declaration;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.spi.AcceptsClassObjectType;
import org.drools.spi.DeclarationScopeResolver;
import org.drools.spi.KnowledgeHelper;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.SimpleTemplateRegistry;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaRuleBuilderHelper {
    protected static TemplateRegistry RULE_REGISTRY = new SimpleTemplateRegistry();
    protected static TemplateRegistry INVOKER_REGISTRY = new SimpleTemplateRegistry();
    protected static String JAVA_RULE_MVEL = "javaRule.mvel";
    protected static String JAVA_INVOKERS_MVEL = "javaInvokers.mvel";

    public static void setConsequenceTemplate(String name) {
        JAVA_RULE_MVEL = name;
        RULE_REGISTRY = new SimpleTemplateRegistry();
    }

    public static void setInvokerTemplate(String name) {
        JAVA_INVOKERS_MVEL = name;
        INVOKER_REGISTRY = new SimpleTemplateRegistry();
    }

    public static synchronized TemplateRegistry getRuleTemplateRegistry(ClassLoader cl) {
        if (!RULE_REGISTRY.contains("rules")) {
            ParserConfiguration pconf = new ParserConfiguration();
            pconf.setClassLoader(cl);
            ParserContext pctx = new ParserContext(pconf);
            RULE_REGISTRY.addNamedTemplate("rules", TemplateCompiler.compileTemplate((InputStream)JavaRuleBuilderHelper.class.getResourceAsStream(JAVA_RULE_MVEL), (ParserContext)pctx));
            TemplateRuntime.execute((CompiledTemplate)RULE_REGISTRY.getNamedTemplate("rules"), null, (TemplateRegistry)RULE_REGISTRY);
        }
        return RULE_REGISTRY;
    }

    public static synchronized TemplateRegistry getInvokerTemplateRegistry(ClassLoader cl) {
        if (!INVOKER_REGISTRY.contains("invokers")) {
            ParserConfiguration pconf = new ParserConfiguration();
            pconf.setClassLoader(cl);
            ParserContext pctx = new ParserContext(pconf);
            INVOKER_REGISTRY.addNamedTemplate("invokers", TemplateCompiler.compileTemplate((InputStream)JavaRuleBuilderHelper.class.getResourceAsStream(JAVA_INVOKERS_MVEL), (ParserContext)pctx));
            TemplateRuntime.execute((CompiledTemplate)INVOKER_REGISTRY.getNamedTemplate("invokers"), null, (TemplateRegistry)INVOKER_REGISTRY);
        }
        return INVOKER_REGISTRY;
    }

    public static JavaAnalysisResult createJavaAnalysisResult(RuleBuildContext context, String consequenceName, Map<String, Declaration> decls) {
        RuleDescr ruleDescr = context.getRuleDescr();
        context.getDeclarationResolver();
        BoundIdentifiers bindings = new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses(decls), context.getPackageBuilder().getGlobals(), null, KnowledgeHelper.class);
        String consequenceStr = "default".equals(consequenceName) ? (String)ruleDescr.getConsequence() : (String)ruleDescr.getNamedConsequences().get(consequenceName);
        consequenceStr = consequenceStr + "\n";
        return (JavaAnalysisResult)context.getDialect().analyzeBlock(context, ruleDescr, consequenceStr, bindings);
    }

    public static Map<String, Object> createConsequenceContext(RuleBuildContext context, String consequenceName, String className, String consequenceText, Map<String, Declaration> decls, BoundIdentifiers usedIdentifiers) {
        Declaration[] declarations = new Declaration[usedIdentifiers.getDeclrClasses().size()];
        String[] declrStr = new String[declarations.length];
        int j = 0;
        Iterator<String> i$ = usedIdentifiers.getDeclrClasses().keySet().iterator();
        while (i$.hasNext()) {
            String str;
            declrStr[j] = str = i$.next();
            declarations[j++] = decls.get(str);
        }
        Arrays.sort(declarations, RuleTerminalNode.SortDeclarations.instance);
        for (int i = 0; i < declrStr.length; ++i) {
            declrStr[i] = declarations[i].getIdentifier();
        }
        context.getRule().setRequiredDeclarationsForConsequence(consequenceName, declrStr);
        Map<String, Object> map = JavaRuleBuilderHelper.createVariableContext(className, consequenceText, context, declarations, null, usedIdentifiers.getGlobals());
        map.put("consequenceName", consequenceName);
        Integer[] indexes = new Integer[declarations.length];
        Boolean[] notPatterns = new Boolean[declarations.length];
        int length = declarations.length;
        for (int i = 0; i < length; ++i) {
            indexes[i] = i;
            Boolean bl = notPatterns[i] = declarations[i].getExtractor() instanceof AcceptsClassObjectType ? Boolean.FALSE : Boolean.TRUE;
            if (indexes[i] != -1) continue;
            context.addError(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), null, "Internal Error : Unable to find declaration in list while generating the consequence invoker"));
        }
        map.put("indexes", indexes);
        map.put("notPatterns", notPatterns);
        return map;
    }

    public static Map<String, Object> createVariableContext(String className, String text, RuleBuildContext context, Declaration[] declarations, Declaration[] localDeclarations, Map<String, Class<?>> globals) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("className", className);
        map.put("methodName", className);
        map.put("package", context.getPkg().getName());
        map.put("ruleClassName", StringUtils.ucFirst(context.getRuleDescr().getClassName()));
        map.put("invokerClassName", context.getRuleDescr().getClassName() + StringUtils.ucFirst(className) + "Invoker");
        if (text != null) {
            map.put("text", text);
            map.put("hashCode", text.hashCode());
        }
        map.put("declarations", declarations);
        if (localDeclarations != null) {
            map.put("localDeclarations", localDeclarations);
        }
        String[] globalStr = new String[globals.size()];
        String[] globalTypes = new String[globals.size()];
        int i = 0;
        for (Map.Entry<String, Class<?>> entry : globals.entrySet()) {
            globalStr[i] = entry.getKey();
            globalTypes[i] = entry.getValue().getName().replace('$', '.');
            ++i;
        }
        map.put("globals", globalStr);
        map.put("globalTypes", globalTypes);
        return map;
    }

    public static void generateTemplates(String ruleTemplate, String invokerTemplate, RuleBuildContext context, String className, Map vars, Object invokerLookup, BaseDescr descrLookup) {
        JavaRuleBuilderHelper.generateMethodTemplate(ruleTemplate, context, vars);
        JavaRuleBuilderHelper.generateInvokerTemplate(invokerTemplate, context, className, vars, invokerLookup, descrLookup);
    }

    public static void generateMethodTemplate(String ruleTemplate, RuleBuildContext context, Map vars) {
        TemplateRegistry registry = JavaRuleBuilderHelper.getRuleTemplateRegistry(context.getPackageBuilder().getRootClassLoader());
        context.addMethod((String)TemplateRuntime.execute((CompiledTemplate)registry.getNamedTemplate(ruleTemplate), null, (VariableResolverFactory)new MapVariableResolverFactory(vars), (TemplateRegistry)registry));
    }

    public static void generateInvokerTemplate(String invokerTemplate, RuleBuildContext context, String className, Map vars, Object invokerLookup, BaseDescr descrLookup) {
        TemplateRegistry registry = JavaRuleBuilderHelper.getInvokerTemplateRegistry(context.getPackageBuilder().getRootClassLoader());
        String invokerClassName = context.getPkg().getName() + "." + context.getRuleDescr().getClassName() + StringUtils.ucFirst(className) + "Invoker";
        context.getInvokers().put(invokerClassName, (String)TemplateRuntime.execute((CompiledTemplate)registry.getNamedTemplate(invokerTemplate), null, (VariableResolverFactory)new MapVariableResolverFactory(vars), (TemplateRegistry)registry));
        context.getInvokerLookups().put(invokerClassName, invokerLookup);
        context.getDescrLookups().put(invokerClassName, descrLookup);
    }

    public static void registerInvokerBytecode(RuleBuildContext context, Map<String, Object> vars, byte[] bytecode, Object invokerLookup) {
        String packageName = (String)vars.get("package");
        String invokerClassName = (String)vars.get("invokerClassName");
        String className = packageName + "." + invokerClassName;
        String resourceName = className.replace('.', '/') + ".class";
        JavaDialectRuntimeData data = (JavaDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("java");
        data.write(resourceName, bytecode);
        data.putInvoker(className, invokerLookup);
    }
}

