/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.drools.util.CodedHierarchyImpl;
import org.drools.util.HierarchyEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyEncoderImpl<T>
extends CodedHierarchyImpl<T>
implements HierarchyEncoder<T>,
Externalizable {
    private ImmutableBitSet bottom = new ImmutableBitSet();

    @Override
    public BitSet getBottom() {
        return this.bottom;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.bottom);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.bottom = (ImmutableBitSet)objectInput.readObject();
    }

    @Override
    public BitSet encode(T member, Collection<T> parents) {
        BitSet existing = this.getCode(member);
        if (existing != null) {
            return existing;
        }
        CodedHierarchyImpl.HierNode<T> node = new CodedHierarchyImpl.HierNode<T>(member);
        Set<CodedHierarchyImpl.HierNode<T>> parentNodes = this.floor(parents);
        for (CodedHierarchyImpl.HierNode<T> parentNode : parentNodes) {
            node.addParent(parentNode);
            parentNode.addChild(node);
        }
        this.encode(node);
        this.add(node);
        return node.getBitMask();
    }

    @Override
    protected void add(CodedHierarchyImpl.HierNode<T> node) {
        super.add(node);
        this.bottom.merge(node.getBitMask());
    }

    @Override
    public void clear() {
        super.clear();
        this.bottom = new ImmutableBitSet();
    }

    List<T> ancestorValues(T name) {
        ArrayList<T> anx = new ArrayList<T>();
        Set<CodedHierarchyImpl.HierNode<T>> nodes = this.ancestorNodes(this.getNode(name));
        for (CodedHierarchyImpl.HierNode<T> node : nodes) {
            anx.add(node.getValue());
        }
        return anx;
    }

    protected void encode(CodedHierarchyImpl.HierNode<T> node) {
        Collection<CodedHierarchyImpl.HierNode<T>> parents = node.getParents();
        switch (parents.size()) {
            case 0: {
                BitSet zero = new BitSet();
                if (this.hasKey(zero)) {
                    CodedHierarchyImpl.HierNode<Object> root = this.getNodeByKey(zero);
                    if (root.getValue() != null) {
                        this.fixedRoot = true;
                        CodedHierarchyImpl.HierNode<Object> previousRoot = root;
                        root = new CodedHierarchyImpl.HierNode<Object>((Object)null);
                        root.addChild(previousRoot);
                        previousRoot.addParent(root);
                        root.setBitMask(zero);
                        this.propagate(previousRoot, this.freeBit(root));
                        this.add(root);
                    }
                    node.addParent(root);
                    this.updateMask(node, this.increment(root.getBitMask(), this.freeBit(root)));
                    break;
                }
                this.updateMask(node, new BitSet());
                break;
            }
            case 1: {
                CodedHierarchyImpl.HierNode<T> parent = parents.iterator().next();
                this.updateMask(node, this.increment(parent.getBitMask(), this.freeBit(parent)));
                break;
            }
            default: {
                this.inheritMerged(node);
                this.resolveConflicts(node);
            }
        }
    }

    protected void resolveConflicts(CodedHierarchyImpl.HierNode<T> x) {
        boolean conflicted = false;
        ArrayList nodes = new ArrayList(this.getNodes());
        for (CodedHierarchyImpl.HierNode hierNode : nodes) {
            int sub;
            if (!this.incomparable(x, hierNode)) continue;
            int sup = this.superset(hierNode, x);
            if (sup == 0) {
                x.setBitMask(this.increment(x.getBitMask(), this.freeBit(x)));
                this.propagate(hierNode, this.freeBit(x));
            }
            if (sup > 0) {
                this.updateMask(x, this.increment(x.getBitMask(), this.freeBit(x)));
            }
            if ((sub = this.superset(x, hierNode)) <= 0) continue;
            this.modify(x, hierNode);
            conflicted = true;
        }
        if (conflicted) {
            this.inheritMerged(x);
        }
    }

    protected void modify(CodedHierarchyImpl.HierNode<T> x, CodedHierarchyImpl.HierNode<T> y) {
        int i = this.freeBit(x);
        Collection<CodedHierarchyImpl.HierNode<T>> py = y.getParents();
        BitSet t = new BitSet();
        for (CodedHierarchyImpl.HierNode<T> parent : py) {
            t.or(parent.getBitMask());
        }
        BitSet d = this.singleBitDiff(t, y.getBitMask());
        int inDex = d.nextSetBit(0);
        if (inDex < 0) {
            this.propagate(y, Math.max(i, this.freeBit(y)));
        } else {
            Set<CodedHierarchyImpl.HierNode<T>> ancestors = this.ancestorNodes(x);
            HashSet<CodedHierarchyImpl.HierNode<T>> affectedAncestors = new HashSet<CodedHierarchyImpl.HierNode<T>>();
            for (CodedHierarchyImpl.HierNode<T> anc : ancestors) {
                if (!anc.getBitMask().get(inDex)) continue;
                affectedAncestors.add(anc);
            }
            if (affectedAncestors.size() == 0) {
                return;
            }
            Set<CodedHierarchyImpl.HierNode<T>> gcs = this.gcs(affectedAncestors);
            HashSet<CodedHierarchyImpl.HierNode<T>> affectedDescendants = new HashSet<CodedHierarchyImpl.HierNode<T>>();
            for (CodedHierarchyImpl.HierNode<T> g : gcs) {
                affectedDescendants.addAll(this.descendantNodes(g));
            }
            affectedDescendants.remove(x);
            BitSet desc = new BitSet();
            for (CodedHierarchyImpl.HierNode hierNode : affectedDescendants) {
                desc.or(hierNode.getBitMask());
            }
            if (desc.get(i)) {
                i = Math.max(i, desc.length() + 1);
            }
            int dx = this.firstOne(d);
            for (CodedHierarchyImpl.HierNode hierNode : affectedDescendants) {
                boolean keepsBit = false;
                for (CodedHierarchyImpl.HierNode sup : hierNode.getParents()) {
                    if (keepsBit || affectedDescendants.contains(sup) || !sup.getBitMask().get(inDex)) continue;
                    keepsBit = true;
                }
                BitSet subMask = hierNode.getBitMask();
                if (!keepsBit) {
                    subMask = this.decrement(subMask, dx);
                }
                subMask = this.increment(subMask, i);
                this.updateMask(hierNode, subMask);
            }
            inDex = d.nextSetBit(inDex + 1);
        }
    }

    protected void updateMask(CodedHierarchyImpl.HierNode<T> node, BitSet mask) {
        boolean in;
        boolean bl = in = node.getBitMask() != null && this.contains(node);
        if (in) {
            this.remove(node);
        }
        node.setBitMask(mask);
        if (in) {
            this.add(node);
        }
    }

    protected void inheritMerged(CodedHierarchyImpl.HierNode<T> x) {
        BitSet mask = new BitSet();
        for (CodedHierarchyImpl.HierNode<T> p : x.getParents()) {
            mask.or(p.getBitMask());
        }
        this.updateMask(x, mask);
    }

    protected Set<CodedHierarchyImpl.HierNode<T>> gcs(Set<CodedHierarchyImpl.HierNode<T>> set) {
        HashSet<CodedHierarchyImpl.HierNode<T>> s = new HashSet<CodedHierarchyImpl.HierNode<T>>();
        Iterator<CodedHierarchyImpl.HierNode<T>> iter = set.iterator();
        BitSet a = new BitSet();
        a.or(iter.next().getBitMask());
        while (iter.hasNext()) {
            a.and(iter.next().getBitMask());
        }
        for (CodedHierarchyImpl.HierNode node : this.getNodes()) {
            if (this.superset(node.getBitMask(), a) < 0) continue;
            s.add(node);
        }
        Set<CodedHierarchyImpl.HierNode<T>> cl = this.ceil(s);
        return cl;
    }

    protected Set<CodedHierarchyImpl.HierNode<T>> ceil(Set<CodedHierarchyImpl.HierNode<T>> s) {
        if (s.size() <= 1) {
            return s;
        }
        HashSet<CodedHierarchyImpl.HierNode<T>> ceil = new HashSet<CodedHierarchyImpl.HierNode<T>>(s);
        block0: for (CodedHierarchyImpl.HierNode<T> x : s) {
            for (CodedHierarchyImpl.HierNode<T> y : s) {
                if (this.superset(x, y) <= 0) continue;
                ceil.remove(x);
                continue block0;
            }
        }
        return ceil;
    }

    protected Set<CodedHierarchyImpl.HierNode<T>> floor(Set<CodedHierarchyImpl.HierNode<T>> s) {
        if (s.size() <= 1) {
            return s;
        }
        HashSet<CodedHierarchyImpl.HierNode<T>> ceil = new HashSet<CodedHierarchyImpl.HierNode<T>>(s);
        block0: for (CodedHierarchyImpl.HierNode<T> x : s) {
            for (CodedHierarchyImpl.HierNode<T> y : s) {
                if (this.superset(y, x) <= 0) continue;
                ceil.remove(x);
                continue block0;
            }
        }
        return ceil;
    }

    private Set<CodedHierarchyImpl.HierNode<T>> floor(Collection<T> parents) {
        HashSet<CodedHierarchyImpl.HierNode<T>> floor = new HashSet<CodedHierarchyImpl.HierNode<T>>();
        HashSet<CodedHierarchyImpl.HierNode<T>> subs = new HashSet<CodedHierarchyImpl.HierNode<T>>();
        for (T s : parents) {
            CodedHierarchyImpl.HierNode<T> x = this.getNode(s);
            subs.addAll(floor);
            boolean minimal = true;
            for (CodedHierarchyImpl.HierNode hierNode : subs) {
                if (this.superset(x, hierNode) > 0) {
                    floor.remove(hierNode);
                }
                if (this.superset(hierNode, x) <= 0) continue;
                minimal = false;
                break;
            }
            if (minimal) {
                floor.add(x);
            }
            subs.clear();
        }
        return floor;
    }

    protected void propagate(CodedHierarchyImpl.HierNode<T> y, int bit) {
        Set<CodedHierarchyImpl.HierNode<T>> descendants = this.descendantNodes(y);
        for (CodedHierarchyImpl.HierNode<T> s : descendants) {
            this.updateMask(s, this.increment(s.getBitMask(), bit));
        }
    }

    protected int freeBit(CodedHierarchyImpl.HierNode<T> x) {
        BitSet forbid = new BitSet();
        forbid.or(x.getBitMask());
        for (CodedHierarchyImpl.HierNode y : this.getNodes()) {
            if (this.superset(y, x) > 0) {
                forbid.or(y.getBitMask());
            }
            if (this.superset(x, y) >= 0) continue;
            BitSet diff = this.singleBitDiff(x.getBitMask(), y.getBitMask());
            forbid.or(diff);
        }
        return this.firstZero(forbid);
    }

    protected boolean incomparable(CodedHierarchyImpl.HierNode<T> c1, CodedHierarchyImpl.HierNode<T> c2) {
        if (c1 == c2) {
            return false;
        }
        Set<CodedHierarchyImpl.HierNode<T>> sup1 = this.ancestorNodes(c1);
        Set<CodedHierarchyImpl.HierNode<T>> sup2 = this.ancestorNodes(c2);
        return !sup1.contains(c2) && !sup2.contains(c1);
    }

    BitSet increment(BitSet id, int i) {
        BitSet x = new BitSet();
        x.or(id);
        x.set(i);
        return x;
    }

    BitSet decrement(BitSet id, int d) {
        BitSet x = new BitSet();
        x.or(id);
        x.clear(d);
        return x;
    }

    BitSet singleBitDiff(BitSet x, BitSet y) {
        BitSet t = new BitSet();
        t.or(x);
        t.flip(0, t.size());
        t.and(y);
        switch (t.cardinality()) {
            case 0: {
                return t;
            }
            case 1: {
                return t;
            }
        }
        return new BitSet();
    }

    int firstOne(BitSet t) {
        return t.nextSetBit(0);
    }

    int firstZero(BitSet t) {
        return t.nextClearBit(0);
    }

    private class ImmutableBitSet
    extends BitSet {
        private ImmutableBitSet() {
        }

        public void flip(int bitIndex) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void flip(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void set(int bitIndex) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void set(int bitIndex, boolean value) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void set(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void set(int fromIndex, int toIndex, boolean value) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void clear(int bitIndex) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void clear(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void clear() {
            throw new UnsupportedOperationException("Read Only");
        }

        public void and(BitSet set) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void or(BitSet set) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void xor(BitSet set) {
            throw new UnsupportedOperationException("Read Only");
        }

        public void andNot(BitSet set) {
            throw new UnsupportedOperationException("Read Only");
        }

        protected void merge(BitSet set) {
            super.or(set);
        }
    }
}

