/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.RuleSelectionEvent;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioWidget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.testing.Scenario;

public class ConfigWidget
extends Composite {
    public ConfigWidget(final Scenario sc, final String packageName, final ScenarioWidget scWidget) {
        final ListBox box = new ListBox(true);
        for (int i = 0; i < sc.getRules().size(); ++i) {
            box.addItem((String)sc.getRules().get(i));
        }
        HorizontalPanel filter = new HorizontalPanel();
        final Image add = DroolsGuvnorImages.INSTANCE.NewItem();
        add.setAltText(Constants.INSTANCE.AddANewRule());
        add.setTitle(Constants.INSTANCE.AddANewRule());
        add.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ConfigWidget.this.showRulePopup((Widget)event.getSource(), box, packageName, sc.getRules(), scWidget);
            }
        });
        final Image remove = DroolsGuvnorImages.INSTANCE.Trash();
        remove.setAltText(Constants.INSTANCE.RemoveSelectedRule());
        remove.setTitle(Constants.INSTANCE.RemoveSelectedRule());
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (box.getSelectedIndex() == -1) {
                    Window.alert((String)Constants.INSTANCE.PleaseChooseARuleToRemove());
                } else {
                    String r = box.getItemText(box.getSelectedIndex());
                    sc.getRules().remove(r);
                    box.removeItem(box.getSelectedIndex());
                }
            }
        });
        VerticalPanel actions = new VerticalPanel();
        actions.add((Widget)add);
        actions.add((Widget)remove);
        final ListBox drop = new ListBox();
        drop.addItem(Constants.INSTANCE.AllowTheseRulesToFire(), "inc");
        drop.addItem(Constants.INSTANCE.PreventTheseRulesFromFiring(), "exc");
        drop.addItem(Constants.INSTANCE.AllRulesMayFire());
        drop.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String s = drop.getValue(drop.getSelectedIndex());
                if (s.equals("inc")) {
                    sc.setInclusive(true);
                    add.setVisible(true);
                    remove.setVisible(true);
                    box.setVisible(true);
                } else if (s.equals("exc")) {
                    sc.setInclusive(false);
                    add.setVisible(true);
                    remove.setVisible(true);
                    box.setVisible(true);
                } else {
                    sc.getRules().clear();
                    box.clear();
                    box.setVisible(false);
                    add.setVisible(false);
                    remove.setVisible(false);
                }
            }
        });
        if (sc.getRules().size() > 0) {
            drop.setSelectedIndex(sc.isInclusive() ? 0 : 1);
        } else {
            drop.setSelectedIndex(2);
            box.setVisible(false);
            add.setVisible(false);
            remove.setVisible(false);
        }
        filter.add((Widget)drop);
        filter.add((Widget)box);
        filter.add((Widget)actions);
        this.initWidget((Widget)filter);
    }

    private void showRulePopup(Widget w, final ListBox box, String packageName, final List<String> filterList, ScenarioWidget scw) {
        final FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.RuleAsset(), Constants.INSTANCE.SelectRule());
        Widget ruleSelector = scw.getRuleSelectionWidget(packageName, new RuleSelectionEvent(){

            @Override
            public void ruleSelected(String r) {
                filterList.add(r);
                box.addItem(r);
                pop.hide();
            }
        });
        pop.addRow(ruleSelector);
        pop.show();
    }
}

