/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.moduleeditor.drools;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.rpc.SessionExpiredException;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.widgets.categorynav.CategoryExplorerWidget;
import org.drools.guvnor.client.widgets.categorynav.CategorySelectHandler;
import org.drools.guvnor.client.widgets.drools.tables.BuildPackageErrorsSimpleTable;

public class PackageBuilderWidget
extends Composite {
    private Module conf;
    private final FormStyleLayout buildWholePackageLayout = new FormStyleLayout();
    private final FormStyleLayout builtInSelectorLayout = new FormStyleLayout();
    private final FormStyleLayout customSelectorLayout = new FormStyleLayout();
    private String buildMode = "buildWholePackage";
    private final ClientFactory clientFactory;

    public PackageBuilderWidget(final Module conf, ClientFactory clientFactory) {
        this.conf = conf;
        this.clientFactory = clientFactory;
        FormStyleLayout layout = new FormStyleLayout();
        VerticalPanel container = new VerticalPanel();
        final VerticalPanel buildResults = new VerticalPanel();
        RadioButton wholePackageRadioButton = new RadioButton("action", Constants.INSTANCE.BuildWholePackage());
        RadioButton builtInSelectorRadioButton = new RadioButton("action", Constants.INSTANCE.BuildPackageUsingBuiltInSelector());
        RadioButton customSelectorRadioButton = new RadioButton("action", Constants.INSTANCE.BuildPackageUsingCustomSelector());
        wholePackageRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PackageBuilderWidget.this.buildWholePackageLayout.setVisible(true);
                PackageBuilderWidget.this.builtInSelectorLayout.setVisible(false);
                PackageBuilderWidget.this.customSelectorLayout.setVisible(false);
                PackageBuilderWidget.this.buildMode = "buildWholePackage";
            }
        });
        builtInSelectorRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PackageBuilderWidget.this.buildWholePackageLayout.setVisible(false);
                PackageBuilderWidget.this.builtInSelectorLayout.setVisible(true);
                PackageBuilderWidget.this.customSelectorLayout.setVisible(false);
                PackageBuilderWidget.this.buildMode = "BuiltInSelector";
            }
        });
        customSelectorRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PackageBuilderWidget.this.buildWholePackageLayout.setVisible(false);
                PackageBuilderWidget.this.builtInSelectorLayout.setVisible(false);
                PackageBuilderWidget.this.customSelectorLayout.setVisible(true);
                PackageBuilderWidget.this.buildMode = "customSelector";
            }
        });
        VerticalPanel verticalPanel = new VerticalPanel();
        HorizontalPanel wholePackageRadioButtonPanel = new HorizontalPanel();
        wholePackageRadioButtonPanel.add((Widget)wholePackageRadioButton);
        wholePackageRadioButtonPanel.add((Widget)new InfoPopup(Constants.INSTANCE.BuildWholePackage(), Constants.INSTANCE.BuildWholePackageTip()));
        verticalPanel.add((Widget)wholePackageRadioButtonPanel);
        HorizontalPanel builtInSelectorRadioButtonPanel = new HorizontalPanel();
        builtInSelectorRadioButtonPanel.add((Widget)builtInSelectorRadioButton);
        builtInSelectorRadioButtonPanel.add((Widget)new InfoPopup(Constants.INSTANCE.BuiltInSelector(), Constants.INSTANCE.BuiltInSelectorTip()));
        verticalPanel.add((Widget)builtInSelectorRadioButtonPanel);
        HorizontalPanel customSelectorRadioButtonPanel = new HorizontalPanel();
        customSelectorRadioButtonPanel.add((Widget)customSelectorRadioButton);
        customSelectorRadioButtonPanel.add((Widget)new InfoPopup(Constants.INSTANCE.CustomSelector(), Constants.INSTANCE.SelectorTip()));
        verticalPanel.add((Widget)customSelectorRadioButtonPanel);
        layout.addAttribute("", (Widget)verticalPanel);
        wholePackageRadioButton.setValue(Boolean.valueOf(true));
        this.buildWholePackageLayout.setVisible(true);
        this.builtInSelectorLayout.setVisible(false);
        this.customSelectorLayout.setVisible(false);
        layout.addRow((Widget)this.buildWholePackageLayout);
        this.builtInSelectorLayout.addRow((Widget)new HTML("&nbsp;&nbsp;<i>" + Constants.INSTANCE.BuildPackageUsingFollowingAssets() + "</i>"));
        HorizontalPanel builtInSelectorStatusPanel = new HorizontalPanel();
        final CheckBox enableStatusCheckBox = new CheckBox();
        enableStatusCheckBox.setValue(Boolean.valueOf(false));
        builtInSelectorStatusPanel.add((Widget)enableStatusCheckBox);
        builtInSelectorStatusPanel.add((Widget)new HTML("&nbsp;&nbsp;<i>" + Constants.INSTANCE.BuildPackageUsingBuiltInSelectorStatus() + " </i>"));
        final ListBox statusOperator = new ListBox();
        String[] vals = new String[]{"=", "!="};
        for (int i = 0; i < vals.length; ++i) {
            statusOperator.addItem(vals[i], vals[i]);
        }
        builtInSelectorStatusPanel.add((Widget)statusOperator);
        final TextBox statusValue = new TextBox();
        statusValue.setTitle(Constants.INSTANCE.WildCardsSearchTip());
        builtInSelectorStatusPanel.add((Widget)statusValue);
        this.builtInSelectorLayout.addRow((Widget)builtInSelectorStatusPanel);
        HorizontalPanel builtInSelectorCatPanel = new HorizontalPanel();
        final CheckBox enableCategoryCheckBox = new CheckBox();
        enableCategoryCheckBox.setValue(Boolean.valueOf(false));
        builtInSelectorCatPanel.add((Widget)enableCategoryCheckBox);
        builtInSelectorCatPanel.add((Widget)new HTML("&nbsp;&nbsp;<i>" + Constants.INSTANCE.BuildPackageUsingBuiltInSelectorCat() + " </i>"));
        final ListBox catOperator = new ListBox();
        String[] catVals = new String[]{"=", "!="};
        for (int i = 0; i < catVals.length; ++i) {
            catOperator.addItem(catVals[i], catVals[i]);
        }
        builtInSelectorCatPanel.add((Widget)catOperator);
        final CategoryExplorerWidget catChooser = new CategoryExplorerWidget(new CategorySelectHandler(){

            public void selected(String selectedPath) {
            }
        });
        ScrollPanel catScroll = new ScrollPanel((Widget)catChooser);
        catScroll.setAlwaysShowScrollBars(true);
        catScroll.setSize("300px", "130px");
        builtInSelectorCatPanel.add((Widget)catScroll);
        this.builtInSelectorLayout.addRow((Widget)builtInSelectorCatPanel);
        layout.addRow((Widget)this.builtInSelectorLayout);
        this.customSelectorLayout.setVisible(false);
        HorizontalPanel customSelectorPanel = new HorizontalPanel();
        customSelectorPanel.add((Widget)new HTML("&nbsp;&nbsp;<i>" + Constants.INSTANCE.BuildPackageUsingCustomSelectorSelector() + " </i>"));
        final ListBox customSelector = new ListBox();
        customSelector.setTitle(Constants.INSTANCE.WildCardsSearchTip());
        customSelectorPanel.add((Widget)customSelector);
        this.loadCustomSelectorList(customSelector);
        this.customSelectorLayout.addRow((Widget)customSelectorPanel);
        layout.addRow((Widget)this.customSelectorLayout);
        Button b = new Button(Constants.INSTANCE.BuildPackage());
        b.setTitle(Constants.INSTANCE.ThisWillValidateAndCompileAllTheAssetsInAPackage());
        b.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PackageBuilderWidget.this.doBuild((Panel)buildResults, statusOperator.getValue(statusOperator.getSelectedIndex()), statusValue.getText(), enableStatusCheckBox.getValue(), catOperator.getValue(catOperator.getSelectedIndex()), catChooser.getSelectedPath(), enableCategoryCheckBox.getValue(), customSelector.getSelectedIndex() != -1 ? customSelector.getValue(customSelector.getSelectedIndex()) : null);
            }
        });
        HorizontalPanel buildStuff = new HorizontalPanel();
        buildStuff.add((Widget)b);
        layout.addAttribute(Constants.INSTANCE.BuildBinaryPackage(), (Widget)buildStuff);
        layout.addRow((Widget)new HTML("<i><small>" + Constants.INSTANCE.BuildingPackageNote() + "</small></i>"));
        container.add((Widget)layout);
        container.add((Widget)buildResults);
        layout = new FormStyleLayout();
        Button snap = new Button(Constants.INSTANCE.CreateSnapshotForDeployment());
        snap.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PackageBuilderWidget.showSnapshotDialog(conf.getName(), null, PackageBuilderWidget.this.buildMode, statusOperator.getValue(statusOperator.getSelectedIndex()), statusValue.getText(), enableStatusCheckBox.getValue(), catOperator.getValue(catOperator.getSelectedIndex()), catChooser.getSelectedPath(), enableCategoryCheckBox.getValue(), customSelector.getSelectedIndex() != -1 ? customSelector.getValue(customSelector.getSelectedIndex()) : null);
            }
        });
        layout.addAttribute(Constants.INSTANCE.TakeSnapshot(), (Widget)snap);
        container.add((Widget)layout);
        this.initWidget((Widget)container);
    }

    private void loadCustomSelectorList(final ListBox customSelector) {
        RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
        repositoryService.getCustomSelectors((AsyncCallback)new GenericCallback<String[]>(){

            public void onSuccess(String[] list) {
                for (int i = 0; i < list.length; ++i) {
                    customSelector.addItem(list[i], list[i]);
                }
            }
        });
    }

    private void doBuild(final Panel buildResults, final String statusOperator, final String statusValue, final boolean enableStatusSelector, final String categoryOperator, final String category, final boolean enableCategorySelector, final String customSelector) {
        buildResults.clear();
        HorizontalPanel busy = new HorizontalPanel();
        busy.add((Widget)new Label(Constants.INSTANCE.ValidatingAndBuildingPackagePleaseWait()));
        busy.add((Widget)new Image(DroolsGuvnorImageResources.INSTANCE.redAnime()));
        buildResults.add((Widget)busy);
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
                moduleService.buildPackage(PackageBuilderWidget.this.conf.getUuid(), true, PackageBuilderWidget.this.buildMode, statusOperator, statusValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, customSelector, (AsyncCallback)new GenericCallback<BuilderResult>(){

                    public void onSuccess(BuilderResult result) {
                        LoadingPopup.close();
                        if (result == null || !result.hasLines()) {
                            PackageBuilderWidget.this.showSuccessfulBuild(buildResults);
                        } else {
                            PackageBuilderWidget.showBuilderErrors(result, buildResults, PackageBuilderWidget.this.clientFactory);
                        }
                    }

                    public void onFailure(Throwable t) {
                        buildResults.clear();
                        super.onFailure(t);
                    }
                });
            }
        });
    }

    public static void doBuildSource(final String uuid, final String name) {
        LoadingPopup.showMessage((String)Constants.INSTANCE.AssemblingPackageSource());
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
                moduleService.buildModuleSource(uuid, (AsyncCallback)new GenericCallback<String>(){

                    public void onSuccess(String content) {
                        PackageBuilderWidget.showSource(content, name);
                    }
                });
            }
        });
    }

    public static void showSource(String content, String name) {
        int windowWidth = Window.getClientWidth() / 2;
        int windowHeight = Window.getClientHeight() / 2;
        Image image = new Image(DroolsGuvnorImageResources.INSTANCE.viewSource());
        image.setAltText(Constants.INSTANCE.ViewSource());
        FormStylePopup pop = new FormStylePopup(image, Constants.INSTANCE.ViewingSourceFor0(name), Integer.valueOf(windowWidth));
        String[] rows = content.split("\n");
        FlexTable table = new FlexTable();
        for (int i = 0; i < rows.length; ++i) {
            table.setHTML(i, 0, "<span style='color:grey;'>" + (i + 1) + ".</span>");
            table.setHTML(i, 1, "<span style='color:green;' >|</span>");
            table.setHTML(i, 2, PackageBuilderWidget.addSyntaxHilights(rows[i]));
        }
        ScrollPanel scrollPanel = new ScrollPanel((Widget)table);
        scrollPanel.setHeight(windowHeight + "px");
        scrollPanel.setWidth(windowWidth + "px");
        pop.addRow((Widget)scrollPanel);
        LoadingPopup.close();
        pop.show();
    }

    private static String addSyntaxHilights(String text) {
        if (text.trim().startsWith("#")) {
            text = "<span style='color:green'>" + text + "</span>";
        } else {
            String[] keywords;
            for (String keyword : keywords = new String[]{"rule", "when", "then", "end", "accumulate", "collect", "from", "null", "over", "lock-on-active", "date-effective", "date-expires", "no-loop", "auto-focus", "activation-group", "agenda-group", "ruleflow-group", "entry-point", "duration", "package", "import", "dialect", "salience", "enabled", "attributes", "extend", "template", "query", "declare", "function", "global", "eval", "exists", "forall", "action", "reverse", "result", "end", "init"}) {
                if (!text.contains(keyword)) continue;
                text = text.replace(keyword, "<span style='color:red;'>" + keyword + "</span>");
            }
            text = PackageBuilderWidget.handleStrings("\"", text);
        }
        text = text.replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        return text;
    }

    private static String handleStrings(String character, String text) {
        int stringStart = text.indexOf(character);
        while (stringStart >= 0) {
            int stringEnd = text.indexOf(character, stringStart + 1);
            if (stringEnd < 0) {
                stringStart = -1;
                break;
            }
            String oldString = text.substring(stringStart, stringEnd + 1);
            String newString = "<span style='color:green;'>" + oldString + "</span>";
            String beginning = text.substring(0, stringStart);
            String end = text.substring(stringEnd + 1);
            text = beginning + newString + end;
            int searchStart = stringStart + newString.length() + 1;
            if (searchStart < text.length()) {
                stringStart = text.indexOf(character, searchStart);
                continue;
            }
            stringStart = -1;
        }
        return text;
    }

    private void showSuccessfulBuild(Panel buildResults) {
        buildResults.clear();
        VerticalPanel vert = new VerticalPanel();
        vert.add((Widget)new HTML(AbstractImagePrototype.create((ImageResource)DroolsGuvnorImageResources.INSTANCE.greenTick()).getHTML() + "<i>" + Constants.INSTANCE.PackageBuiltSuccessfully() + " " + this.conf.getLastModified() + "</i>"));
        String hyp = PackageBuilderWidget.getDownloadLink(this.conf);
        HTML html = new HTML("<a href='" + hyp + "' target='_blank'>" + Constants.INSTANCE.DownloadBinaryPackage() + "</a>");
        vert.add((Widget)html);
        buildResults.add((Widget)vert);
    }

    public static String getDownloadLink(Module conf) {
        String hurl = GWT.getModuleBaseURL() + "package/" + conf.getName();
        hurl = !conf.isSnapshot() ? hurl + "/" + "LATEST" : hurl + "/" + conf.getSnapshotName();
        String uri = hurl;
        return uri;
    }

    public static void showBuilderErrors(BuilderResult results, Panel buildResults, ClientFactory clientFactory) {
        buildResults.clear();
        BuildPackageErrorsSimpleTable errorsTable = new BuildPackageErrorsSimpleTable(clientFactory);
        errorsTable.setRowData(results.getLines());
        errorsTable.setRowCount(results.getLines().size());
        buildResults.add((Widget)errorsTable);
    }

    public static void showSnapshotDialog(final String packageName, final Command refreshCmd, final String buildMode, final String statusOperator, final String statusValue, final boolean enableStatusSelector, final String categoryOperator, final String category, final boolean enableCategorySelector, final String customSelector) {
        LoadingPopup.showMessage((String)Constants.INSTANCE.LoadingExistingSnapshots());
        final FormStylePopup form = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Snapshot(), Constants.INSTANCE.CreateASnapshotForDeployment());
        form.addRow((Widget)new HTML(Constants.INSTANCE.SnapshotDescription()));
        final VerticalPanel vert = new VerticalPanel();
        form.addAttribute(Constants.INSTANCE.ChooseOrCreateSnapshotName(), (Widget)vert);
        final ArrayList radioList = new ArrayList();
        final TextBox newName = new TextBox();
        final String newSnapshotText = Constants.INSTANCE.NEW() + ": ";
        ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        moduleService.listSnapshots(packageName, (AsyncCallback)new GenericCallback<SnapshotInfo[]>(){

            public void onSuccess(SnapshotInfo[] result) {
                for (int i = 0; i < result.length; ++i) {
                    RadioButton existing = new RadioButton("snapshotNameGroup", result[i].getName());
                    radioList.add(existing);
                    vert.add((Widget)existing);
                }
                HorizontalPanel newSnap = new HorizontalPanel();
                RadioButton newSnapRadio = new RadioButton("snapshotNameGroup", newSnapshotText);
                newSnap.add((Widget)newSnapRadio);
                newName.setEnabled(false);
                newSnapRadio.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        newName.setEnabled(true);
                    }
                });
                newSnap.add((Widget)newName);
                radioList.add(newSnapRadio);
                vert.add((Widget)newSnap);
                LoadingPopup.close();
            }
        });
        final TextBox comment = new TextBox();
        form.addAttribute(Constants.INSTANCE.Comment(), (Widget)comment);
        Button create = new Button(Constants.INSTANCE.CreateNewSnapshot());
        form.addAttribute("", (Widget)create);
        create.addClickHandler(new ClickHandler(){
            String name = "";

            public void onClick(ClickEvent event) {
                boolean replace = false;
                for (RadioButton but : radioList) {
                    if (!but.getValue().booleanValue()) continue;
                    this.name = but.getText();
                    if (but.getText().equals(newSnapshotText)) break;
                    replace = true;
                    break;
                }
                if (this.name.equals(newSnapshotText)) {
                    this.name = newName.getText();
                }
                if (this.name.equals("")) {
                    Window.alert((String)Constants.INSTANCE.YouHaveToEnterOrChoseALabelNameForTheSnapshot());
                    return;
                }
                LoadingPopup.showMessage((String)Constants.INSTANCE.PleaseWaitDotDotDot());
                ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
                moduleService.createModuleSnapshot(packageName, this.name, replace, comment.getText(), true, buildMode, statusOperator, statusValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, customSelector, (AsyncCallback)new GenericCallback<Void>(){

                    public void onSuccess(Void v) {
                        Window.alert((String)Constants.INSTANCE.TheSnapshotCalled0WasSuccessfullyCreated(name));
                        form.hide();
                        if (refreshCmd != null) {
                            refreshCmd.execute();
                        }
                        LoadingPopup.close();
                    }

                    public void onFailure(Throwable t) {
                        LoadingPopup.close();
                        if (t instanceof SessionExpiredException) {
                            1.showSessionExpiry();
                        } else if (t instanceof DetailedSerializationException) {
                            if (((DetailedSerializationException)t).getMessage().contains("Your package has not been built since last change")) {
                                ErrorPopup.showMessage((String)Constants.INSTANCE.PackageHadNotBeenBuiltWarning());
                            } else {
                                ErrorPopup.showMessage((DetailedSerializationException)((DetailedSerializationException)t));
                            }
                        } else {
                            String message = t.getMessage();
                            if (t.getMessage() != null && t.getMessage().trim().equals("0")) {
                                message = ((Constants)GWT.create(Constants.class)).CommunicationError();
                            }
                            ErrorPopup.showMessage((String)message);
                        }
                    }
                });
            }
        });
        form.show();
    }
}

