/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.simulation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.simulation.PathWidget;
import org.drools.guvnor.client.simulation.SimulationTestEventHandler;
import org.drools.guvnor.client.simulation.TimeLineWidget;
import org.drools.guvnor.shared.simulation.SimulationModel;
import org.drools.guvnor.shared.simulation.SimulationPathModel;
import org.drools.guvnor.shared.simulation.SimulationStepModel;
import org.drools.guvnor.shared.simulation.SimulationTestService;
import org.drools.guvnor.shared.simulation.SimulationTestServiceAsync;
import org.drools.guvnor.shared.simulation.command.AbstractCommandModel;

public class SimulationTestEditor
extends Composite
implements EditorWidget,
SimulationTestEventHandler {
    private static SimulationTestEditorBinder uiBinder = (SimulationTestEditorBinder)GWT.create(SimulationTestEditorBinder.class);
    private final SimulationTestServiceAsync simulationTestService = (SimulationTestServiceAsync)GWT.create(SimulationTestService.class);
    @UiField
    protected PushButton runSimulationButton;
    @UiField
    protected TabPanel pathTabPanel;
    @UiField(provided=true)
    protected TimeLineWidget timeLineWidget;
    private final Asset asset;
    private final SimulationModel simulation;
    private Map<SimulationPathModel, PathWidget> pathWidgetMap = new HashMap<SimulationPathModel, PathWidget>();

    public SimulationTestEditor(Asset asset, RuleViewer ruleViewer, ClientFactory clientFactory, EventBus eventBus) {
        this(asset);
    }

    public SimulationTestEditor(Asset asset) {
        this.asset = asset;
        this.simulation = (SimulationModel)asset.getContent();
        this.timeLineWidget = new TimeLineWidget(this);
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        for (SimulationPathModel path : this.simulation.getPaths().values()) {
            this.addPathWidget(path);
        }
        this.pathTabPanel.selectTab(0);
        this.timeLineWidget.setSimulation(this.simulation);
    }

    private void addPathWidget(SimulationPathModel path) {
        PathWidget pathWidget = new PathWidget(path, this);
        this.pathTabPanel.add((Widget)pathWidget, path.getName());
        this.pathWidgetMap.put(path, pathWidget);
    }

    private void removePathWidget(SimulationPathModel path) {
        PathWidget pathWidget = this.pathWidgetMap.remove(path);
        int pathWidgetIndex = this.pathTabPanel.getWidgetIndex((Widget)pathWidget);
        this.pathTabPanel.remove(pathWidgetIndex);
        this.pathTabPanel.selectTab(Math.max(0, pathWidgetIndex - 1));
    }

    @Override
    public void addPath() {
        SimulationPathModel path = SimulationPathModel.createNew();
        this.simulation.addPath(path);
        this.addPathWidget(path);
        this.timeLineWidget.addedPath(path);
        this.selectPath(path);
    }

    @Override
    public void removePath(SimulationPathModel path) {
        this.simulation.removePath(path);
        this.removePathWidget(path);
        this.timeLineWidget.removedPath(path);
    }

    public void selectPath(SimulationPathModel path) {
        PathWidget pathWidget = this.pathWidgetMap.get(path);
        this.pathTabPanel.selectTab(this.pathTabPanel.getWidgetIndex((Widget)pathWidget));
    }

    @Override
    public void selectStep(SimulationStepModel step) {
        SimulationPathModel path = step.getPath();
        PathWidget pathWidget = this.pathWidgetMap.get(path);
        this.pathTabPanel.selectTab(this.pathTabPanel.getWidgetIndex((Widget)pathWidget));
    }

    @Override
    public void addStep(SimulationPathModel path) {
        SimulationStepModel step = SimulationStepModel.createNew(path);
        path.addStep(step);
        this.pathWidgetMap.get(path).addedStep(step);
        this.timeLineWidget.addedStep(step);
    }

    @Override
    public void removeStep(SimulationStepModel step) {
        SimulationPathModel path = step.getPath();
        path.removeStep(step);
        this.pathWidgetMap.get(path).removedStep(step);
        this.timeLineWidget.removedStep(step);
    }

    @Override
    public void addCommand(AbstractCommandModel command) {
        SimulationStepModel step = command.getStep();
        SimulationPathModel path = step.getPath();
        step.addCommand(command);
        this.pathWidgetMap.get(path).addedCommand(command);
    }

    @Override
    public void moveUpCommand(AbstractCommandModel command) {
        SimulationStepModel step = command.getStep();
        if (step.getCommands().indexOf(command) == 0) {
            return;
        }
        SimulationPathModel path = step.getPath();
        step.moveUpCommand(command);
        this.pathWidgetMap.get(path).movedUpCommand(command);
    }

    @Override
    public void moveDownCommand(AbstractCommandModel command) {
        SimulationStepModel step = command.getStep();
        if (step.getCommands().indexOf(command) == step.getCommands().size() - 1) {
            return;
        }
        SimulationPathModel path = step.getPath();
        step.moveDownCommand(command);
        this.pathWidgetMap.get(path).movedDownCommand(command);
    }

    @Override
    public void removeCommand(AbstractCommandModel command) {
        SimulationStepModel step = command.getStep();
        SimulationPathModel path = step.getPath();
        step.removeCommand(command);
        this.pathWidgetMap.get(path).removedCommand(command);
    }

    @UiHandler(value={"runSimulationButton"})
    protected void runSimulation(ClickEvent event) {
        this.simulationTestService.runSimulation(this.asset.getMetaData().getModuleName(), this.simulation, (AsyncCallback<Void>)new GenericCallback<Void>(){

            public void onSuccess(Void result) {
                System.out.println("TODO ranSimulation");
            }
        });
    }

    protected static interface SimulationTestEditorBinder
    extends UiBinder<Widget, SimulationTestEditor> {
    }
}

