/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.simulation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.simulation.CommandWrapperWidget;
import org.drools.guvnor.client.simulation.SimulationTestEventHandler;
import org.drools.guvnor.client.simulation.command.AbstractCommandWidget;
import org.drools.guvnor.client.simulation.command.AddCommandWidget;
import org.drools.guvnor.shared.simulation.SimulationStepModel;
import org.drools.guvnor.shared.simulation.command.AbstractCommandModel;

public class StepWidget
extends Composite {
    private static StepWidgetBinder uiBinder = (StepWidgetBinder)GWT.create(StepWidgetBinder.class);
    @UiField
    protected VerticalPanel verticalPanel;
    @UiField
    protected PushButton addCommandButton;
    private final SimulationStepModel step;
    private final SimulationTestEventHandler simulationTestEventHandler;
    private Map<AbstractCommandModel, Integer> commandRowIndexMap = new HashMap<AbstractCommandModel, Integer>();

    public StepWidget(SimulationStepModel step, SimulationTestEventHandler simulationTestEventHandler) {
        this.step = step;
        this.simulationTestEventHandler = simulationTestEventHandler;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.addAllCommandWidgets();
    }

    private void refreshAllCommandWidgets() {
        for (AbstractCommandModel command : this.step.getCommands()) {
            this.removeCommandWidget(command);
        }
        this.addAllCommandWidgets();
    }

    private void addAllCommandWidgets() {
        for (AbstractCommandModel command : this.step.getCommands()) {
            this.addCommandWidget(command);
        }
    }

    private void addCommandWidget(AbstractCommandModel command) {
        int commandIndex = this.verticalPanel.getWidgetCount();
        AbstractCommandWidget commandWidget = AbstractCommandWidget.buildCommandWidget(command);
        CommandWrapperWidget commandWrapperWidget = new CommandWrapperWidget(commandWidget, this.simulationTestEventHandler);
        this.verticalPanel.add((Widget)commandWrapperWidget);
        this.commandRowIndexMap.put(command, commandIndex);
    }

    private void removeCommandWidget(AbstractCommandModel command) {
        int commandIndex = this.commandRowIndexMap.remove(command);
        this.verticalPanel.remove(commandIndex);
        for (Map.Entry<AbstractCommandModel, Integer> entry : this.commandRowIndexMap.entrySet()) {
            int otherCommandIndex = entry.getValue();
            if (otherCommandIndex <= commandIndex) continue;
            entry.setValue(otherCommandIndex - 1);
        }
    }

    @UiHandler(value={"addCommandButton"})
    protected void addCommand(ClickEvent event) {
        FormStylePopup addCommandPopup = new FormStylePopup();
        addCommandPopup.setTitle(Constants.INSTANCE.AddCommandPopupTitle());
        addCommandPopup.setWidth("400px");
        addCommandPopup.addRow((Widget)new AddCommandWidget(addCommandPopup, this.step, this.simulationTestEventHandler));
        addCommandPopup.show();
    }

    public void addedCommand(AbstractCommandModel command) {
        this.addCommandWidget(command);
    }

    public void movedUpCommand(AbstractCommandModel command) {
        this.refreshAllCommandWidgets();
    }

    public void movedDownCommand(AbstractCommandModel command) {
        this.refreshAllCommandWidgets();
    }

    public void removedCommand(AbstractCommandModel command) {
        this.removeCommandWidget(command);
    }

    protected static interface StepWidgetBinder
    extends UiBinder<Widget, StepWidget> {
    }
}

