/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.standalonededitor;

import java.util.ArrayList;
import java.util.UUID;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.standalonededitor.RuleAssetProvider;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.server.util.BRXMLPersistence;

public class BRLRuleAssetProvider
implements RuleAssetProvider {
    private final String packageName;
    private final String[] initialBRLs;
    private final RepositoryAssetService repositoryAssetService;

    public BRLRuleAssetProvider(String packageName, String[] initialBRLs, RepositoryAssetService repositoryAssetService) {
        this.packageName = packageName;
        this.initialBRLs = initialBRLs;
        this.repositoryAssetService = repositoryAssetService;
    }

    public Asset[] getRuleAssets() throws DetailedSerializationException {
        ArrayList<RuleModel> models = new ArrayList<RuleModel>(this.initialBRLs.length);
        ArrayList<Asset> assets = new ArrayList<Asset>(this.initialBRLs.length);
        for (String brl : this.initialBRLs) {
            models.add(BRXMLPersistence.getInstance().unmarshal(brl));
        }
        try {
            for (RuleModel ruleModel : models) {
                assets.add(this.createAsset(ruleModel));
            }
        }
        catch (Exception e) {
            for (Asset ruleAsset : assets) {
                this.repositoryAssetService.removeAsset(ruleAsset.getUuid());
            }
            if (e instanceof DetailedSerializationException) {
                throw (DetailedSerializationException)e;
            }
            throw new DetailedSerializationException("Error creating assets", e.getMessage());
        }
        return assets.toArray(new Asset[assets.size()]);
    }

    private Asset createAsset(RuleModel ruleModel) {
        Asset asset = new Asset();
        asset.setUuid("mock-" + UUID.randomUUID().toString());
        asset.setContent((PortableObject)ruleModel);
        asset.setName(ruleModel.name);
        asset.setFormat("brl");
        asset.setMetaData(this.createMetaData());
        asset.setState("temporal");
        return asset;
    }

    private MetaData createMetaData() {
        MetaData metaData = new MetaData();
        metaData.setModuleName(this.packageName);
        metaData.setModuleUUID("mock");
        return metaData;
    }
}

