/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.cache;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.drools.compiler.lang.dsl.DSLMappingEntry;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.workbench.models.datamodel.oracle.DSLActionSentence;
import org.drools.workbench.models.datamodel.oracle.DSLConditionSentence;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.kie.soup.project.datamodel.oracle.ExtensionKind;
import org.kie.workbench.common.services.backend.file.DSLFileFilter;
import org.kie.workbench.common.services.datamodel.spi.DataModelExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;

@Dependent
public class DSLExtension
implements DataModelExtension {
    public static final DSLFileFilter DSL_FILE_FILTER = new DSLFileFilter();
    private static final Logger log = LoggerFactory.getLogger(DSLExtension.class);

    public DirectoryStream.Filter<Path> getFilter() {
        return DSL_FILE_FILTER;
    }

    public List<DataModelExtension.ExtensionMapping<?>> getExtensions(Path path, String content) {
        DSLTokenizedMappingFile dslLoader = new DSLTokenizedMappingFile();
        ArrayList<DSLSentence> actionSentences = new ArrayList<DSLSentence>();
        ArrayList<DSLSentence> conditionSentences = new ArrayList<DSLSentence>();
        try {
            if (dslLoader.parseAndLoad((Reader)new StringReader(content))) {
                for (DSLMappingEntry entry : dslLoader.getMapping().getEntries()) {
                    DSLSentence sentence;
                    DSLMappingEntry definition;
                    if (entry.getSection() == DSLMappingEntry.CONDITION) {
                        definition = entry;
                        sentence = new DSLSentence();
                        sentence.setDrl(definition.getMappingValue());
                        sentence.setDefinition(definition.getMappingKey());
                        conditionSentences.add(sentence);
                        continue;
                    }
                    if (entry.getSection() != DSLMappingEntry.CONSEQUENCE) continue;
                    definition = entry;
                    sentence = new DSLSentence();
                    sentence.setDrl(definition.getMappingValue());
                    sentence.setDefinition(definition.getMappingKey());
                    actionSentences.add(sentence);
                }
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return Arrays.asList(new DSLMapping((ExtensionKind<DSLSentence>)DSLActionSentence.INSTANCE, actionSentences), new DSLMapping((ExtensionKind<DSLSentence>)DSLConditionSentence.INSTANCE, conditionSentences));
    }

    private static class DSLMapping
    implements DataModelExtension.ExtensionMapping<DSLSentence> {
        private ExtensionKind<DSLSentence> kind;
        private List<DSLSentence> sentences;

        DSLMapping(ExtensionKind<DSLSentence> kind, List<DSLSentence> sentences) {
            this.kind = kind;
            this.sentences = sentences;
        }

        public ExtensionKind<DSLSentence> getKind() {
            return this.kind;
        }

        public List<DSLSentence> getValues() {
            return this.sentences;
        }
    }
}

